/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.python.internal;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.UnaryOperator;
import org.openrewrite.Cursor;
import org.openrewrite.PrintOutputCapture;
import org.openrewrite.Tree;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.marker.OmitParentheses;
import org.openrewrite.java.tree.Comment;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JContainer;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.Statement;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypedTree;
import org.openrewrite.marker.Marker;
import org.openrewrite.marker.Markers;
import org.openrewrite.python.PythonVisitor;
import org.openrewrite.python.internal.PythonOperatorLookup;
import org.openrewrite.python.internal.PythonPrinterAdapter;
import org.openrewrite.python.marker.BuiltinDesugar;
import org.openrewrite.python.marker.GroupedStatement;
import org.openrewrite.python.marker.ImplicitNone;
import org.openrewrite.python.marker.ImportParens;
import org.openrewrite.python.marker.MagicMethodDesugar;
import org.openrewrite.python.marker.PythonExtraPadding;
import org.openrewrite.python.marker.SuppressNewline;
import org.openrewrite.python.tree.Py;
import org.openrewrite.python.tree.PyContainer;
import org.openrewrite.python.tree.PyLeftPadded;
import org.openrewrite.python.tree.PyRightPadded;
import org.openrewrite.python.tree.PySpace;

public class PythonPrinter<P>
extends PythonVisitor<PrintOutputCapture<P>> {
    final AdaptedMethods<Py, PySpace.Location, PyLeftPadded.Location, PyRightPadded.Location, PyContainer.Location> pyMethods = new AdaptedMethods(new PythonPrinterAdapter(this::visitSpace, PyLeftPadded.Location::getBeforeLocation, PyRightPadded.Location::getAfterLocation, PyContainer.Location::getBeforeLocation, PyContainer.Location::getElementLocation));
    final AdaptedMethods<J, Space.Location, JLeftPadded.Location, JRightPadded.Location, JContainer.Location> jMethods = new AdaptedMethods(new PythonPrinterAdapter(this::visitSpace, JLeftPadded.Location::getBeforeLocation, JRightPadded.Location::getAfterLocation, JContainer.Location::getBeforeLocation, JContainer.Location::getElementLocation));
    private static final String BLOCK_INDENT_KEY = "BLOCK_INDENT";
    private static final String STATEMENT_GROUP_CURSOR_KEY = "STATEMENT_GROUP";
    private static final String STATEMENT_GROUP_INDEX_CURSOR_KEY = "STATEMENT_GROUP_INDEX";
    private static final UnaryOperator<String> PYTHON_MARKER_WRAPPER = out -> "/*~~" + out + (out.isEmpty() ? "" : "~~") + ">*/";

    protected void afterSyntax(J j, PrintOutputCapture<P> p) {
        this.afterSyntax(j.getMarkers(), p);
    }

    protected void afterSyntax(Markers markers, PrintOutputCapture<P> p) {
        for (Marker marker : markers.getMarkers()) {
            p.out.append(p.getMarkerPrinter().afterSyntax(marker, new Cursor(this.getCursor(), (Object)marker), PYTHON_MARKER_WRAPPER));
        }
    }

    @Nullable
    private <T extends J> T reindentPrefix(@Nullable T element) {
        if (element == null) {
            return null;
        }
        return (T)element.withPrefix(this.reindentPrefix(element.getPrefix()));
    }

    @Nullable
    private <T extends J> JLeftPadded<T> reindentBefore(@Nullable JLeftPadded<T> padded) {
        if (padded == null) {
            return null;
        }
        return padded.withBefore(this.reindentPrefix(padded.getBefore()));
    }

    @Nullable
    private <T extends J> JRightPadded<T> reindentPrefix(@Nullable JRightPadded<T> padded) {
        if (padded == null) {
            return null;
        }
        return padded.withElement((Object)this.reindentPrefix((J)padded.getElement()));
    }

    private Space reindentPrefix(Space space) {
        String indent = (String)this.getCursor().getNearestMessage(BLOCK_INDENT_KEY);
        if (indent == null) {
            indent = "";
        }
        return PySpace.reindent(space, indent, PySpace.IndentStartMode.LINE_START, PySpace.IndentEndMode.STATEMENT_START);
    }

    @Override
    public J visitJavaSourceFile(JavaSourceFile sourceFile, PrintOutputCapture<P> p) {
        Py.CompilationUnit cu = (Py.CompilationUnit)sourceFile;
        this.beforeSyntax((J)cu, Space.Location.COMPILATION_UNIT_PREFIX, p);
        for (JRightPadded<J.Import> jRightPadded : cu.getPadding().getImports()) {
            this.visitRightPadded(jRightPadded, PyRightPadded.Location.TOP_LEVEL_STATEMENT_SUFFIX, p);
        }
        for (JRightPadded<J.Import> jRightPadded : cu.getPadding().getStatements()) {
            this.visitRightPadded(jRightPadded, PyRightPadded.Location.TOP_LEVEL_STATEMENT_SUFFIX, p);
        }
        this.visitSpace(cu.getEof(), Space.Location.COMPILATION_UNIT_EOF, p);
        if (cu.getMarkers().findFirst(SuppressNewline.class).isPresent() && PythonPrinter.lastCharIs(p, '\n')) {
            p.out.setLength(p.out.length() - 1);
        }
        this.afterSyntax(cu, p);
        return cu;
    }

    public J visitIdentifier(J.Identifier ident, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)ident, Space.Location.IDENTIFIER_PREFIX, p);
        p.append(ident.getSimpleName());
        this.afterSyntax((J)ident, p);
        return ident;
    }

    public J visitFieldAccess(J.FieldAccess fieldAccess, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)fieldAccess, Space.Location.FIELD_ACCESS_PREFIX, p);
        this.visit((Tree)fieldAccess.getTarget(), p);
        this.visitLeftPadded(".", (JLeftPadded<J>)fieldAccess.getPadding().getName(), JLeftPadded.Location.FIELD_ACCESS_NAME, p);
        this.afterSyntax((J)fieldAccess, p);
        return fieldAccess;
    }

    public J visitArrayDimension(J.ArrayDimension arrayDimension, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)arrayDimension, Space.Location.DIMENSION_PREFIX, p);
        p.append("[");
        this.visitRightPadded((JRightPadded<J>)arrayDimension.getPadding().getIndex(), JRightPadded.Location.ARRAY_INDEX, "]", p);
        this.afterSyntax((J)arrayDimension, p);
        return arrayDimension;
    }

    @Override
    public J visitDictLiteral(Py.DictLiteral dict, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)dict, PySpace.Location.DICT_LITERAL_PREFIX, p);
        if (dict.getElements().isEmpty()) {
            p.append("{");
            this.visitPythonExtraPadding((Tree)dict, PythonExtraPadding.Location.EMPTY_INITIALIZER, p);
            p.append("}");
        } else {
            this.visitContainer("{", dict.getPadding().getElements(), PyContainer.Location.DICT_LITERAL_ELEMENTS, ",", "}", p);
        }
        this.afterSyntax(dict, p);
        return dict;
    }

    @Override
    public J visitKeyValue(Py.KeyValue keyValue, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)keyValue, PySpace.Location.KEY_VALUE_PREFIX, p);
        this.visitRightPadded(keyValue.getPadding().getKey(), PyRightPadded.Location.KEY_VALUE_KEY_SUFFIX, p);
        p.append(':');
        this.visit((Tree)keyValue.getValue(), p);
        this.afterSyntax(keyValue, p);
        return keyValue;
    }

    public J visitAssignment(J.Assignment assignment, PrintOutputCapture<P> p) {
        String symbol = this.getCursor().getParentTreeCursor().getValue() instanceof J.Block ? "=" : ":=";
        this.beforeSyntax((J)assignment, Space.Location.ASSIGNMENT_PREFIX, p);
        this.visit((Tree)assignment.getVariable(), p);
        this.visitLeftPadded(symbol, (JLeftPadded<J>)assignment.getPadding().getAssignment(), JLeftPadded.Location.ASSIGNMENT, p);
        this.afterSyntax((J)assignment, p);
        return assignment;
    }

    public J visitAssignmentOperation(J.AssignmentOperation assignOp, PrintOutputCapture<P> p) {
        String keyword = "";
        switch (assignOp.getOperator()) {
            case Addition: {
                keyword = "+=";
                break;
            }
            case Subtraction: {
                keyword = "-=";
                break;
            }
            case MatrixMultiplication: {
                keyword = "@=";
                break;
            }
            case Multiplication: {
                keyword = "*=";
                break;
            }
            case Division: {
                keyword = "/=";
                break;
            }
            case Exponentiation: {
                keyword = "**=";
                break;
            }
            case FloorDivision: {
                keyword = "//=";
                break;
            }
            case Modulo: {
                keyword = "%=";
                break;
            }
            case BitAnd: {
                keyword = "&=";
                break;
            }
            case BitOr: {
                keyword = "|=";
                break;
            }
            case BitXor: {
                keyword = "^=";
                break;
            }
            case LeftShift: {
                keyword = "<<=";
                break;
            }
            case RightShift: {
                keyword = ">>=";
                break;
            }
            case UnsignedRightShift: {
                keyword = ">>>=";
            }
        }
        this.beforeSyntax((J)assignOp, Space.Location.ASSIGNMENT_OPERATION_PREFIX, p);
        this.visit((Tree)assignOp.getVariable(), p);
        this.visitSpace(assignOp.getPadding().getOperator().getBefore(), Space.Location.ASSIGNMENT_OPERATION_OPERATOR, p);
        p.append(keyword);
        this.visit((Tree)assignOp.getAssignment(), p);
        this.afterSyntax((J)assignOp, p);
        return assignOp;
    }

    public J visitBinary(J.Binary binary, PrintOutputCapture<P> p) {
        String keyword = "";
        switch (binary.getOperator()) {
            case Addition: {
                keyword = "+";
                break;
            }
            case Subtraction: {
                keyword = "-";
                break;
            }
            case Multiplication: {
                keyword = "*";
                break;
            }
            case Division: {
                keyword = "/";
                break;
            }
            case Modulo: {
                keyword = "%";
                break;
            }
            case LessThan: {
                keyword = "<";
                break;
            }
            case GreaterThan: {
                keyword = ">";
                break;
            }
            case LessThanOrEqual: {
                keyword = "<=";
                break;
            }
            case GreaterThanOrEqual: {
                keyword = ">=";
                break;
            }
            case Equal: {
                keyword = "is";
                break;
            }
            case NotEqual: {
                keyword = "is not";
                break;
            }
            case BitAnd: {
                keyword = "&";
                break;
            }
            case BitOr: {
                keyword = "|";
                break;
            }
            case BitXor: {
                keyword = "^";
                break;
            }
            case LeftShift: {
                keyword = "<<";
                break;
            }
            case RightShift: {
                keyword = ">>";
                break;
            }
            case UnsignedRightShift: {
                keyword = ">>>";
                break;
            }
            case Or: {
                keyword = "or";
                break;
            }
            case And: {
                keyword = "and";
            }
        }
        this.beforeSyntax((J)binary, Space.Location.BINARY_PREFIX, p);
        this.visit((Tree)binary.getLeft(), p);
        this.visitSpace(binary.getPadding().getOperator().getBefore(), Space.Location.BINARY_OPERATOR, p);
        int spaceIndex = keyword.indexOf(32);
        if (spaceIndex >= 0) {
            p.append(keyword.substring(0, spaceIndex));
            this.visitPythonExtraPadding((Tree)binary, PythonExtraPadding.Location.WITHIN_OPERATOR_NAME, p);
            p.append(keyword.substring(spaceIndex + 1));
        } else {
            p.append(keyword);
        }
        this.visit((Tree)binary.getRight(), p);
        this.afterSyntax((J)binary, p);
        return binary;
    }

    public J visitClassDeclaration(J.ClassDeclaration classDecl, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)classDecl, Space.Location.CLASS_DECLARATION_PREFIX, p);
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(classDecl.getLeadingAnnotations(), p);
        this.visit(classDecl.getAnnotations().getKind().getAnnotations(), p);
        this.visitSpace(this.reindentPrefix(classDecl.getAnnotations().getKind().getPrefix()), Space.Location.CLASS_KIND, p);
        p.append("class");
        this.visit((Tree)classDecl.getName(), p);
        if (classDecl.getPadding().getImplements() != null) {
            boolean omitParens = classDecl.getPadding().getImplements().getMarkers().findFirst(OmitParentheses.class).isPresent();
            this.visitContainer(omitParens ? "" : "(", (JContainer<J>)classDecl.getPadding().getImplements(), JContainer.Location.IMPLEMENTS, ",", omitParens ? "" : ")", p);
        }
        this.visit((Tree)classDecl.getBody(), p);
        this.afterSyntax((J)classDecl, p);
        return classDecl;
    }

    public <T extends J> J visitControlParentheses(J.ControlParentheses<T> controlParens, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)controlParens, Space.Location.CONTROL_PARENTHESES_PREFIX, p);
        this.visitRightPadded((JRightPadded<J>)controlParens.getPadding().getTree(), JRightPadded.Location.PARENTHESES, "", p);
        this.afterSyntax((J)controlParens, p);
        return controlParens;
    }

    public J visitElse(J.If.Else elze, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)this.reindentPrefix(elze), Space.Location.ELSE_PREFIX, p);
        if (this.getCursor().getParentTreeCursor().getValue() instanceof J.If && elze.getBody() instanceof J.If) {
            p.append("el");
        } else {
            p.append("else");
        }
        this.visit((Tree)elze.getBody(), p);
        this.afterSyntax((J)elze, p);
        return elze;
    }

    public J visitBlock(J.Block block, PrintOutputCapture<P> p) {
        Space prefixWithoutIndent;
        String newIndent;
        this.visitPythonExtraPadding((Tree)block, PythonExtraPadding.Location.BEFORE_COMPOUND_BLOCK_COLON, p);
        String parentIndent = (String)this.getCursor().getNearestMessage(BLOCK_INDENT_KEY);
        if (block.getPrefix().getLastWhitespace().contains("\n")) {
            String blockIndent = block.getPrefix().getIndent();
            newIndent = parentIndent == null ? blockIndent : parentIndent + blockIndent;
            prefixWithoutIndent = PySpace.stripIndent(block.getPrefix(), "\n" + blockIndent);
        } else {
            newIndent = "";
            prefixWithoutIndent = block.getPrefix();
        }
        this.getCursor().putMessage(BLOCK_INDENT_KEY, (Object)newIndent);
        if (parentIndent != null) {
            p.append(":");
        }
        this.beforeSyntax(prefixWithoutIndent, block.getMarkers(), Space.Location.BLOCK_PREFIX, p);
        this.visitStatements(block.getPadding().getStatements(), p);
        this.visitSpace(block.getEnd(), Space.Location.BLOCK_END, p);
        this.afterSyntax((J)block, p);
        return block;
    }

    protected void visitStatements(List<JRightPadded<Statement>> statements, PrintOutputCapture<P> p) {
        String indent = (String)this.getCursor().getNearestMessage(BLOCK_INDENT_KEY);
        GroupedStatement.StatementGroup statementGroup = null;
        boolean isFirst = true;
        for (int i = 0; i < statements.size(); ++i) {
            boolean delegateReindentToElement;
            JRightPadded paddedStat = statements.get(i);
            if (statementGroup == null || !statementGroup.containsIndex(i)) {
                statementGroup = GroupedStatement.findCurrentStatementGroup(statements, i);
                this.getCursor().putMessage(STATEMENT_GROUP_CURSOR_KEY, statementGroup == null ? null : statementGroup.getStatements());
            }
            this.getCursor().putMessage(STATEMENT_GROUP_INDEX_CURSOR_KEY, statementGroup == null ? null : Integer.valueOf(i - statementGroup.getFirstIndex()));
            Statement statement = (Statement)paddedStat.getElement();
            boolean bl = delegateReindentToElement = statement instanceof J.ClassDeclaration || statement instanceof J.MethodDeclaration;
            if (statementGroup == null || !statementGroup.containsIndex(i + 1)) {
                if (!isFirst && !PythonPrinter.lastCharIs(p, '\n')) {
                    p.append(";");
                } else if (indent != null && !delegateReindentToElement) {
                    paddedStat = paddedStat.withElement((Object)this.reindentPrefix((Statement)paddedStat.getElement()));
                }
                this.visitRightPadded(paddedStat, JRightPadded.Location.LANGUAGE_EXTENSION, p);
                isFirst = false;
                continue;
            }
            this.visit((Tree)paddedStat.getElement(), p);
        }
    }

    public J visitLambda(J.Lambda lambda, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)lambda, Space.Location.LAMBDA_PREFIX, p);
        p.append("lambda");
        this.visitSpace(lambda.getParameters().getPrefix(), Space.Location.LAMBDA_PARAMETERS_PREFIX, p);
        this.visitMarkers(lambda.getParameters().getMarkers(), p);
        this.visitRightPadded((List<JRightPadded<J>>)lambda.getParameters().getPadding().getParams(), JRightPadded.Location.LAMBDA_PARAM, ",", p);
        this.visitSpace(lambda.getArrow(), Space.Location.LAMBDA_ARROW_PREFIX, p);
        p.append(":");
        this.visit((Tree)lambda.getBody(), p);
        this.afterSyntax((J)lambda, p);
        return lambda;
    }

    public J visitSwitch(J.Switch switzh, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)switzh, Space.Location.SWITCH_PREFIX, p);
        p.append("match");
        this.visit((Tree)switzh.getSelector(), p);
        this.visit((Tree)switzh.getCases(), p);
        this.afterSyntax((J)switzh, p);
        return switzh;
    }

    public J visitCase(J.Case caze, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)caze, Space.Location.CASE_PREFIX, p);
        Expression elem = (Expression)caze.getExpressions().get(0);
        if (!(elem instanceof J.Identifier) || !((J.Identifier)elem).getSimpleName().equals("default")) {
            p.append("case");
        }
        this.visitContainer("", (JContainer<J>)caze.getPadding().getExpressions(), JContainer.Location.CASE_EXPRESSION, ",", "", p);
        this.visitSpace(caze.getPadding().getStatements().getBefore(), Space.Location.CASE, p);
        this.visitStatements(caze.getPadding().getStatements().getPadding().getElements(), p);
        if (caze.getBody() instanceof Statement) {
            this.visitRightPadded(caze.getPadding().getBody(), JRightPadded.Location.LANGUAGE_EXTENSION, p);
        } else {
            this.visitRightPadded((JRightPadded<J>)caze.getPadding().getBody(), JRightPadded.Location.CASE_BODY, ";", p);
        }
        this.afterSyntax((J)caze, p);
        return caze;
    }

    public J visitTernary(J.Ternary ternary, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)ternary, Space.Location.TERNARY_PREFIX, p);
        this.visit((Tree)ternary.getTruePart(), p);
        this.visitSpace(ternary.getPadding().getTruePart().getBefore(), Space.Location.TERNARY_TRUE, p);
        p.append("if");
        this.visit((Tree)ternary.getCondition(), p);
        this.visitLeftPadded("else", (JLeftPadded<J>)ternary.getPadding().getFalsePart(), JLeftPadded.Location.TERNARY_FALSE, p);
        this.afterSyntax((J)ternary, p);
        return ternary;
    }

    public J visitForEachLoop(J.ForEachLoop forEachLoop, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)forEachLoop, Space.Location.FOR_EACH_LOOP_PREFIX, p);
        p.append("for");
        this.visit((Tree)forEachLoop.getControl(), p);
        this.visit((Tree)forEachLoop.getBody(), p);
        this.afterSyntax((J)forEachLoop, p);
        return forEachLoop;
    }

    public J visitForEachControl(J.ForEachLoop.Control control, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)control, Space.Location.FOR_EACH_CONTROL_PREFIX, p);
        this.visitRightPadded(control.getPadding().getVariable(), JRightPadded.Location.FOREACH_VARIABLE, p);
        p.append("in");
        this.visitRightPadded(control.getPadding().getIterable(), JRightPadded.Location.FOREACH_ITERABLE, p);
        this.afterSyntax((J)control, p);
        return control;
    }

    public J visitLiteral(J.Literal literal, PrintOutputCapture<P> p) {
        if (literal.getValue() == null) {
            literal = literal.getMarkers().findFirst(ImplicitNone.class).isPresent() ? literal.withValueSource("") : literal.withValueSource("None");
        }
        this.beforeSyntax((J)literal, Space.Location.LITERAL_PREFIX, p);
        List unicodeEscapes = literal.getUnicodeEscapes();
        if (unicodeEscapes == null) {
            p.append(literal.getValueSource());
        } else if (literal.getValueSource() != null) {
            char[] valueSourceArr;
            Iterator surrogateIter = unicodeEscapes.iterator();
            J.Literal.UnicodeEscape surrogate = surrogateIter.hasNext() ? (J.Literal.UnicodeEscape)surrogateIter.next() : null;
            int i = 0;
            if (surrogate != null && surrogate.getValueSourceIndex() == 0) {
                p.append("\\u").append(surrogate.getCodePoint());
                if (surrogateIter.hasNext()) {
                    surrogate = (J.Literal.UnicodeEscape)surrogateIter.next();
                }
            }
            for (char c : valueSourceArr = literal.getValueSource().toCharArray()) {
                p.append(c);
                if (surrogate == null || surrogate.getValueSourceIndex() != ++i) continue;
                while (surrogate != null && surrogate.getValueSourceIndex() == i) {
                    p.append("\\u").append(surrogate.getCodePoint());
                    surrogate = surrogateIter.hasNext() ? (J.Literal.UnicodeEscape)surrogateIter.next() : null;
                }
            }
        }
        this.afterSyntax((J)literal, p);
        return literal;
    }

    protected void visitModifier(J.Modifier mod, PrintOutputCapture<P> p) {
        String keyword = null;
        switch (mod.getType()) {
            case Default: {
                keyword = "def";
                break;
            }
            case Async: {
                keyword = "async";
            }
        }
        if (keyword != null) {
            this.visit(mod.getAnnotations(), p);
            this.beforeSyntax((J)mod, Space.Location.MODIFIER_PREFIX, p);
            p.append(keyword);
            this.afterSyntax((J)mod, p);
        }
    }

    public J visitMethodDeclaration(J.MethodDeclaration method, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)method, Space.Location.METHOD_DECLARATION_PREFIX, p);
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(method.getLeadingAnnotations(), p);
        List modifiers = ListUtils.mapFirst((List)method.getModifiers(), mod -> this.reindentPrefix(mod));
        for (J.Modifier m : modifiers) {
            this.visitModifier(m, p);
        }
        this.visit((Tree)method.getName(), p);
        this.visitContainer("(", (JContainer<J>)method.getPadding().getParameters(), JContainer.Location.METHOD_DECLARATION_PARAMETERS, ",", ")", p);
        this.visit((Tree)method.getReturnTypeExpression(), p);
        this.visit((Tree)method.getBody(), p);
        this.afterSyntax((J)method, p);
        return method;
    }

    public J visitVariableDeclarations(J.VariableDeclarations multiVariable, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
        this.visitSpace(Space.EMPTY, Space.Location.ANNOTATIONS, p);
        this.visit(multiVariable.getLeadingAnnotations(), p);
        for (J.Modifier m : multiVariable.getModifiers()) {
            this.visitModifier(m, p);
        }
        TypeTree type = multiVariable.getTypeExpression();
        if (type instanceof Py.SpecialParameter) {
            Py.SpecialParameter special = (Py.SpecialParameter)type;
            this.visit((Tree)special, p);
            type = special.getTypeHint();
        }
        this.visitRightPadded((List<JRightPadded<J>>)multiVariable.getPadding().getVariables(), JRightPadded.Location.NAMED_VARIABLE, ",", p);
        this.visit((Tree)type, p);
        this.afterSyntax((J)multiVariable, p);
        return multiVariable;
    }

    public J visitVariable(J.VariableDeclarations.NamedVariable variable, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)variable, Space.Location.VARIABLE_PREFIX, p);
        if (variable.getName().getSimpleName().isEmpty()) {
            this.visit((Tree)variable.getInitializer(), p);
        } else {
            this.visit((Tree)variable.getName(), p);
            this.visitLeftPadded("=", (JLeftPadded<J>)variable.getPadding().getInitializer(), JLeftPadded.Location.VARIABLE_INITIALIZER, p);
        }
        this.afterSyntax((J)variable, p);
        return variable;
    }

    private void visitMagicMethodDesugar(J.MethodInvocation method, boolean negate, PrintOutputCapture<P> p) {
        String magicMethodName = method.getSimpleName();
        if ("__call__".equals(magicMethodName)) {
            this.beforeSyntax((J)method, Space.Location.METHOD_INVOCATION_PREFIX, p);
            this.visitRightPadded(method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, p);
            this.visitContainer("(", (JContainer<J>)method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", ")", p);
            this.afterSyntax((J)method, p);
            return;
        }
        if (method.getArguments().size() != 1) {
            throw new IllegalStateException(String.format("expected de-sugared magic method call `%s` to have exactly one argument; found %d", magicMethodName, method.getArguments().size()));
        }
        String operator = PythonOperatorLookup.operatorForMagicMethod(magicMethodName);
        if (operator == null) {
            throw new IllegalStateException(String.format("expected method call `%s` to be a de-sugared operator, but it does not match known operators", magicMethodName));
        }
        if (negate && !"in".equals(operator)) {
            throw new IllegalStateException(String.format("found method call `%s` as a de-sugared operator, but it is marked as negated (which it does not support)", magicMethodName));
        }
        boolean reverseOperandOrder = PythonOperatorLookup.doesMagicMethodReverseOperands(magicMethodName);
        Expression lhs = Objects.requireNonNull(method.getSelect());
        Expression rhs = (Expression)method.getArguments().get(0);
        J.MethodInvocation.Padding padding = method.getPadding();
        Space beforeOperator = Objects.requireNonNull(padding.getSelect()).getAfter();
        Space afterOperator = rhs.getPrefix();
        if (reverseOperandOrder) {
            Expression tmp = lhs;
            lhs = rhs;
            rhs = tmp;
        }
        this.beforeSyntax((J)method, Space.Location.BINARY_PREFIX, p);
        this.visit((Tree)((Expression)lhs.withPrefix(Space.EMPTY)), p);
        this.visitSpace(beforeOperator, Space.Location.BINARY_OPERATOR, p);
        if (negate) {
            p.append("not");
            this.visitPythonExtraPadding((Tree)method, PythonExtraPadding.Location.WITHIN_OPERATOR_NAME, p);
        }
        p.append(operator);
        this.visit((Tree)((Expression)rhs.withPrefix(afterOperator)), p);
        this.afterSyntax((J)method, p);
    }

    private void visitBuiltinDesugar(J.MethodInvocation method, PrintOutputCapture<P> p) {
        String builtinName;
        Expression select = method.getSelect();
        if (!(select instanceof J.Identifier)) {
            throw new IllegalStateException("expected builtin desugar to select from an Identifier");
        }
        if (!"__builtins__".equals(((J.Identifier)select).getSimpleName())) {
            throw new IllegalStateException("expected builtin desugar to select from __builtins__");
        }
        this.visitSpace(method.getPrefix(), Space.Location.LANGUAGE_EXTENSION, p);
        switch (builtinName = Objects.requireNonNull(method.getName()).getSimpleName()) {
            case "slice": {
                this.visitContainer("", (JContainer<J>)method.getPadding().getArguments(), JContainer.Location.LANGUAGE_EXTENSION, ":", "", p);
                return;
            }
            case "set": 
            case "tuple": {
                String after;
                String before;
                if (method.getArguments().size() != 1) {
                    throw new IllegalStateException(String.format("builtin `%s` should have exactly one argument", builtinName));
                }
                Expression arg = (Expression)method.getArguments().get(0);
                if (!(arg instanceof J.NewArray)) {
                    throw new IllegalStateException(String.format("builtin `%s` should have exactly one argument, a J.NewArray", builtinName));
                }
                J.NewArray argList = (J.NewArray)arg;
                int argCount = 0;
                for (Expression argExpr : Objects.requireNonNull(argList.getInitializer())) {
                    if (argExpr instanceof J.Empty) continue;
                    ++argCount;
                }
                if (method.getMarkers().findFirst(OmitParentheses.class).isPresent()) {
                    before = "";
                    after = "";
                } else if ("set".equals(builtinName)) {
                    before = "{";
                    after = "}";
                } else {
                    before = "(";
                    after = argCount == 1 ? ",)" : ")";
                }
                this.visitContainer(before, (JContainer<J>)argList.getPadding().getInitializer(), JContainer.Location.LANGUAGE_EXTENSION, ",", after, p);
                return;
            }
        }
        throw new IllegalStateException(String.format("builtin desugar doesn't support `%s`", builtinName));
    }

    public J visitMethodInvocation(J.MethodInvocation method, PrintOutputCapture<P> p) {
        if (method.getMarkers().findFirst(MagicMethodDesugar.class).isPresent()) {
            this.visitMagicMethodDesugar(method, false, p);
        } else if (method.getMarkers().findFirst(BuiltinDesugar.class).isPresent()) {
            this.visitBuiltinDesugar(method, p);
        } else {
            this.beforeSyntax((J)method, Space.Location.METHOD_INVOCATION_PREFIX, p);
            this.visitRightPadded((JRightPadded<J>)method.getPadding().getSelect(), JRightPadded.Location.METHOD_SELECT, ".", p);
            this.visitContainer("<", (JContainer<J>)method.getPadding().getTypeParameters(), JContainer.Location.TYPE_PARAMETERS, ",", ">", p);
            this.visit((Tree)method.getName(), p);
            this.visitContainer("(", (JContainer<J>)method.getPadding().getArguments(), JContainer.Location.METHOD_INVOCATION_ARGUMENTS, ",", ")", p);
            this.afterSyntax((J)method, p);
        }
        return method;
    }

    public J visitNewArray(J.NewArray newArray, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)newArray, Space.Location.NEW_ARRAY_PREFIX, p);
        this.visitContainer("[", (JContainer<J>)newArray.getPadding().getInitializer(), JContainer.Location.NEW_ARRAY_INITIALIZER, ",", "]", p);
        this.afterSyntax((J)newArray, p);
        return newArray;
    }

    public J visitAnnotation(J.Annotation annotation, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)this.reindentPrefix(annotation), Space.Location.ANNOTATION_PREFIX, p);
        p.append("@");
        this.visit((Tree)annotation.getAnnotationType(), p);
        this.visitContainer("(", (JContainer<J>)annotation.getPadding().getArguments(), JContainer.Location.ANNOTATION_ARGUMENTS, ",", ")", p);
        this.visitPythonExtraPadding((Tree)annotation, PythonExtraPadding.Location.AFTER_DECORATOR, PySpace.IndentStartMode.AFTER_STATEMENT, PySpace.IndentEndMode.REST_OF_LINE, p);
        this.afterSyntax((J)annotation, p);
        return annotation;
    }

    public J visitThrow(J.Throw thrown, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)thrown, Space.Location.THROW_PREFIX, p);
        p.append("raise");
        this.visit((Tree)thrown.getException(), p);
        this.afterSyntax((J)thrown, p);
        return thrown;
    }

    public J visitTry(J.Try tryable, PrintOutputCapture<P> p) {
        boolean isWithStatement = tryable.getResources() != null && !tryable.getResources().isEmpty();
        this.beforeSyntax((J)tryable, Space.Location.TRY_PREFIX, p);
        if (isWithStatement) {
            p.append("with");
        } else {
            p.append("try");
        }
        if (isWithStatement) {
            this.visitSpace(tryable.getPadding().getResources().getBefore(), Space.Location.TRY_RESOURCES, p);
            List resources = tryable.getPadding().getResources().getPadding().getElements();
            boolean first = true;
            for (JRightPadded resource : resources) {
                if (!first) {
                    p.append(",");
                } else {
                    first = false;
                }
                this.visitSpace(((J.Try.Resource)resource.getElement()).getPrefix(), Space.Location.TRY_RESOURCE, p);
                this.visitMarkers(((J.Try.Resource)resource.getElement()).getMarkers(), p);
                TypedTree decl = ((J.Try.Resource)resource.getElement()).getVariableDeclarations();
                if (!(decl instanceof J.Assignment)) {
                    throw new IllegalArgumentException(String.format("with-statement resource should be an Assignment; found: %s", decl.getClass().getSimpleName()));
                }
                J.Assignment assignment = (J.Assignment)decl;
                this.visit((Tree)assignment.getAssignment(), p);
                if (!(assignment.getVariable() instanceof J.Empty)) {
                    this.visitSpace(assignment.getPadding().getAssignment().getBefore(), Space.Location.LANGUAGE_EXTENSION, p);
                    p.append("as");
                    this.visit((Tree)assignment.getVariable(), p);
                }
                this.visitSpace(resource.getAfter(), Space.Location.TRY_RESOURCE_SUFFIX, p);
            }
        }
        J.Block tryBody = tryable.getBody();
        JRightPadded elseBody = null;
        List tryStatements = tryable.getBody().getPadding().getStatements();
        if (((JRightPadded)tryStatements.get(tryStatements.size() - 1)).getElement() instanceof J.Block) {
            tryBody = tryBody.getPadding().withStatements(tryStatements.subList(0, tryStatements.size() - 1));
            elseBody = (JRightPadded)tryStatements.get(tryStatements.size() - 1);
        }
        this.visit((Tree)tryBody, p);
        this.visit(tryable.getCatches(), p);
        if (elseBody != null) {
            this.visitSpace(this.reindentPrefix(elseBody.getAfter()), Space.Location.LANGUAGE_EXTENSION, p);
            p.append("else");
            this.visit((Tree)elseBody.getElement(), p);
        }
        this.visitLeftPadded("finally", this.reindentBefore(tryable.getPadding().getFinally()), JLeftPadded.Location.TRY_FINALLY, p);
        this.afterSyntax((J)tryable, p);
        return tryable;
    }

    public J visitCatch(J.Try.Catch catzh, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)this.reindentPrefix(catzh), Space.Location.CATCH_PREFIX, p);
        p.append("except");
        J.VariableDeclarations multiVariable = (J.VariableDeclarations)catzh.getParameter().getTree();
        this.beforeSyntax((J)multiVariable, Space.Location.VARIABLE_DECLARATIONS_PREFIX, p);
        this.visit((Tree)multiVariable.getTypeExpression(), p);
        for (JRightPadded paddedVariable : multiVariable.getPadding().getVariables()) {
            J.VariableDeclarations.NamedVariable variable = (J.VariableDeclarations.NamedVariable)paddedVariable.getElement();
            if (variable.getName().getSimpleName().isEmpty()) continue;
            this.visitSpace(paddedVariable.getAfter(), Space.Location.LANGUAGE_EXTENSION, p);
            this.beforeSyntax((J)variable, Space.Location.VARIABLE_PREFIX, p);
            p.append("as");
            this.visit((Tree)variable.getName(), p);
            this.afterSyntax((J)variable, p);
        }
        this.afterSyntax((J)multiVariable, p);
        this.visit((Tree)catzh.getBody(), p);
        this.afterSyntax((J)catzh, p);
        return catzh;
    }

    public J visitUnary(J.Unary unary, PrintOutputCapture<P> p) {
        if (unary.getMarkers().findFirst(MagicMethodDesugar.class).isPresent()) {
            if (unary.getOperator() != J.Unary.Type.Not) {
                throw new IllegalStateException(String.format("found a unary operator (%s) marked as a magic method de-sugar, but only negation is supported", unary.getOperator()));
            }
            Expression expression = unary.getExpression();
            while (expression instanceof J.Parentheses) {
                expression = expression.unwrap();
            }
            if (!(expression instanceof J.MethodInvocation)) {
                throw new IllegalStateException(String.format("found a unary operator (%s) marked as a magic method de-sugar, but its expression is not a magic method invocation", unary.getOperator()));
            }
            this.visitMagicMethodDesugar((J.MethodInvocation)expression, true, p);
            return unary;
        }
        this.beforeSyntax((J)unary, Space.Location.UNARY_PREFIX, p);
        switch (unary.getOperator()) {
            case Not: {
                p.append("not");
                break;
            }
            case Positive: {
                p.append("+");
                break;
            }
            case Negative: {
                p.append("-");
                break;
            }
            case Complement: {
                p.append("~");
            }
        }
        this.visit((Tree)unary.getExpression(), p);
        this.afterSyntax((J)unary, p);
        return unary;
    }

    public J visitImport(J.Import impoort, PrintOutputCapture<P> p) {
        List<J.Import> statementGroup = (List<J.Import>)this.getCursor().getParentTreeCursor().getMessage(STATEMENT_GROUP_CURSOR_KEY);
        if (statementGroup != null) {
            Integer statementGroupIndex = (Integer)this.getCursor().getParentTreeCursor().getMessage(STATEMENT_GROUP_INDEX_CURSOR_KEY);
            if (statementGroupIndex == null) {
                throw new IllegalStateException();
            }
            if (statementGroupIndex != statementGroup.size() - 1) {
                return impoort;
            }
        }
        if (statementGroup == null) {
            statementGroup = Collections.singletonList(impoort);
        }
        boolean printParens = impoort.getMarkers().findFirst(ImportParens.class).isPresent();
        this.beforeSyntax((J)impoort, Space.Location.IMPORT_PREFIX, p);
        boolean isFrom = "".equals(impoort.getQualid().getSimpleName());
        if (isFrom) {
            p.append("import");
        } else {
            p.append("from");
            this.visit((Tree)impoort.getQualid().getTarget(), p);
            this.visitSpace(impoort.getQualid().getPadding().getName().getBefore(), Space.Location.LANGUAGE_EXTENSION, p);
            p.append("import");
        }
        if (printParens) {
            this.visitPythonExtraPadding((Tree)impoort, PythonExtraPadding.Location.IMPORT_PARENS_PREFIX, p);
            p.append("(");
        }
        for (int i = 0; i < statementGroup.size(); ++i) {
            J.Import inGroup = statementGroup.get(i);
            if (i != 0) {
                p.append(",");
            }
            if (isFrom) {
                this.visit((Tree)inGroup.getQualid().getTarget(), p);
            } else {
                this.visit((Tree)inGroup.getQualid().getName(), p);
            }
            if (inGroup.getAlias() == null) continue;
            this.visitSpace(inGroup.getPadding().getAlias().getBefore(), Space.Location.LANGUAGE_EXTENSION, p);
            p.append("as");
            this.visit((Tree)inGroup.getAlias(), p);
        }
        if (printParens) {
            this.visitPythonExtraPadding((Tree)impoort, PythonExtraPadding.Location.IMPORT_PARENS_SUFFIX, p);
            p.append(")");
        }
        this.afterSyntax((J)impoort, p);
        return impoort;
    }

    private void visitPythonExtraPadding(Tree tree, PythonExtraPadding.Location loc, PySpace.IndentStartMode startMode, PySpace.IndentEndMode endMode, PrintOutputCapture<P> p) {
        String indent = (String)this.getCursor().getNearestMessage(BLOCK_INDENT_KEY);
        if (indent == null) {
            indent = "";
        }
        Space space = PythonExtraPadding.getOrDefault(tree, loc);
        space = PySpace.reindent(space, indent, startMode, endMode);
        this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    private void visitPythonExtraPadding(Tree tree, PythonExtraPadding.Location loc, PrintOutputCapture<P> p) {
        Space space = PythonExtraPadding.getOrDefault(tree, loc);
        if (space == null) {
            return;
        }
        this.visitSpace(space, Space.Location.LANGUAGE_EXTENSION, p);
    }

    @Override
    public Space visitSpace(Space space, PySpace.Location loc, PrintOutputCapture<P> p) {
        p.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            this.visitMarkers(comment.getMarkers(), p);
            comment.printComment(this.getCursor(), p);
            p.append(comment.getSuffix());
        }
        return space;
    }

    public Space visitSpace(Space space, Space.Location loc, PrintOutputCapture<P> p) {
        p.append(space.getWhitespace());
        for (Comment comment : space.getComments()) {
            this.visitMarkers(comment.getMarkers(), p);
            comment.printComment(this.getCursor(), p);
            p.append(comment.getSuffix());
        }
        return space;
    }

    public <T extends J> J visitParentheses(J.Parentheses<T> parens, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)parens, Space.Location.PARENTHESES_PREFIX, p);
        p.append("(");
        this.visitRightPadded((JRightPadded<J>)parens.getPadding().getTree(), JRightPadded.Location.PARENTHESES, ")", p);
        this.afterSyntax((J)parens, p);
        return parens;
    }

    public J visitWhileLoop(J.WhileLoop whileLoop, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)whileLoop, Space.Location.WHILE_PREFIX, p);
        p.append("while");
        this.visit((Tree)whileLoop.getCondition(), p);
        this.visitRightPadded(whileLoop.getPadding().getBody(), JRightPadded.Location.WHILE_BODY, p);
        this.afterSyntax((J)whileLoop, p);
        return whileLoop;
    }

    public J visitIf(J.If iff, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)iff, Space.Location.IF_PREFIX, p);
        p.append("if");
        this.visit((Tree)iff.getIfCondition(), p);
        this.visitRightPadded(iff.getPadding().getThenPart(), JRightPadded.Location.IF_THEN, p);
        this.visit((Tree)iff.getElsePart(), p);
        this.afterSyntax((J)iff, p);
        return iff;
    }

    public J visitContinue(J.Continue continueStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)continueStatement, Space.Location.CONTINUE_PREFIX, p);
        p.append("continue");
        this.visit((Tree)continueStatement.getLabel(), p);
        this.afterSyntax((J)continueStatement, p);
        return continueStatement;
    }

    public J visitReturn(J.Return retrn, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)retrn, Space.Location.RETURN_PREFIX, p);
        p.append("return");
        this.visit((Tree)retrn.getExpression(), p);
        this.afterSyntax((J)retrn, p);
        return retrn;
    }

    public J visitBreak(J.Break breakStatement, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)breakStatement, Space.Location.BREAK_PREFIX, p);
        p.append("break");
        this.visit((Tree)breakStatement.getLabel(), p);
        this.afterSyntax((J)breakStatement, p);
        return breakStatement;
    }

    @Override
    public J visitPassStatement(Py.PassStatement pass, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)pass, PySpace.Location.PASS_PREFIX, p);
        p.append("pass");
        this.afterSyntax(pass, p);
        return pass;
    }

    @Override
    public J visitComprehensionExpression(Py.ComprehensionExpression comp, PrintOutputCapture<P> p) {
        String close;
        String open;
        this.beforeSyntax((J)comp, PySpace.Location.COMPREHENSION_PREFIX, p);
        switch (comp.getKind()) {
            case DICT: 
            case SET: {
                open = "{";
                close = "}";
                break;
            }
            case LIST: {
                open = "[";
                close = "]";
                break;
            }
            case GENERATOR: {
                open = "(";
                close = ")";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        p.append(open);
        this.visit((Tree)comp.getResult(), p);
        for (Py.ComprehensionExpression.Clause clause : comp.getClauses()) {
            this.visit((Tree)clause, p);
        }
        this.visitSpace(comp.getSuffix(), PySpace.Location.COMPREHENSION_SUFFIX, p);
        p.append(close);
        this.afterSyntax(comp, p);
        return comp;
    }

    @Override
    public J visitComprehensionClause(Py.ComprehensionExpression.Clause clause, PrintOutputCapture<P> p) {
        this.visitSpace(clause.getPrefix(), PySpace.Location.COMPREHENSION_CLAUSE_PREFIX, p);
        p.append("for");
        this.visit((Tree)clause.getIteratorVariable(), p);
        this.visitSpace(clause.getPadding().getIteratedList().getBefore(), PySpace.Location.COMPREHENSION_IN, p);
        p.append("in");
        this.visit((Tree)clause.getIteratedList(), p);
        if (clause.getConditions() != null) {
            for (Py.ComprehensionExpression.Condition condition : clause.getConditions()) {
                this.visit((Tree)condition, p);
            }
        }
        return clause;
    }

    @Override
    public J visitComprehensionCondition(Py.ComprehensionExpression.Condition condition, PrintOutputCapture<P> p) {
        this.visitSpace(condition.getPrefix(), PySpace.Location.COMPREHENSION_CONDITION_PREFIX, p);
        p.append("if");
        this.visit((Tree)condition.getExpression(), p);
        return condition;
    }

    @Override
    public J visitAwaitExpression(Py.AwaitExpression await, PrintOutputCapture<P> p) {
        this.visitSpace(await.getPrefix(), PySpace.Location.AWAIT_PREFIX, p);
        p.append("await");
        this.visit((Tree)await.getExpression(), p);
        return await;
    }

    @Override
    public J visitAssertStatement(Py.AssertStatement assrt, PrintOutputCapture<P> p) {
        this.visitSpace(assrt.getPrefix(), PySpace.Location.ASSERT_PREFIX, p);
        p.append("assert");
        this.visitRightPadded(assrt.getPadding().getExpressions(), PyRightPadded.Location.ASSERT_ELEMENT, ",", p);
        return assrt;
    }

    @Override
    public J visitYieldExpression(Py.YieldExpression yield, PrintOutputCapture<P> p) {
        this.visitSpace(yield.getPrefix(), PySpace.Location.YIELD_PREFIX, p);
        p.append("yield");
        if (yield.isFrom()) {
            this.visitLeftPadded(yield.getPadding().getFrom(), PyLeftPadded.Location.YIELD_FROM, p);
            p.append("from");
        }
        this.visitRightPadded(yield.getPadding().getExpressions(), PyRightPadded.Location.YIELD_ELEMENT, ",", p);
        return yield;
    }

    @Override
    public J visitVariableScopeStatement(Py.VariableScopeStatement scope, PrintOutputCapture<P> p) {
        this.visitSpace(scope.getPrefix(), PySpace.Location.VARIABLE_SCOPE_PREFIX, p);
        switch (scope.getKind()) {
            case GLOBAL: {
                p.append("global");
                break;
            }
            case NONLOCAL: {
                p.append("nonlocal");
            }
        }
        this.visitRightPadded(scope.getPadding().getNames(), PyRightPadded.Location.VARIABLE_SCOPE_ELEMENT, ",", p);
        return scope;
    }

    @Override
    public J visitDelStatement(Py.DelStatement del, PrintOutputCapture<P> p) {
        this.visitSpace(del.getPrefix(), PySpace.Location.DEL_PREFIX, p);
        p.append("del");
        this.visitRightPadded(del.getPadding().getTargets(), PyRightPadded.Location.DEL_ELEMENT, ",", p);
        return del;
    }

    @Override
    public J visitExceptionType(Py.ExceptionType type, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)type, PySpace.Location.EXCEPTION_TYPE_PREFIX, p);
        if (type.isExceptionGroup()) {
            p.append("*");
        }
        this.visit((Tree)type.getExpression(), p);
        return type;
    }

    @Override
    public J visitErrorFromExpression(Py.ErrorFromExpression expr, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)expr, PySpace.Location.ERROR_FROM_PREFIX, p);
        this.visit((Tree)expr.getError(), p);
        this.visitSpace(expr.getPadding().getFrom().getBefore(), PySpace.Location.ERROR_FROM_SOURCE, p);
        p.append("from");
        this.visit((Tree)expr.getFrom(), p);
        return expr;
    }

    @Override
    public J visitMatchCase(Py.MatchCase match, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)match, PySpace.Location.MATCH_CASE_PREFIX, p);
        this.visit((Tree)match.getPattern(), p);
        if (match.getPadding().getGuard() != null) {
            this.visitSpace(match.getPadding().getGuard().getBefore(), PySpace.Location.MATCH_CASE_GUARD, p);
            p.append("if");
            this.visit((Tree)match.getGuard(), p);
        }
        return match;
    }

    @Override
    public J visitMatchCasePattern(Py.MatchCase.Pattern pattern, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)pattern, PySpace.Location.MATCH_PATTERN_PREFIX, p);
        JContainer<Expression> children = pattern.getPadding().getChildren();
        switch (pattern.getKind()) {
            case AS: {
                this.visitContainer("", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "as", "", p);
                break;
            }
            case CAPTURE: {
                this.visitContainer(children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, p);
                break;
            }
            case CLASS: {
                this.visitSpace(children.getBefore(), PySpace.Location.MATCH_PATTERN_ELEMENT_PREFIX, p);
                this.visitRightPadded((JRightPadded)children.getPadding().getElements().get(0), PyRightPadded.Location.MATCH_PATTERN_ELEMENT, p);
                this.visitContainer("(", (JContainer<J>)JContainer.build(children.getPadding().getElements().subList(1, children.getElements().size())), PyContainer.Location.MATCH_PATTERN_ELEMENTS, ",", ")", p);
                break;
            }
            case DOUBLE_STAR: {
                this.visitContainer("**", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "", "", p);
                break;
            }
            case GROUP: {
                this.visitContainer("(", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, ",", ")", p);
                break;
            }
            case KEY_VALUE: {
                this.visitContainer("", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, ":", "", p);
                break;
            }
            case KEYWORD: {
                this.visitContainer("", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "=", "", p);
                break;
            }
            case LITERAL: {
                this.visitContainer(children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, p);
                break;
            }
            case MAPPING: {
                this.visitContainer("{", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, ",", "}", p);
                break;
            }
            case OR: {
                this.visitContainer("", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "|", "", p);
                break;
            }
            case SEQUENCE: {
                this.visitContainer("", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, ",", "", p);
                break;
            }
            case SEQUENCE_LIST: {
                this.visitContainer("[", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, ",", "]", p);
                break;
            }
            case SEQUENCE_TUPLE: {
                this.visitContainer("(", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, ",", ")", p);
                break;
            }
            case STAR: {
                this.visitContainer("*", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "", "", p);
                break;
            }
            case VALUE: {
                this.visitContainer("", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "", "", p);
                break;
            }
            case WILDCARD: {
                this.visitContainer("_", children, PyContainer.Location.MATCH_PATTERN_ELEMENTS, "", "", p);
            }
        }
        return pattern;
    }

    @Override
    public J visitSpecialParameter(Py.SpecialParameter param, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)param, PySpace.Location.SPECIAL_PARAM_PREFIX, p);
        switch (param.getKind()) {
            case ARGS: {
                p.append("*");
                break;
            }
            case KWARGS: {
                p.append("**");
            }
        }
        this.afterSyntax(param, p);
        return param;
    }

    @Override
    public J visitNamedArgument(Py.NamedArgument arg, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)arg, PySpace.Location.NAMED_ARGUMENT, p);
        this.visit((Tree)arg.getName(), p);
        this.visitLeftPadded("=", arg.getPadding().getValue(), PyLeftPadded.Location.NAMED_ARGUMENT, p);
        return arg;
    }

    @Override
    public J visitSpecialArgument(Py.SpecialArgument arg, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)arg, PySpace.Location.SPECIAL_ARG_PREFIX, p);
        switch (arg.getKind()) {
            case ARGS: {
                p.append("*");
                break;
            }
            case KWARGS: {
                p.append("**");
            }
        }
        this.visit((Tree)arg.getExpression(), p);
        this.afterSyntax(arg, p);
        return arg;
    }

    @Override
    public J visitTrailingElseWrapper(Py.TrailingElseWrapper wrapper, PrintOutputCapture<P> p) {
        this.visit((Tree)this.reindentPrefix(wrapper.getStatement()), p);
        this.visitSpace(this.reindentPrefix(wrapper.getPadding().getElseBlock().getBefore()), Space.Location.ELSE_PREFIX, p);
        p.append("else");
        this.visit((Tree)wrapper.getElseBlock(), p);
        return wrapper;
    }

    @Override
    public J visitTypeHint(Py.TypeHint type, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)type, PySpace.Location.TYPE_HINT_PREFIX, p);
        switch (type.getKind()) {
            case VARIABLE_TYPE: {
                p.append(":");
                break;
            }
            case RETURN_TYPE: {
                p.append("->");
            }
        }
        this.visit((Tree)type.getExpression(), p);
        this.afterSyntax(type, p);
        return type;
    }

    @Override
    public J visitTypeHintedExpression(Py.TypeHintedExpression expr, PrintOutputCapture<P> p) {
        this.beforeSyntax((J)expr, PySpace.Location.TYPE_HINTED_EXPRESSION_PREFIX, p);
        this.visit((Tree)expr.getExpression(), p);
        this.visit((Tree)expr.getTypeHint(), p);
        this.afterSyntax(expr, p);
        return expr;
    }

    private static boolean lastCharIs(PrintOutputCapture<?> p, char c) {
        return p.out.length() != 0 && p.out.charAt(p.out.length() - 1) == c;
    }

    public void beforeSyntax(J tree, PySpace.Location loc, PrintOutputCapture<P> p) {
        this.pyMethods.beforeSyntax(tree, loc, p);
    }

    public void beforeSyntax(Space prefix, Markers markers, PySpace.Location loc, PrintOutputCapture<P> p) {
        this.pyMethods.beforeSyntax(prefix, markers, loc, p);
    }

    public void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, PyRightPadded.Location loc, String suffixBetween, PrintOutputCapture<P> p) {
        this.pyMethods.visitRightPadded(nodes, loc, suffixBetween, p);
    }

    public void visitRightPadded(JRightPadded<? extends J> rightPadded, PyRightPadded.Location loc, String suffix, PrintOutputCapture<P> p) {
        this.pyMethods.visitRightPadded(rightPadded, loc, suffix, p);
    }

    public void visitLeftPadded(String prefix, JLeftPadded<? extends J> leftPadded, PyLeftPadded.Location loc, PrintOutputCapture<P> p) {
        this.pyMethods.visitLeftPadded(prefix, leftPadded, loc, p);
    }

    public void visitContainer(String before, JContainer<? extends J> container, PyContainer.Location loc, String suffixBetween, String after, PrintOutputCapture<P> p) {
        this.pyMethods.visitContainer(before, container, loc, suffixBetween, after, p);
    }

    public void beforeSyntax(J tree, Space.Location loc, PrintOutputCapture<P> p) {
        this.jMethods.beforeSyntax(tree, loc, p);
    }

    public void beforeSyntax(Space prefix, Markers markers, Space.Location loc, PrintOutputCapture<P> p) {
        this.jMethods.beforeSyntax(prefix, markers, loc, p);
    }

    public void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, JRightPadded.Location loc, String suffixBetween, PrintOutputCapture<P> p) {
        this.jMethods.visitRightPadded(nodes, loc, suffixBetween, p);
    }

    public void visitRightPadded(JRightPadded<? extends J> rightPadded, JRightPadded.Location loc, String suffix, PrintOutputCapture<P> p) {
        this.jMethods.visitRightPadded(rightPadded, loc, suffix, p);
    }

    public void visitLeftPadded(String prefix, JLeftPadded<? extends J> leftPadded, JLeftPadded.Location loc, PrintOutputCapture<P> p) {
        this.jMethods.visitLeftPadded(prefix, leftPadded, loc, p);
    }

    public void visitContainer(String before, JContainer<? extends J> container, JContainer.Location loc, String suffixBetween, String after, PrintOutputCapture<P> p) {
        this.jMethods.visitContainer(before, container, loc, suffixBetween, after, p);
    }

    private class AdaptedMethods<TTree extends J, TLoc, TLeftLoc, TRtLoc, TContLoc> {
        private PythonPrinterAdapter<TTree, TLoc, TLeftLoc, TRtLoc, TContLoc, P> adapter;

        void visitSpace(Space prefix, TLoc loc, PrintOutputCapture<P> p) {
            this.adapter.spaceVisitor.visitSpace(prefix, loc, p);
        }

        public void beforeSyntax(J tree, TLoc loc, PrintOutputCapture<P> p) {
            this.beforeSyntax(tree.getPrefix(), tree.getMarkers(), loc, p);
        }

        public void beforeSyntax(Space prefix, Markers markers, @Nullable TLoc loc, PrintOutputCapture<P> p) {
            for (Marker marker : markers.getMarkers()) {
                p.append(p.getMarkerPrinter().beforePrefix(marker, new Cursor(PythonPrinter.this.getCursor(), (Object)marker), PYTHON_MARKER_WRAPPER));
            }
            if (loc != null) {
                this.visitSpace(prefix, loc, p);
            }
            PythonPrinter.this.visitMarkers(markers, p);
            for (Marker marker : markers.getMarkers()) {
                p.append(p.getMarkerPrinter().beforeSyntax(marker, new Cursor(PythonPrinter.this.getCursor(), (Object)marker), PYTHON_MARKER_WRAPPER));
            }
        }

        public void visitRightPadded(List<? extends JRightPadded<? extends J>> nodes, TRtLoc loc, String suffixBetween, PrintOutputCapture<P> p) {
            for (int i = 0; i < nodes.size(); ++i) {
                JRightPadded<? extends J> node = nodes.get(i);
                PythonPrinter.this.visit((Tree)node.getElement(), p);
                this.visitSpace(node.getAfter(), this.adapter.getAfterLocation.apply(loc), p);
                if (i >= nodes.size() - 1) continue;
                p.append(suffixBetween);
            }
        }

        public void visitRightPadded(@Nullable JRightPadded<? extends J> rightPadded, TRtLoc loc, @Nullable String suffix, PrintOutputCapture<P> p) {
            if (rightPadded != null) {
                this.beforeSyntax(Space.EMPTY, rightPadded.getMarkers(), null, p);
                PythonPrinter.this.visit((Tree)rightPadded.getElement(), p);
                PythonPrinter.this.afterSyntax(rightPadded.getMarkers(), p);
                this.visitSpace(rightPadded.getAfter(), this.adapter.getAfterLocation.apply(loc), p);
                if (suffix != null) {
                    p.append(suffix);
                }
            }
        }

        public void visitLeftPadded(@Nullable String prefix, @Nullable JLeftPadded<? extends J> leftPadded, TLeftLoc loc, PrintOutputCapture<P> p) {
            if (leftPadded != null) {
                this.beforeSyntax(leftPadded.getBefore(), leftPadded.getMarkers(), this.adapter.getBeforeLocation.apply(loc), p);
                if (prefix != null) {
                    p.append(prefix);
                }
                PythonPrinter.this.visit((Tree)leftPadded.getElement(), p);
                PythonPrinter.this.afterSyntax(leftPadded.getMarkers(), p);
            }
        }

        public void visitContainer(String before, @Nullable JContainer<? extends J> container, TContLoc loc, String suffixBetween, @Nullable String after, PrintOutputCapture<P> p) {
            if (container == null) {
                return;
            }
            this.beforeSyntax(container.getBefore(), container.getMarkers(), this.adapter.getContainerBeforeLocation.apply(loc), p);
            p.append(before);
            this.visitRightPadded(container.getPadding().getElements(), this.adapter.getElementLocation.apply(loc), suffixBetween, p);
            PythonPrinter.this.afterSyntax(container.getMarkers(), p);
            p.append(after == null ? "" : after);
        }

        public AdaptedMethods(PythonPrinterAdapter<TTree, TLoc, TLeftLoc, TRtLoc, TContLoc, P> adapter) {
            this.adapter = adapter;
        }
    }

    private static class ContainsNewlineVisitor
    extends JavaVisitor<AtomicBoolean> {
        private ContainsNewlineVisitor() {
        }

        public Space visitSpace(Space space, Space.Location loc, AtomicBoolean hasNewline) {
            if ((space = super.visitSpace(space, loc, (Object)hasNewline)).getWhitespace().contains("\n")) {
                hasNewline.set(true);
            } else if (!space.getComments().isEmpty()) {
                hasNewline.set(true);
            }
            return space;
        }

        public J visitImport(J.Import impoort, AtomicBoolean hasNewline) {
            impoort = (J.Import)super.visitImport(impoort, (Object)hasNewline);
            this.visitLeftPadded(impoort.getPadding().getAlias(), JLeftPadded.Location.LANGUAGE_EXTENSION, hasNewline);
            return impoort;
        }
    }
}

