/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.internal.el;

import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.picketlink.Identity;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.PartitionManager;
import org.picketlink.idm.RelationshipManager;
import org.picketlink.internal.el.ELEvaluationContext;
import org.picketlink.internal.el.PicketLinkELResolver;
import org.picketlink.internal.el.PicketLinkFunctionMapper;
import org.picketlink.producer.LevelFactoryResolver;

@ApplicationScoped
public class ELProcessor {
    private ExpressionFactory expressionFactory;
    private CompositeELResolver elResolver;
    @Inject
    private BeanManager beanManager;
    @Inject
    private Instance<Identity> identityInstance;
    @Inject
    private Instance<PartitionManager> partitionManager;
    @Inject
    private Instance<IdentityManager> identityManagerInstance;
    @Inject
    private Instance<RelationshipManager> relationshipManagerInstance;
    @Inject
    private Instance<LevelFactoryResolver> levelFactoryResolverInstance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R eval(String expression) {
        Object value;
        PicketLinkELContext context = new PicketLinkELContext((ELResolver)this.elResolver);
        ValueExpression valueExpression = this.expressionFactory.createValueExpression((ELContext)context, expression, Object.class);
        try {
            this.createEvaluationContext();
            value = valueExpression.getValue((ELContext)context);
        }
        finally {
            this.releaseEvaluationContext();
        }
        return (R)value;
    }

    @Inject
    private void initialize() {
        this.expressionFactory = this.beanManager.wrapExpressionFactory(ExpressionFactory.newInstance());
        this.elResolver = new CompositeELResolver();
        this.elResolver.add((ELResolver)new PicketLinkELResolver(this.beanManager.getELResolver()));
        this.elResolver.add((ELResolver)new ArrayELResolver(false));
        this.elResolver.add((ELResolver)new ListELResolver(false));
        this.elResolver.add((ELResolver)new MapELResolver(false));
        this.elResolver.add((ELResolver)new ResourceBundleELResolver());
        this.elResolver.add((ELResolver)new BeanELResolver(false));
    }

    private void createEvaluationContext() {
        ELEvaluationContext evaluationContext = ELEvaluationContext.get();
        evaluationContext.setIdentity((Identity)this.identityInstance.get());
        evaluationContext.setPartitionManager((PartitionManager)this.partitionManager.get());
        evaluationContext.setLevelFactory(((LevelFactoryResolver)this.levelFactoryResolverInstance.get()).resolve());
    }

    private void releaseEvaluationContext() {
        ELEvaluationContext.release();
    }

    private class PicketLinkELContext
    extends ELContext {
        private final ELResolver elResolver;

        public PicketLinkELContext(ELResolver elResolver) {
            this.elResolver = elResolver;
        }

        public ELResolver getELResolver() {
            return this.elResolver;
        }

        public FunctionMapper getFunctionMapper() {
            return new PicketLinkFunctionMapper();
        }

        public VariableMapper getVariableMapper() {
            return null;
        }
    }
}

