/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.staticinitializers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.Handle;
import org.objectweb.asm.tree.InvokeDynamicInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.intercept.staticinitializers.Call;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;

class StaticInitializerInterceptor
implements MutationInterceptor {
    private Predicate<MutationDetails> isStaticInitCode;

    StaticInitializerInterceptor() {
    }

    @Override
    public void begin(ClassTree clazz) {
        this.analyseClass(clazz);
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        if (this.isStaticInitCode != null) {
            return mutations.stream().filter(this.isStaticInitCode.negate()).collect(Collectors.toList());
        }
        return mutations;
    }

    @Override
    public void end() {
        this.isStaticInitCode = null;
    }

    private void analyseClass(ClassTree tree) {
        Optional<MethodTree> clinit = tree.methods().stream().filter(this.nameEquals("<clinit>")).findFirst();
        if (clinit.isPresent()) {
            Set privateMethods = tree.methods().stream().filter(m -> m.isPrivate()).map(MethodTree::asLocation).collect(Collectors.toSet());
            Map<Location, List<Call>> callTree = tree.methods().stream().filter(m -> m.isPrivate() || m.rawNode().name.equals("<clinit>")).flatMap(m -> this.allCallsFor(tree, (MethodTree)m).stream().map(c -> new Call(m.asLocation(), (Location)c))).filter(c -> privateMethods.contains(c.to())).collect(Collectors.groupingBy(Call::from));
            HashSet<Location> visited = new HashSet<Location>();
            this.visit(callTree, visited, clinit.get().asLocation());
            this.isStaticInitCode = m -> visited.contains(m.getId().getLocation());
        }
    }

    private List<Location> allCallsFor(ClassTree tree, MethodTree m) {
        return Stream.concat(this.callsFor(tree, m), this.invokeDynamicCallsFor(tree, m)).collect(Collectors.toList());
    }

    private Stream<Location> callsFor(ClassTree tree, MethodTree m) {
        return m.instructions().stream().flatMap(this.is(MethodInsnNode.class)).filter(this.calls(tree.name())).map(this::asLocation);
    }

    private Stream<Location> invokeDynamicCallsFor(ClassTree tree, MethodTree m) {
        return m.instructions().stream().flatMap(this.is(InvokeDynamicInsnNode.class)).filter(this.callsDynamically(tree.name())).flatMap(this::asLocation);
    }

    private void visit(Map<Location, List<Call>> callTree, Set<Location> visited, Location l) {
        if (visited.contains(l)) {
            return;
        }
        visited.add(l);
        for (Call each : callTree.getOrDefault(l, Collections.emptyList())) {
            this.visit(callTree, visited, each.to());
        }
    }

    private Location asLocation(MethodInsnNode call) {
        return Location.location((ClassName)ClassName.fromString((String)call.owner), (String)call.name, (String)call.desc);
    }

    private Predicate<MethodInsnNode> calls(ClassName self) {
        return a -> a.owner.equals(self.asInternalName());
    }

    private Predicate<InvokeDynamicInsnNode> callsDynamically(ClassName self) {
        return a -> this.asLocation((InvokeDynamicInsnNode)a).anyMatch(l -> l.getClassName().equals((Object)self));
    }

    private Stream<Location> asLocation(InvokeDynamicInsnNode call) {
        return Arrays.stream(call.bsmArgs).flatMap(this.is(Handle.class)).flatMap(this::handleToLocation);
    }

    private Stream<Location> handleToLocation(Handle handle) {
        ClassName c = ClassName.fromString((String)handle.getOwner());
        return Stream.of(Location.location((ClassName)c, (String)handle.getName(), (String)handle.getDesc()));
    }

    private <T> Function<Object, Stream<T>> is(Class<T> clazz) {
        return a -> {
            if (a.getClass().isAssignableFrom(clazz)) {
                return Stream.of(a);
            }
            return Stream.empty();
        };
    }

    private Predicate<MethodTree> nameEquals(String name) {
        return a -> a.rawNode().name.equals(name);
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }
}

