/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis;

public final class GlobToRegEx {
    public static String convertGlobToRegEx(String line) {
        line = line.trim();
        int strLen = line.length();
        StringBuilder sb = new StringBuilder(strLen);
        if (line.startsWith("*")) {
            line = line.substring(1);
            --strLen;
        }
        if (line.endsWith("*")) {
            line = line.substring(0, strLen - 1);
            --strLen;
        }
        boolean escaping = false;
        int inCurlies = 0;
        block9: for (char currentChar : line.toCharArray()) {
            switch (currentChar) {
                case '*': {
                    if (escaping) {
                        sb.append("\\*");
                    } else {
                        sb.append(".*");
                    }
                    escaping = false;
                    continue block9;
                }
                case '?': {
                    if (escaping) {
                        sb.append("\\?");
                    } else {
                        sb.append('.');
                    }
                    escaping = false;
                    continue block9;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    sb.append('\\');
                    sb.append(currentChar);
                    escaping = false;
                    continue block9;
                }
                case '\\': {
                    if (escaping) {
                        sb.append("\\\\");
                        escaping = false;
                        continue block9;
                    }
                    escaping = true;
                    continue block9;
                }
                case '{': {
                    if (escaping) {
                        sb.append("\\{");
                    } else {
                        sb.append('(');
                        ++inCurlies;
                    }
                    escaping = false;
                    continue block9;
                }
                case '}': {
                    if (inCurlies > 0 && !escaping) {
                        sb.append(')');
                        --inCurlies;
                    } else if (escaping) {
                        sb.append("\\}");
                    } else {
                        sb.append("}");
                    }
                    escaping = false;
                    continue block9;
                }
                case ',': {
                    if (inCurlies > 0 && !escaping) {
                        sb.append('|');
                        continue block9;
                    }
                    if (escaping) {
                        sb.append("\\,");
                        continue block9;
                    }
                    sb.append(",");
                    continue block9;
                }
                default: {
                    escaping = false;
                    sb.append(currentChar);
                }
            }
        }
        return sb.toString();
    }
}

