/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.CoerceJavaToLua;
import org.rarefiedredis.redis.IRedisClient;
import org.rarefiedredis.redis.RedisMock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LuaScripter {
    private IRedisClient redis;
    private StringBuilder redisBindSB;
    private ScriptEngine scriptEngine;

    public LuaScripter() {
        this(new RedisMock());
    }

    public LuaScripter(IRedisClient redis) {
        this.redis = redis;
        this.redisBindSB = new StringBuilder("redis = {}\n");
        this.redisBindSB.append("redisObj = redisObj or {}\n");
        this.redisBindSB.append("function redis.call(command, ...)\n");
        this.redisBindSB.append("  local args = table.pack(...)\n");
        this.redisBindSB.append("  if command == 'set' then\n");
        this.redisBindSB.append("    print(args.n)\n");
        this.redisBindSB.append("    return redisObj:set(...)\n");
        this.redisBindSB.append("  end\n");
        this.redisBindSB.append("end\n");
        this.redisBindSB.append("function redis.pcall(...)\n");
        this.redisBindSB.append("  return pcall(redis.call(...))\n");
        this.redisBindSB.append("end\n");
        ScriptEngineManager mgr = new ScriptEngineManager();
        this.scriptEngine = mgr.getEngineByName("lua");
    }

    private List<Object> asList(Varargs args) {
        LinkedList<Object> ret = new LinkedList<Object>();
        int n = args.narg();
        for (int i = 1; i <= n; ++i) {
            LuaValue value = args.arg(i);
            if (value.isnil()) {
                ret.add(null);
                continue;
            }
            if (value.islong()) {
                ret.add(new Long(value.tolong()));
                continue;
            }
            if (value.isnumber()) {
                ret.add(new Double(value.todouble()));
                continue;
            }
            if (value.isstring()) {
                ret.add(args.tojstring());
                continue;
            }
            if (!value.istable()) continue;
            try {
                List<Object> array;
                LuaTable table = value.checktable();
                Map<String, Object> hash = this.hashPart(table);
                if (!hash.isEmpty()) {
                    ret.add(hash);
                }
                if ((array = this.arrayPart(table)).isEmpty()) continue;
                ret.add(array);
                continue;
            }
            catch (Exception e) {
                ret.add(null);
            }
        }
        return ret;
    }

    private Map<String, List<Object>> asHash(LuaTable table) {
        Varargs vt;
        LuaValue k = LuaValue.NIL;
        HashMap<String, List<Object>> hash = new HashMap<String, List<Object>>();
        while (!(k = (vt = table.next(k)).arg1()).isnil()) {
            LuaValue v = vt.arg(2);
            hash.put(k.tojstring(), this.asList((Varargs)v));
        }
        return hash;
    }

    private Map<String, Object> flatten(Map<String, List<Object>> hash) {
        HashMap<String, Object> flattened = new HashMap<String, Object>();
        for (String key : hash.keySet()) {
            List<Object> lst = hash.get(key);
            if (lst.isEmpty()) continue;
            if (lst.size() == 1) {
                flattened.put(key, lst.get(0));
                continue;
            }
            flattened.put(key, lst);
        }
        return flattened;
    }

    private Map<String, Object> hashPart(LuaTable table) {
        Map<String, List<Object>> map = this.asHash(table);
        HashMap<String, List<Object>> hash = new HashMap<String, List<Object>>();
        for (String key : map.keySet()) {
            try {
                Integer n = Integer.parseInt(key);
            }
            catch (NumberFormatException nfe) {
                hash.put(key, map.get(key));
            }
        }
        return this.flatten(hash);
    }

    private List<Object> arrayPart(LuaTable table) {
        Map<String, List<Object>> hash = this.asHash(table);
        TreeMap<Integer, Object> arrayMap = new TreeMap<Integer, Object>();
        for (String key : hash.keySet()) {
            try {
                Integer index = Integer.parseInt(key);
                arrayMap.put(index, hash.get(key).get(0));
            }
            catch (NumberFormatException nfe) {}
        }
        LinkedList<Object> array = new LinkedList<Object>();
        for (Map.Entry entry : arrayMap.entrySet()) {
            array.add(entry.getValue());
        }
        return array;
    }

    public List<Object> execute(String script) {
        return this.execute(script, new LinkedList<String>(), new LinkedList<String>());
    }

    public List<Object> execute(String script, List<String> keys) {
        return this.execute(script, keys, new LinkedList<String>());
    }

    public List<Object> execute(String script, List<String> keys, List<String> args) {
        int i;
        StringBuilder scriptSB = new StringBuilder(this.redisBindSB);
        if (!keys.isEmpty()) {
            scriptSB.append("KEYS = {");
            for (i = 0; i < keys.size() - 1; ++i) {
                scriptSB.append("\"");
                scriptSB.append(keys.get(i));
                scriptSB.append("\",");
            }
            scriptSB.append("\"");
            scriptSB.append(keys.get(keys.size() - 1));
            scriptSB.append("\"}\n");
        }
        if (!args.isEmpty()) {
            scriptSB.append("ARGV = {");
            for (i = 0; i < args.size() - 1; ++i) {
                scriptSB.append("\"");
                scriptSB.append(args.get(i));
                scriptSB.append("\",");
            }
            scriptSB.append("\"");
            scriptSB.append(args.get(args.size() - 1));
            scriptSB.append("\"}\n");
        }
        scriptSB.append(script);
        try {
            CompiledScript luaScript = ((Compilable)((Object)this.scriptEngine)).compile(scriptSB.toString());
            SimpleBindings sb = new SimpleBindings();
            LuaValue luaRedis = CoerceJavaToLua.coerce((Object)this.redis);
            sb.put("redisObj", (Object)luaRedis);
            Object ret = luaScript.eval(sb);
            if (ret instanceof Varargs) {
                return this.asList((Varargs)ret);
            }
            LinkedList<Object> wrapper = new LinkedList<Object>();
            wrapper.add(ret);
            return wrapper;
        }
        catch (ScriptException e) {
            return null;
        }
    }
}

