/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.rarefiedredis.redis.AbstractRedisMock;
import org.rarefiedredis.redis.ArgException;
import org.rarefiedredis.redis.BitArgException;
import org.rarefiedredis.redis.DiscardWithoutMultiException;
import org.rarefiedredis.redis.ExecWithoutMultiException;
import org.rarefiedredis.redis.GlobToRegEx;
import org.rarefiedredis.redis.IRedisCache;
import org.rarefiedredis.redis.IRedisClient;
import org.rarefiedredis.redis.IRedisSortedSet;
import org.rarefiedredis.redis.IndexOutOfRangeException;
import org.rarefiedredis.redis.NoKeyException;
import org.rarefiedredis.redis.NotFloatException;
import org.rarefiedredis.redis.NotFloatHashException;
import org.rarefiedredis.redis.NotFloatMinMaxException;
import org.rarefiedredis.redis.NotIntegerException;
import org.rarefiedredis.redis.NotIntegerHashException;
import org.rarefiedredis.redis.NotValidStringRangeItemException;
import org.rarefiedredis.redis.RedisHashCache;
import org.rarefiedredis.redis.RedisListCache;
import org.rarefiedredis.redis.RedisMockClient;
import org.rarefiedredis.redis.RedisMockMulti;
import org.rarefiedredis.redis.RedisSetCache;
import org.rarefiedredis.redis.RedisSortedSetCache;
import org.rarefiedredis.redis.RedisStringCache;
import org.rarefiedredis.redis.ScanResult;
import org.rarefiedredis.redis.SyntaxErrorException;
import org.rarefiedredis.redis.WrongTypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RedisMock
extends AbstractRedisMock {
    private RedisStringCache stringCache = new RedisStringCache();
    private RedisListCache listCache = new RedisListCache();
    private RedisSetCache setCache = new RedisSetCache();
    private RedisHashCache hashCache = new RedisHashCache();
    private RedisSortedSetCache zsetCache = new RedisSortedSetCache();
    private List<IRedisCache> caches = new ArrayList<IRedisCache>();
    private Map<String, Timer> timers;
    private Map<String, Long> expirations;
    private Map<String, WatchKey> watchers;

    public RedisMock() {
        this.caches.add(this.stringCache);
        this.caches.add(this.listCache);
        this.caches.add(this.setCache);
        this.caches.add(this.hashCache);
        this.caches.add(this.zsetCache);
        this.timers = new HashMap<String, Timer>();
        this.expirations = new HashMap<String, Long>();
        this.watchers = new HashMap<String, WatchKey>();
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Override
    public IRedisClient createClient() {
        return new RedisMockClient(this);
    }

    private void checkType(String key, String type) throws WrongTypeException {
        if (this.exists(key).booleanValue() && !this.type(key).equals(type)) {
            throw new WrongTypeException();
        }
    }

    private void keyModified(String key) {
        if (this.watchers.containsKey(key)) {
            this.watchers.get((Object)key).modified = true;
        }
    }

    @Override
    public synchronized Long del(String ... keys) {
        long deleted = 0L;
        block0: for (int idx = 0; idx < keys.length; ++idx) {
            String key = keys[idx];
            this.timers.remove(key);
            this.expirations.remove(key);
            for (IRedisCache cache : this.caches) {
                if (!cache.exists(key).booleanValue()) continue;
                cache.remove(key);
                this.keyModified(key);
                ++deleted;
                continue block0;
            }
        }
        return deleted;
    }

    @Override
    public synchronized Boolean exists(String key) {
        for (IRedisCache cache : this.caches) {
            if (!cache.exists(key).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Boolean expire(String key, int seconds) {
        return this.pexpire(key, seconds * 1000);
    }

    @Override
    public synchronized Boolean expireat(String key, long timestamp) {
        Date now = new Date();
        return this.pexpire(key, timestamp * 1000L - now.getTime());
    }

    @Override
    public synchronized Boolean persist(String key) {
        if (this.exists(key).booleanValue() && this.timers.containsKey(key)) {
            this.timers.get(key).cancel();
            this.timers.remove(key);
            return true;
        }
        return false;
    }

    @Override
    public synchronized Boolean pexpire(final String key, long milliseconds) {
        if (this.exists(key).booleanValue()) {
            Timer timer = new Timer();
            this.timers.put(key, timer);
            this.expirations.put(key, System.currentTimeMillis() + milliseconds);
            timer.schedule(new TimerTask(){

                public void run() {
                    RedisMock.this.del(key);
                }
            }, milliseconds);
            return true;
        }
        return false;
    }

    @Override
    public synchronized Boolean pexpireat(String key, long timestamp) {
        Date now = new Date();
        return this.pexpire(key, timestamp - now.getTime());
    }

    @Override
    public synchronized Long ttl(String key) {
        Long ms = this.pttl(key);
        if (ms < 0L) {
            return ms;
        }
        return ms / 1000L;
    }

    @Override
    public synchronized Long pttl(String key) {
        if (!this.exists(key).booleanValue()) {
            return -2L;
        }
        if (!this.timers.containsKey(key)) {
            return -1L;
        }
        return this.expirations.get(key) - System.currentTimeMillis();
    }

    @Override
    public synchronized String type(String key) {
        for (IRedisCache cache : this.caches) {
            if (!cache.exists(key).booleanValue()) continue;
            return cache.type();
        }
        return "none";
    }

    @Override
    public synchronized Long append(String key, String value) throws WrongTypeException {
        this.checkType(key, "string");
        if (!this.exists(key).booleanValue()) {
            try {
                this.set(key, value, new String[0]);
            }
            catch (Exception exception) {}
        } else {
            this.stringCache.set(key, this.stringCache.get(key) + value, new Object[0]);
        }
        return this.strlen(key);
    }

    @Override
    public synchronized Long bitcount(String key, long ... options) throws WrongTypeException {
        long end;
        if (!this.exists(key).booleanValue()) {
            return 0L;
        }
        this.checkType(key, "string");
        String str = this.stringCache.get(key);
        long len = str.length();
        long start = options.length > 0 ? options[0] : 0L;
        long l = end = options.length > 1 ? options[1] : len - 1L;
        if (end >= len) {
            end = len - 1L;
        }
        if (start < 0L) {
            start = len + start;
        }
        if (end < 0L) {
            end = len + end;
        }
        if (start > end) {
            return 0L;
        }
        long count = 0L;
        for (long idx = start; idx <= end; ++idx) {
            for (int n = Character.codePointAt(str, (int)idx); n != 0; n >>= 1) {
                count += (long)(n & 1);
            }
        }
        return count;
    }

    @Override
    public synchronized Long bitop(String operation, String destkey, String ... keys) throws WrongTypeException {
        int idx;
        String[] strs = new String[keys.length];
        int longest = 0;
        for (idx = 0; idx < keys.length; ++idx) {
            String key = keys[idx];
            if (!this.exists(key).booleanValue()) {
                strs[idx] = "";
                continue;
            }
            this.checkType(key, "string");
            strs[idx] = this.stringCache.get(key);
            if (longest >= strs[idx].length()) continue;
            longest = strs[idx].length();
        }
        for (idx = 0; idx < strs.length; ++idx) {
            while (strs[idx].length() < longest) {
                int n = idx;
                strs[n] = strs[n] + "\u0000";
            }
        }
        operation = operation.toLowerCase();
        String s = strs[0];
        for (int idx2 = 0; idx2 < strs.length; ++idx2) {
            String str = strs[idx2];
            StringBuffer cur = new StringBuffer();
            for (int jdx = 0; jdx < longest; ++jdx) {
                int n = 0;
                if (operation.equals("and")) {
                    n = Character.codePointAt(s, jdx) & Character.codePointAt(str, jdx);
                } else if (operation.equals("or")) {
                    n = Character.codePointAt(s, jdx) | Character.codePointAt(str, jdx);
                } else if (operation.equals("xor")) {
                    n = idx2 > 0 ? Character.codePointAt(s, jdx) ^ Character.codePointAt(str, jdx) : Character.codePointAt(s, jdx);
                } else if (operation.equals("not")) {
                    n = ~Character.codePointAt(s, jdx);
                }
                cur.append((char)n);
            }
            s = cur.toString();
            if (operation.equals("not")) break;
        }
        try {
            this.set(destkey, s, new String[0]);
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        return s.length();
    }

    @Override
    public synchronized Long bitpos(String key, long bit, long ... options) throws WrongTypeException, BitArgException {
        long idx;
        boolean noend;
        if (bit != 0L && bit != 1L) {
            throw new BitArgException();
        }
        this.checkType(key, "string");
        if (!this.exists(key).booleanValue()) {
            if (bit == 0L) {
                return 0L;
            }
            return -1L;
        }
        String value = this.stringCache.get(key);
        long len = value.length();
        long start = options.length > 0 ? options[0] : 0L;
        long end = options.length > 1 ? options[1] : len - 1L;
        boolean bl = noend = options.length <= 1;
        if (start < 0L) {
            start = len + start;
        }
        if (end < 0L) {
            end = len + start;
        }
        if (start > end) {
            return -1L;
        }
        for (idx = start; idx <= end; ++idx) {
            int ch = Character.codePointAt(value, (int)idx);
            for (int cnt = 0; cnt < 8; ++cnt) {
                if (bit == 0L && (ch & 0x80) != 128) {
                    return idx * 8L + (long)cnt;
                }
                if (bit == 1L && (ch & 0x80) == 128) {
                    return idx * 8L + (long)cnt;
                }
                ch <<= 1;
            }
        }
        if (bit == 1L) {
            return -1L;
        }
        if (bit == 0L && noend) {
            return idx * 8L;
        }
        return -1L;
    }

    @Override
    public synchronized Long decr(String key) throws WrongTypeException, NotIntegerException {
        return this.decrby(key, 1L);
    }

    @Override
    public synchronized Long decrby(String key, long decrement) throws WrongTypeException, NotIntegerException {
        Long newValue = 0L;
        try {
            if (!this.exists(key).booleanValue()) {
                this.set(key, "0", new String[0]);
            }
            this.checkType(key, "string");
            long asInt = Long.parseLong(this.get(key));
            newValue = asInt - decrement;
            this.set(key, String.valueOf(newValue), new String[0]);
        }
        catch (NumberFormatException nfe) {
            throw new NotIntegerException();
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        return newValue;
    }

    @Override
    public synchronized String get(String key) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return null;
        }
        this.checkType(key, "string");
        return this.stringCache.get(key);
    }

    @Override
    public synchronized Boolean getbit(String key, long offset) throws WrongTypeException {
        long pos;
        if (!this.exists(key).booleanValue()) {
            return false;
        }
        this.checkType(key, "string");
        String value = this.stringCache.get(key);
        if (offset >= (long)value.length() * 8L) {
            return false;
        }
        int n = value.codePointAt((int)Math.floor(offset / 8L));
        return (n >> (int)(pos = offset % 8L) & 1) == 1;
    }

    @Override
    public synchronized String getrange(String key, long start, long end) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return "";
        }
        this.checkType(key, "string");
        String value = this.stringCache.get(key);
        long len = 0L;
        if (end < 0L) {
            end = (long)value.length() + end;
        }
        if (start < 0L) {
            start = (long)value.length() + start;
        }
        try {
            return value.substring((int)start, (int)(end + 1L));
        }
        catch (IndexOutOfBoundsException e) {
            return "";
        }
    }

    @Override
    public synchronized String getset(String key, String value) throws WrongTypeException {
        String prev = null;
        try {
            prev = this.get(key);
            this.set(key, value, new String[0]);
        }
        catch (WrongTypeException wte) {
            throw wte;
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        return prev;
    }

    @Override
    public synchronized Long incr(String key) throws WrongTypeException, NotIntegerException {
        return this.decrby(key, -1L);
    }

    @Override
    public synchronized Long incrby(String key, long increment) throws WrongTypeException, NotIntegerException {
        return this.decrby(key, -increment);
    }

    @Override
    public synchronized String incrbyfloat(String key, double increment) throws WrongTypeException, NotFloatException {
        Double newValue = 0.0;
        try {
            if (!this.exists(key).booleanValue()) {
                this.set(key, "0.0", new String[0]);
            }
            this.checkType(key, "string");
            double asDouble = Double.parseDouble(this.get(key));
            newValue = asDouble + increment;
            this.set(key, String.valueOf(newValue), new String[0]);
        }
        catch (NumberFormatException nfe) {
            throw new NotFloatException();
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        return String.valueOf(newValue);
    }

    @Override
    public synchronized String[] mget(String ... keys) {
        String[] gets = new String[keys.length];
        for (int idx = 0; idx < keys.length; ++idx) {
            try {
                gets[idx] = this.get(keys[idx]);
                continue;
            }
            catch (WrongTypeException e) {
                gets[idx] = null;
            }
        }
        return gets;
    }

    @Override
    public synchronized String mset(String ... keyvalues) throws ArgException {
        if (keyvalues.length == 0 || keyvalues.length % 2 != 0) {
            throw new ArgException("mset");
        }
        for (int idx = 0; idx < keyvalues.length; ++idx) {
            if (idx % 2 != 0) continue;
            try {
                this.set(keyvalues[idx], keyvalues[idx + 1], new String[0]);
                continue;
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
        return "OK";
    }

    @Override
    public synchronized Boolean msetnx(String ... keyvalues) throws ArgException {
        int idx;
        if (keyvalues.length == 0 || keyvalues.length % 2 != 0) {
            throw new ArgException("msetnx");
        }
        for (idx = 0; idx < keyvalues.length; ++idx) {
            if (idx % 2 != 0 || !this.exists(keyvalues[idx]).booleanValue()) continue;
            return false;
        }
        for (idx = 0; idx < keyvalues.length; ++idx) {
            if (idx % 2 != 0) continue;
            try {
                this.set(keyvalues[idx], keyvalues[idx + 1], new String[0]);
                continue;
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    public synchronized String psetex(String key, long milliseconds, String value) {
        try {
            this.set(key, value, "px", String.valueOf(milliseconds));
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        return "OK";
    }

    @Override
    public synchronized String set(String key, String value, String ... options) throws SyntaxErrorException {
        boolean nx = false;
        boolean xx = false;
        int ex = -1;
        long px = -1L;
        for (String string : options) {
        }
        for (int idx = 0; idx < options.length; ++idx) {
            String option = options[idx];
            if (option == "nx") {
                nx = true;
                continue;
            }
            if (option == "xx") {
                xx = true;
                continue;
            }
            if (option == "ex") {
                if (idx + 1 >= options.length) {
                    throw new SyntaxErrorException();
                }
                ex = Integer.parseInt(options[idx + 1]);
                continue;
            }
            if (option != "px") continue;
            if (idx + 1 >= options.length) {
                throw new SyntaxErrorException();
            }
            px = Long.parseLong(options[idx + 1]);
        }
        if (nx && this.exists(key).booleanValue()) {
            return null;
        }
        if (xx) {
            if (!this.exists(key).booleanValue()) {
                return null;
            }
            this.del(key);
        }
        if (!nx && !xx && this.exists(key).booleanValue()) {
            this.del(key);
        }
        this.stringCache.set(key, value, new Object[0]);
        this.keyModified(key);
        if (ex != -1) {
            this.expire(key, ex);
        }
        if (px != -1L) {
            this.pexpire(key, px);
        }
        return "OK";
    }

    @Override
    public synchronized Long setbit(String key, long offset, boolean value) throws WrongTypeException {
        int bit;
        this.checkType(key, "string");
        if (!this.exists(key).booleanValue()) {
            try {
                this.set(key, "", new String[0]);
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
        int byteIdx = (int)Math.floor(offset / 8L);
        int bitIdx = (int)(offset % 8L);
        String val = this.get(key);
        while (val.length() < byteIdx + 1) {
            val = val + "\u0000";
        }
        int code = val.codePointAt(byteIdx);
        int mask = 128;
        for (int idx = 0; idx < bitIdx; ++idx) {
            mask >>= 1;
        }
        int n = bit = (code & mask) == 0 ? 0 : 1;
        code = !value ? (code &= ~mask) : (code |= mask);
        String newVal = "";
        newVal = newVal + val.substring(0, byteIdx);
        newVal = newVal + (char)code;
        newVal = newVal + val.substring(byteIdx + 1);
        try {
            this.set(key, newVal, new String[0]);
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        return bit;
    }

    @Override
    public synchronized String setex(String key, int seconds, String value) {
        try {
            this.set(key, value, "ex", String.valueOf(seconds));
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        return "OK";
    }

    @Override
    public synchronized Long setnx(String key, String value) {
        if (!this.exists(key).booleanValue()) {
            try {
                this.set(key, value, new String[0]);
                return 1L;
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
        return 0L;
    }

    @Override
    public synchronized Long setrange(String key, long offset, String value) throws WrongTypeException {
        int idx;
        this.checkType(key, "string");
        if (!this.exists(key).booleanValue()) {
            try {
                this.set(key, "", new String[0]);
            }
            catch (SyntaxErrorException syntaxErrorException) {
                // empty catch block
            }
        }
        String val = this.get(key);
        for (idx = val.length(); idx < (int)(offset + (long)value.length()); ++idx) {
            val = val + "\u0000";
        }
        String newValue = val.substring(0, (int)offset);
        for (idx = (int)offset; idx < (int)(offset + (long)value.length()); ++idx) {
            newValue = newValue + value.charAt(idx - (int)offset);
        }
        newValue = newValue + val.substring((int)(offset + (long)value.length()));
        try {
            this.set(key, newValue, new String[0]);
        }
        catch (SyntaxErrorException syntaxErrorException) {
            // empty catch block
        }
        return newValue.length();
    }

    @Override
    public synchronized Long strlen(String key) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return 0L;
        }
        this.checkType(key, "string");
        return this.stringCache.get(key).length();
    }

    @Override
    public synchronized String lindex(String key, long index) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return null;
        }
        this.checkType(key, "list");
        if (index < 0L) {
            index = (long)this.listCache.get(key).size() + index;
        }
        try {
            return (String)this.listCache.get(key).get((int)index);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public synchronized Long linsert(String key, String before_after, String pivot, String value) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return 0L;
        }
        this.checkType(key, "list");
        int index = this.listCache.get(key).indexOf(pivot);
        before_after = before_after.toLowerCase();
        if (index != -1) {
            if (before_after.equals("before")) {
                this.listCache.set(key, value, new Object[]{index});
                this.keyModified(key);
            } else if (before_after.equals("after")) {
                this.listCache.set(key, value, new Object[]{index + 1});
                this.keyModified(key);
            }
            return (long)this.llen(key);
        }
        return -1L;
    }

    @Override
    public synchronized Long llen(String key) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return 0L;
        }
        this.checkType(key, "list");
        Object lst = this.listCache.get(key);
        Long len = 0L;
        int size = lst.size();
        len = len + (long)size;
        if (size == Integer.MAX_VALUE) {
            Iterator iterator = lst.iterator();
            while (iterator.hasNext()) {
                String elem = (String)iterator.next();
                len = len + 1L;
            }
        }
        return len;
    }

    @Override
    public synchronized String lpop(String key) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return null;
        }
        this.checkType(key, "list");
        try {
            String popped = (String)this.listCache.get(key).remove(0);
            if (this.listCache.get(key).isEmpty()) {
                this.del(key);
            }
            this.keyModified(key);
            return popped;
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public synchronized Long lpush(String key, String element, String ... elements) throws WrongTypeException {
        this.checkType(key, "list");
        this.listCache.set(key, element, new Object[]{0});
        for (String elem : elements) {
            this.listCache.set(key, elem, new Object[]{0});
        }
        this.keyModified(key);
        return this.llen(key);
    }

    @Override
    public synchronized Long lpushx(String key, String element) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return 0L;
        }
        this.checkType(key, "list");
        return this.lpush(key, element, new String[0]);
    }

    @Override
    public synchronized List<String> lrange(String key, long start, long end) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return new ArrayList<String>();
        }
        this.checkType(key, "list");
        Object lst = this.listCache.get(key);
        int len = lst.size();
        if (start < 0L) {
            start = (long)len + start;
        }
        if (end < 0L) {
            end = (long)len + end;
        }
        if (start > end) {
            return new ArrayList<String>();
        }
        if (start > (long)(lst.size() - 1)) {
            return new ArrayList<String>();
        }
        if (end > (long)(len - 1)) {
            end = len - 1;
        }
        if (start < 0L || end < 0L) {
            return new ArrayList<String>();
        }
        return lst.subList((int)start, (int)(end + 1L));
    }

    @Override
    public synchronized Long lrem(String key, long count, String element) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return 0L;
        }
        this.checkType(key, "list");
        long cnt = 0L;
        while (this.listCache.get(key).remove(element) && (count <= 0L || ++cnt != count)) {
        }
        if (this.listCache.get(key).size() == 0) {
            this.del(key);
        }
        if (cnt > 0L) {
            this.keyModified(key);
        }
        return cnt;
    }

    @Override
    public synchronized String lset(String key, long index, String element) throws WrongTypeException, NoKeyException, IndexOutOfRangeException {
        if (!this.exists(key).booleanValue()) {
            throw new NoKeyException();
        }
        this.checkType(key, "list");
        if (index >= (long)this.listCache.get(key).size()) {
            throw new IndexOutOfRangeException();
        }
        this.listCache.get(key).set((int)index, element);
        this.keyModified(key);
        return "OK";
    }

    @Override
    public synchronized String ltrim(String key, long start, long end) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return "OK";
        }
        this.checkType(key, "list");
        int len = this.listCache.get(key).size();
        if (start > (long)len || start > end) {
            this.del(key);
            return "OK";
        }
        if (start < 0L) {
            start = (long)len + start;
        }
        if (end < 0L) {
            end = (long)len + start;
        }
        if (end > (long)(len - 1)) {
            end = len - 1;
        }
        if (start < 0L || end < 0L) {
            return "OK";
        }
        List subl = this.listCache.get(key).subList((int)start, (int)(end + 1L));
        LinkedList<String> trimmed = new LinkedList<String>();
        for (String sub : subl) {
            trimmed.add(sub);
        }
        this.listCache.get(key).retainAll(trimmed);
        this.keyModified(key);
        return "OK";
    }

    @Override
    public synchronized String rpop(String key) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return null;
        }
        this.checkType(key, "list");
        try {
            String popped = (String)this.listCache.get(key).remove(this.listCache.get(key).size() - 1);
            if (this.listCache.get(key).isEmpty()) {
                this.del(key);
            }
            this.keyModified(key);
            return popped;
        }
        catch (IndexOutOfBoundsException ie) {
            return null;
        }
    }

    @Override
    public synchronized String rpoplpush(String source, String dest) throws WrongTypeException {
        if (!this.exists(source).booleanValue()) {
            return null;
        }
        this.checkType(source, "list");
        this.checkType(dest, "list");
        String element = this.rpop(source);
        this.lpush(dest, element, new String[0]);
        return element;
    }

    @Override
    public synchronized Long rpush(String key, String element, String ... elements) throws WrongTypeException {
        this.checkType(key, "list");
        this.listCache.set(key, element, new Object[0]);
        for (String elem : elements) {
            this.listCache.set(key, elem, new Object[0]);
        }
        this.keyModified(key);
        return this.llen(key);
    }

    @Override
    public synchronized Long rpushx(String key, String element) throws WrongTypeException {
        if (!this.exists(key).booleanValue()) {
            return 0L;
        }
        this.checkType(key, "list");
        return this.rpush(key, element, new String[0]);
    }

    @Override
    public synchronized Long sadd(String key, String member, String ... members) throws WrongTypeException {
        this.checkType(key, "set");
        Long count = 0L;
        if (!this.setCache.exists(key).booleanValue() || !this.setCache.get(key).contains(member)) {
            this.setCache.set(key, member, new Object[0]);
            count = count + 1L;
        }
        for (String memb : members) {
            if (this.setCache.exists(key).booleanValue() && this.setCache.get(key).contains(memb)) continue;
            this.setCache.set(key, memb, new Object[0]);
            count = count + 1L;
        }
        if (count > 0L) {
            this.keyModified(key);
        }
        return count;
    }

    @Override
    public synchronized Long scard(String key) throws WrongTypeException {
        this.checkType(key, "set");
        if (!this.setCache.exists(key).booleanValue()) {
            return 0L;
        }
        return this.setCache.get(key).size();
    }

    @Override
    public synchronized Set<String> sdiff(String key, String ... keys) throws WrongTypeException {
        this.checkType(key, "set");
        for (String k : keys) {
            this.checkType(k, "set");
        }
        HashSet<String> diff = new HashSet<String>(this.smembers(key));
        for (String k : keys) {
            diff.removeAll(this.smembers(k));
        }
        return diff;
    }

    @Override
    public synchronized Long sdiffstore(String destination, String key, String ... keys) throws WrongTypeException {
        Set<String> diff = this.sdiff(key, keys);
        if (this.exists(destination).booleanValue()) {
            this.del(destination);
        }
        for (String d : diff) {
            this.sadd(destination, d, new String[0]);
        }
        this.keyModified(destination);
        return diff.size();
    }

    @Override
    public synchronized Set<String> sinter(String key, String ... keys) throws WrongTypeException {
        this.checkType(key, "set");
        for (String k : keys) {
            this.checkType(k, "set");
        }
        HashSet<String> inter = new HashSet<String>(this.smembers(key));
        for (String k : keys) {
            inter.retainAll(this.smembers(k));
        }
        return inter;
    }

    @Override
    public synchronized Long sinterstore(String destination, String key, String ... keys) throws WrongTypeException {
        Set<String> inter = this.sinter(key, keys);
        if (this.exists(destination).booleanValue()) {
            this.del(destination);
        }
        for (String i : inter) {
            this.sadd(destination, i, new String[0]);
        }
        this.keyModified(destination);
        return inter.size();
    }

    @Override
    public synchronized Boolean sismember(String key, String member) throws WrongTypeException {
        this.checkType(key, "set");
        if (!this.setCache.exists(key).booleanValue()) {
            return false;
        }
        return this.setCache.get(key).contains(member);
    }

    @Override
    public synchronized Set<String> smembers(String key) throws WrongTypeException {
        this.checkType(key, "set");
        if (!this.exists(key).booleanValue()) {
            return Collections.unmodifiableSet(new HashSet());
        }
        return Collections.unmodifiableSet(this.setCache.get(key));
    }

    @Override
    public synchronized Boolean smove(String source, String dest, String member) throws WrongTypeException {
        this.checkType(source, "set");
        this.checkType(dest, "set");
        Long rem = this.srem(source, member, new String[0]);
        if (rem == 0L) {
            return false;
        }
        this.sadd(dest, member, new String[0]);
        this.keyModified(source);
        this.keyModified(dest);
        return rem == 1L;
    }

    @Override
    public synchronized String spop(String key) throws WrongTypeException {
        String member = this.srandmember(key);
        if (member != null) {
            this.srem(key, member, new String[0]);
        }
        return member;
    }

    @Override
    public synchronized String srandmember(String key) throws WrongTypeException {
        Iterator iterator;
        this.checkType(key, "set");
        if (this.exists(key).booleanValue() && (iterator = this.setCache.get(key).iterator()).hasNext()) {
            String member = (String)iterator.next();
            return member;
        }
        return null;
    }

    @Override
    public synchronized List<String> srandmember(String key, long count) throws WrongTypeException {
        boolean negative = count < 0L;
        count = Math.abs(count);
        ArrayList<String> lst = new ArrayList<String>((int)count);
        while (lst.size() < (int)count) {
            Iterator iterator = this.setCache.get(key).iterator();
            while (iterator.hasNext()) {
                String member = (String)iterator.next();
                lst.add(member);
                if (lst.size() != (int)count) continue;
                break;
            }
            if (negative) continue;
            break;
        }
        return lst;
    }

    @Override
    public synchronized Long srem(String key, String member, String ... members) throws WrongTypeException {
        this.checkType(key, "set");
        if (!this.setCache.exists(key).booleanValue()) {
            return 0L;
        }
        Long count = 0L;
        if (this.setCache.removeValue(key, member).booleanValue()) {
            count = count + 1L;
        }
        for (String memb : members) {
            if (!this.setCache.removeValue(key, memb).booleanValue()) continue;
            count = count + 1L;
        }
        if (count > 0L) {
            this.keyModified(key);
        }
        return count;
    }

    @Override
    public synchronized Set<String> sunion(String key, String ... keys) throws WrongTypeException {
        this.checkType(key, "set");
        for (String k : keys) {
            this.checkType(k, "set");
        }
        HashSet<String> union = new HashSet<String>(this.smembers(key));
        for (String k : keys) {
            union.addAll(this.smembers(k));
        }
        return union;
    }

    @Override
    public synchronized Long sunionstore(String destination, String key, String ... keys) throws WrongTypeException {
        Set<String> union = this.sunion(key, keys);
        if (this.exists(destination).booleanValue()) {
            this.del(destination);
        }
        for (String u : union) {
            this.sadd(destination, u, new String[0]);
        }
        this.keyModified(destination);
        return union.size();
    }

    @Override
    public synchronized ScanResult<Set<String>> sscan(String key, long cursor, String ... options) throws WrongTypeException {
        this.checkType(key, "set");
        Long count = null;
        Pattern match = null;
        for (int idx = 0; idx < options.length; ++idx) {
            if (options[idx].equals("count")) {
                count = Long.valueOf(options[idx + 1]);
                continue;
            }
            if (!options[idx].equals("match")) continue;
            match = Pattern.compile(GlobToRegEx.convertGlobToRegEx(options[idx + 1]));
        }
        if (count == null) {
            count = 10L;
        }
        HashSet<String> scanned = new HashSet<String>();
        Set<String> members = this.smembers(key);
        Long idx = 0L;
        for (String member : members) {
            if ((idx = Long.valueOf(idx + 1L)) <= cursor) continue;
            if (match == null || match.matcher(member).matches()) {
                scanned.add(member);
            }
            if ((long)scanned.size() < count) continue;
            break;
        }
        if (idx >= this.scard(key)) {
            idx = 0L;
        }
        return new ScanResult<Set<String>>(idx, scanned);
    }

    @Override
    public synchronized Long hdel(String key, String field, String ... fields) throws WrongTypeException {
        this.checkType(key, "hash");
        if (!this.exists(key).booleanValue()) {
            return 0L;
        }
        Long count = 0L;
        if (this.hashCache.removeValue(key, field).booleanValue()) {
            count = count + 1L;
        }
        for (String f : fields) {
            if (!this.hashCache.removeValue(key, f).booleanValue()) continue;
            count = count + 1L;
        }
        if (count > 0L) {
            this.keyModified(key);
        }
        return count;
    }

    @Override
    public synchronized Boolean hexists(String key, String field) throws WrongTypeException {
        this.checkType(key, "hash");
        if (!this.exists(key).booleanValue()) {
            return false;
        }
        return this.hashCache.get(key).containsKey(field);
    }

    @Override
    public synchronized String hget(String key, String field) throws WrongTypeException {
        this.checkType(key, "hash");
        if (!this.exists(key).booleanValue()) {
            return null;
        }
        return (String)this.hashCache.get(key).get(field);
    }

    @Override
    public synchronized Map<String, String> hgetall(String key) throws WrongTypeException {
        this.checkType(key, "hash");
        if (!this.exists(key).booleanValue()) {
            return new HashMap<String, String>();
        }
        return Collections.unmodifiableMap(this.hashCache.get(key));
    }

    @Override
    public synchronized Long hincrby(String key, String field, long increment) throws WrongTypeException, NotIntegerHashException {
        this.checkType(key, "hash");
        if (!this.hexists(key, field).booleanValue()) {
            this.hset(key, field, String.valueOf(increment));
        } else {
            try {
                Long no = Long.valueOf(this.hget(key, field));
                this.hset(key, field, String.valueOf(no + increment));
            }
            catch (NumberFormatException nfe) {
                throw new NotIntegerHashException();
            }
        }
        this.keyModified(key);
        return Long.valueOf(this.hget(key, field));
    }

    @Override
    public synchronized String hincrbyfloat(String key, String field, double increment) throws WrongTypeException, NotFloatHashException {
        this.checkType(key, "hash");
        if (!this.hexists(key, field).booleanValue()) {
            this.hset(key, field, String.valueOf(increment));
        } else {
            try {
                Double no = Double.parseDouble(this.hget(key, field));
                this.hset(key, field, String.valueOf(no + increment));
            }
            catch (NumberFormatException nfe) {
                throw new NotFloatHashException();
            }
        }
        this.keyModified(key);
        return this.hget(key, field);
    }

    @Override
    public synchronized Set<String> hkeys(String key) throws WrongTypeException {
        this.checkType(key, "hash");
        if (!this.exists(key).booleanValue()) {
            return new HashSet<String>();
        }
        return this.hashCache.get(key).keySet();
    }

    @Override
    public synchronized Long hlen(String key) throws WrongTypeException {
        this.checkType(key, "hash");
        if (!this.exists(key).booleanValue()) {
            return 0L;
        }
        return this.hashCache.get(key).size();
    }

    @Override
    public synchronized List<String> hmget(String key, String field, String ... fields) throws WrongTypeException {
        this.checkType(key, "hash");
        ArrayList<String> lst = new ArrayList<String>(1 + fields.length);
        if (!this.exists(key).booleanValue()) {
            for (int idx = 0; idx < 1 + fields.length; ++idx) {
                lst.add(null);
            }
            return lst;
        }
        lst.add(this.hget(key, field));
        for (String f : fields) {
            lst.add(this.hget(key, f));
        }
        return lst;
    }

    @Override
    public synchronized String hmset(String key, String field, String value, String ... fieldsvalues) throws WrongTypeException, ArgException {
        this.checkType(key, "hash");
        if (fieldsvalues.length % 2 != 0) {
            throw new ArgException("HMSET");
        }
        this.hset(key, field, value);
        for (int idx = 0; idx < fieldsvalues.length; ++idx) {
            if (idx % 2 != 0) continue;
            this.hset(key, fieldsvalues[idx], fieldsvalues[idx + 1]);
        }
        return "OK";
    }

    @Override
    public synchronized Boolean hset(String key, String field, String value) throws WrongTypeException {
        this.checkType(key, "hash");
        boolean ret = true;
        if (this.exists(key).booleanValue() && this.hashCache.get(key).containsKey(field)) {
            ret = false;
        }
        this.hashCache.set(key, field, new Object[]{value});
        this.keyModified(key);
        return ret;
    }

    @Override
    public synchronized Boolean hsetnx(String key, String field, String value) throws WrongTypeException {
        this.checkType(key, "hash");
        boolean ret = false;
        if (!this.exists(key).booleanValue() || !this.hashCache.get(key).containsKey(field)) {
            ret = true;
            this.hset(key, field, value);
        }
        return ret;
    }

    @Override
    public synchronized Long hstrlen(String key, String field) throws WrongTypeException {
        this.checkType(key, "hash");
        if (!this.exists(key).booleanValue() || !this.hashCache.get(key).containsKey(field)) {
            return 0L;
        }
        return ((String)this.hashCache.get(key).get(field)).length();
    }

    @Override
    public synchronized List<String> hvals(String key) throws WrongTypeException {
        this.checkType(key, "hash");
        if (!this.exists(key).booleanValue()) {
            return new ArrayList<String>();
        }
        return Collections.unmodifiableList(new ArrayList(this.hashCache.get(key).values()));
    }

    @Override
    public synchronized ScanResult<Map<String, String>> hscan(String key, long cursor, String ... options) throws WrongTypeException {
        this.checkType(key, "hash");
        Long count = null;
        Pattern match = null;
        for (int idx = 0; idx < options.length; ++idx) {
            if (options[idx].equals("count")) {
                count = Long.valueOf(options[idx + 1]);
                continue;
            }
            if (!options[idx].equals("match")) continue;
            match = Pattern.compile(GlobToRegEx.convertGlobToRegEx(options[idx + 1]));
        }
        if (count == null) {
            count = 10L;
        }
        HashMap<String, String> scanned = new HashMap<String, String>();
        Map<String, String> all = this.hgetall(key);
        Long idx = 0L;
        for (String k : all.keySet()) {
            if ((idx = Long.valueOf(idx + 1L)) <= cursor) continue;
            if (match == null || match.matcher(k).matches()) {
                scanned.put(k, all.get(k));
            }
            if ((long)scanned.size() < count) continue;
            break;
        }
        return new ScanResult<Map<String, String>>(idx, scanned);
    }

    @Override
    public String discard() throws DiscardWithoutMultiException {
        throw new DiscardWithoutMultiException();
    }

    @Override
    public List<Object> exec() throws ExecWithoutMultiException {
        throw new ExecWithoutMultiException();
    }

    @Override
    public IRedisClient multi() {
        return new RedisMockMulti(this);
    }

    @Override
    public synchronized String unwatch() {
        return this.unwatch(this.hashCode());
    }

    public synchronized String unwatch(Integer hashCode) {
        LinkedList<String> keysToRemove = new LinkedList<String>();
        for (String key : this.watchers.keySet()) {
            this.watchers.get((Object)key).watchers.remove(hashCode);
            if (this.watchers.get((Object)key).watchers.size() != 0) continue;
            keysToRemove.add(key);
        }
        for (String key : keysToRemove) {
            this.watchers.remove(key);
        }
        return "OK";
    }

    @Override
    public synchronized String watch(String key) {
        return this.watch(key, this.hashCode());
    }

    public synchronized String watch(String key, Integer hashCode) {
        if (!this.watchers.containsKey(key)) {
            this.watchers.put(key, new WatchKey());
        }
        this.watchers.get((Object)key).watchers.add(hashCode);
        return "OK";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized boolean modified(Integer hashCode, String command, List<Object> args) {
        LinkedList<Object> keys = new LinkedList<Object>();
        if (args.get(0) instanceof String[]) {
            if (command.equals("mset") || command.equals("msetnx")) {
                void var6_7;
                String[] keysvalues = (String[])args.get(0);
                boolean bl = false;
                while (var6_7 < keysvalues.length) {
                    if (var6_7 % 2 == false) {
                        keys.add(keysvalues[var6_7]);
                    }
                    ++var6_7;
                }
            } else {
                for (String string : (String[])args.get(0)) {
                    keys.add(string);
                }
            }
        } else if (command.equals("bitop")) {
            keys.add((String)args.get(1));
        } else {
            keys.add((String)args.get(0));
        }
        if (command.equals("rpoplpush")) {
            keys.add((String)args.get(1));
        }
        if (command.equals("sdiff") || command.equals("sinter") || command.equals("sunion")) {
            for (String string : (String[])args.get(1)) {
                keys.add(string);
            }
        }
        if (command.equals("sdiffstore") || command.equals("sinterstore") || command.equals("sunionstore")) {
            keys.add((String)args.get(1));
            for (String string : (String[])args.get(2)) {
                keys.add(string);
            }
        }
        if (command.equals("smove")) {
            keys.add((String)args.get(1));
        }
        for (String string : keys) {
            if (!this.watchers.containsKey(string) || !this.watchers.get((Object)string).modified.booleanValue() || !this.watchers.get((Object)string).watchers.contains(hashCode)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized Long zadd(String key, IRedisSortedSet.ZsetPair scoremember, IRedisSortedSet.ZsetPair ... scoresmembers) throws WrongTypeException {
        this.checkType(key, "zset");
        Long count = 0L;
        if (!this.zsetCache.exists(key).booleanValue() || !this.zsetCache.get(key).contains(scoremember.member)) {
            count = count + 1L;
        }
        this.zsetCache.set(key, scoremember.member, new Object[]{scoremember.score});
        for (IRedisSortedSet.ZsetPair sms : scoresmembers) {
            if (sms == null) continue;
            if (!this.zsetCache.get(key).contains(sms.member)) {
                count = count + 1L;
            }
            this.zsetCache.set(key, sms.member, new Object[]{sms.score});
        }
        return count;
    }

    @Override
    public Long zadd(String key, double score, String member, Object ... scoresmembers) throws WrongTypeException, SyntaxErrorException, NotFloatException {
        if (scoresmembers.length % 2 != 0) {
            throw new SyntaxErrorException();
        }
        IRedisSortedSet.ZsetPair pair = new IRedisSortedSet.ZsetPair(score, member);
        IRedisSortedSet.ZsetPair[] pairs = new IRedisSortedSet.ZsetPair[scoresmembers.length / 2];
        int pidx = 0;
        for (int idx = 0; idx < scoresmembers.length; ++idx) {
            if (idx % 2 != 0) continue;
            if (scoresmembers[idx] instanceof Number) {
                scoresmembers[idx] = ((Number)scoresmembers[idx]).doubleValue();
            }
            if (!(scoresmembers[idx] instanceof Double)) {
                throw new NotFloatException();
            }
            if (!(scoresmembers[idx + 1] instanceof String)) {
                scoresmembers[idx + 1] = scoresmembers[idx + 1].toString();
            }
            pairs[pidx] = new IRedisSortedSet.ZsetPair((Double)scoresmembers[idx], (String)scoresmembers[idx + 1]);
            ++pidx;
        }
        return this.zadd(key, pair, pairs);
    }

    @Override
    public synchronized Long zcard(String key) throws WrongTypeException {
        this.checkType(key, "zset");
        if (!this.zsetCache.exists(key).booleanValue()) {
            return 0L;
        }
        return this.zsetCache.get(key).size();
    }

    @Override
    public synchronized Long zcount(String key, double min, double max) throws WrongTypeException {
        this.checkType(key, "zset");
        if (!this.zsetCache.exists(key).booleanValue()) {
            return 0L;
        }
        Long count = 0L;
        Iterator iterator = this.zsetCache.get(key).iterator();
        while (iterator.hasNext()) {
            String member = (String)iterator.next();
            Double score = this.zsetCache.getScore(key, member);
            if (!(min <= score) || !(score <= max)) continue;
            count = count + 1L;
        }
        return count;
    }

    @Override
    public synchronized String zincrby(String key, double increment, String member) throws WrongTypeException {
        this.checkType(key, "zset");
        if (!this.zsetCache.existsValue(key, member).booleanValue()) {
            this.zsetCache.set(key, member, new Object[]{0.0});
        }
        Double score = this.zsetCache.getScore(key, member);
        Double newScore = score + increment;
        this.zsetCache.set(key, member, new Object[]{newScore});
        return String.valueOf(newScore);
    }

    @Override
    public synchronized Long zinterstore(String destination, int numkeys, String ... options) throws WrongTypeException, SyntaxErrorException {
        int i;
        if (this.exists(destination).booleanValue()) {
            this.del(destination);
        }
        ArrayList<String> keys = new ArrayList<String>(numkeys);
        HashMap weights = new HashMap();
        String aggregate = "sum";
        if (options.length < numkeys) {
            throw new SyntaxErrorException();
        }
        for (i = 0; i < numkeys; ++i) {
            this.checkType(options[i], "zset");
            keys.add(options[i]);
        }
        i = numkeys;
        while (i < options.length) {
            if (options[i] == null) continue;
            if ("weights".equals(options[i].toLowerCase())) {
                if (i + 1 >= options.length) {
                    throw new SyntaxErrorException();
                }
                int ki = 0;
                ++i;
                while (i < options.length && !"aggregate".equals(options[i])) {
                    weights.put(keys.get(ki), Double.valueOf(options[i]));
                    ++ki;
                    ++i;
                }
                continue;
            }
            if ("aggregate".equals(options[i].toLowerCase())) {
                if (i + 1 >= options.length) {
                    throw new SyntaxErrorException();
                }
                aggregate = options[i + 1];
                i += 2;
                continue;
            }
            throw new SyntaxErrorException();
        }
        String key = (String)keys.get(0);
        Set<IRedisSortedSet.ZsetPair> range = this.zrange(key, 0L, -1L, "withscores");
        for (IRedisSortedSet.ZsetPair pair : range) {
            if (!weights.containsKey(key)) continue;
            IRedisSortedSet.ZsetPair zsetPair = pair;
            Double.valueOf(zsetPair.score * (Double)weights.get(key));
            zsetPair.score = zsetPair.score;
        }
        for (String k : keys.subList(1, numkeys)) {
            HashSet<IRedisSortedSet.ZsetPair> inter = new HashSet<IRedisSortedSet.ZsetPair>();
            for (IRedisSortedSet.ZsetPair pair : range) {
                if (!this.zsetCache.existsValue(k, pair.member).booleanValue()) continue;
                Double score = this.zsetCache.getScore(k, pair.member);
                if (weights.containsKey(k)) {
                    score = score * (Double)weights.get(k);
                }
                if ("min".equals(aggregate)) {
                    pair.score = Math.min(pair.score, score);
                } else if ("max".equals(aggregate)) {
                    pair.score = Math.max(pair.score, score);
                } else {
                    IRedisSortedSet.ZsetPair zsetPair = pair;
                    Double.valueOf(zsetPair.score + score);
                    zsetPair.score = zsetPair.score;
                }
                inter.add(pair);
            }
            range = inter;
        }
        Long count = 0L;
        for (IRedisSortedSet.ZsetPair pair : range) {
            this.zadd(destination, pair, new IRedisSortedSet.ZsetPair[0]);
            count = count + 1L;
        }
        return count;
    }

    @Override
    public synchronized Long zlexcount(String key, String min, String max) throws WrongTypeException, NotValidStringRangeItemException {
        return this.zrangebylex(key, min, max, new String[0]).size();
    }

    @Override
    public synchronized Set<IRedisSortedSet.ZsetPair> zrange(String key, long start, long stop, String ... options) throws WrongTypeException {
        this.checkType(key, "zset");
        boolean withscores = false;
        long card = this.zcard(key);
        if (start < 0L) {
            start = Math.max(card + start, 0L);
        }
        if (stop < 0L) {
            stop = card + stop;
        }
        TreeSet<IRedisSortedSet.ZsetPair> range = new TreeSet<IRedisSortedSet.ZsetPair>(IRedisSortedSet.ZsetPair.comparator());
        if (!this.zsetCache.exists(key).booleanValue()) {
            return range;
        }
        if (options.length > 0 && options[0] != null && "withscores".equals(options[0].toLowerCase())) {
            withscores = true;
        }
        int count = 0;
        Iterator iterator = this.zsetCache.get(key).iterator();
        while (iterator.hasNext()) {
            String member = (String)iterator.next();
            if (start > (long)count) {
                ++count;
                continue;
            }
            if (stop < (long)count) break;
            IRedisSortedSet.ZsetPair pair = new IRedisSortedSet.ZsetPair(member);
            if (withscores) {
                pair.score = this.zsetCache.getScore(key, member);
            }
            range.add(pair);
            ++count;
        }
        return range;
    }

    @Override
    public synchronized Set<IRedisSortedSet.ZsetPair> zrangebylex(String key, String min, String max, String ... options) throws WrongTypeException, NotValidStringRangeItemException {
        boolean maxAll;
        this.checkType(key, "zset");
        if (min.charAt(0) != '(' && min.charAt(0) != '[' && min.charAt(0) != '-' && min.charAt(0) != '+') {
            throw new NotValidStringRangeItemException();
        }
        if (max.charAt(0) != '(' && max.charAt(0) != '[' && max.charAt(0) != '-' && max.charAt(0) != '+') {
            throw new NotValidStringRangeItemException();
        }
        TreeSet<IRedisSortedSet.ZsetPair> range = new TreeSet<IRedisSortedSet.ZsetPair>(IRedisSortedSet.ZsetPair.comparator());
        if (!this.zsetCache.exists(key).booleanValue()) {
            return range;
        }
        String minStr = min.substring(1);
        String maxStr = max.substring(1);
        boolean minInclusive = min.charAt(0) == '[';
        boolean maxInclusive = max.charAt(0) == '[';
        boolean bl = maxAll = max.charAt(0) == '+';
        if (min.charAt(0) == '+') {
            return range;
        }
        if (max.charAt(0) == '-') {
            return range;
        }
        Object members = this.zsetCache.get(key);
        Iterator iterator = members.iterator();
        while (iterator.hasNext()) {
            String member = (String)iterator.next();
            if (member == null) continue;
            int minc = member.compareTo(minStr);
            int maxc = member.compareTo(maxStr);
            if (minc > 0 && (maxc < 0 || maxAll)) {
                range.add(new IRedisSortedSet.ZsetPair(member));
                continue;
            }
            if (minc == 0 && minInclusive) {
                range.add(new IRedisSortedSet.ZsetPair(member));
                continue;
            }
            if (maxc != 0 || !maxInclusive) continue;
            range.add(new IRedisSortedSet.ZsetPair(member));
        }
        return range;
    }

    @Override
    public synchronized Set<IRedisSortedSet.ZsetPair> zrevrangebylex(String key, String max, String min, String ... options) throws WrongTypeException, NotValidStringRangeItemException {
        Set<IRedisSortedSet.ZsetPair> range = this.zrangebylex(key, min, max, options);
        TreeSet<IRedisSortedSet.ZsetPair> revrange = new TreeSet<IRedisSortedSet.ZsetPair>(IRedisSortedSet.ZsetPair.descendingComparator());
        revrange.addAll(range);
        return revrange;
    }

    @Override
    public synchronized Set<IRedisSortedSet.ZsetPair> zrangebyscore(String key, String min, String max, String ... options) throws WrongTypeException, NotFloatMinMaxException, NotIntegerException, SyntaxErrorException {
        Double minf = null;
        Double maxf = null;
        boolean minInclusive = true;
        boolean maxInclusive = true;
        this.checkType(key, "zset");
        if ("-inf".equals(min)) {
            minf = Double.MIN_VALUE;
        }
        if ("+inf".equals(min)) {
            minf = Double.MAX_VALUE;
        }
        if ("-inf".equals(max)) {
            maxf = Double.MIN_VALUE;
        }
        if ("+inf".equals(max)) {
            maxf = Double.MAX_VALUE;
        }
        if (min.charAt(0) == '(') {
            minInclusive = false;
            min = min.substring(1);
        }
        if (max.charAt(0) == '(') {
            maxInclusive = false;
            max = max.substring(1);
        }
        if (minf == null) {
            try {
                minf = Double.parseDouble(min);
            }
            catch (NumberFormatException e) {
                throw new NotFloatMinMaxException();
            }
        }
        if (maxf == null) {
            try {
                maxf = Double.parseDouble(max);
            }
            catch (NumberFormatException e) {
                throw new NotFloatMinMaxException();
            }
        }
        boolean withscores = false;
        long limitOffset = -1L;
        long limitCount = -1L;
        for (int idx = 0; idx < options.length; ++idx) {
            String option = options[idx];
            if (option == null) continue;
            if ("withscores".equals(option.toLowerCase())) {
                withscores = true;
            }
            if (!"limit".equals(option.toLowerCase())) continue;
            if (options.length <= idx + 2) {
                throw new SyntaxErrorException();
            }
            try {
                limitOffset = Long.parseLong(options[idx + 1]);
                limitCount = Long.parseLong(options[idx + 2]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new NotIntegerException();
            }
        }
        TreeSet<IRedisSortedSet.ZsetPair> range = new TreeSet<IRedisSortedSet.ZsetPair>(IRedisSortedSet.ZsetPair.comparator());
        if (!this.zsetCache.exists(key).booleanValue()) {
            return range;
        }
        Object members = this.zsetCache.get(key);
        long offset = 0L;
        Iterator iterator = members.iterator();
        while (iterator.hasNext()) {
            String member = (String)iterator.next();
            if (member == null) continue;
            Double score = this.zsetCache.getScore(key, member);
            if ((minInclusive && minf <= score || !minInclusive && minf < score) && (maxInclusive && score <= maxf || !maxInclusive && score < maxf)) {
                if (limitOffset != -1L && offset >= limitOffset) {
                    if (limitCount != -1L) {
                        if ((long)range.size() >= limitCount) break;
                        if (withscores) {
                            range.add(new IRedisSortedSet.ZsetPair(member, score));
                        } else {
                            range.add(new IRedisSortedSet.ZsetPair(member));
                        }
                    }
                } else if (limitOffset == -1L) {
                    if (withscores) {
                        range.add(new IRedisSortedSet.ZsetPair(member, score));
                    } else {
                        range.add(new IRedisSortedSet.ZsetPair(member));
                    }
                }
            }
            ++offset;
        }
        return range;
    }

    @Override
    public synchronized Long zrank(String key, String member) throws WrongTypeException {
        String m;
        this.checkType(key, "zset");
        if (!this.zsetCache.exists(key).booleanValue()) {
            return null;
        }
        if (this.zsetCache.getScore(key, member) == null) {
            return null;
        }
        Object members = this.zsetCache.get(key);
        long rank = 0L;
        Iterator iterator = members.iterator();
        while (iterator.hasNext() && !(m = (String)iterator.next()).equals(member)) {
            ++rank;
        }
        return rank;
    }

    @Override
    public synchronized Long zrem(String key, String member, String ... members) throws WrongTypeException {
        this.checkType(key, "zset");
        Long count = 0L;
        count = count + (this.zsetCache.removeValue(key, member) != false ? 1L : 0L);
        for (String m : members) {
            count = count + (this.zsetCache.removeValue(key, m) != false ? 1L : 0L);
        }
        if (this.zcard(key) == 0L) {
            this.del(key);
        }
        return count;
    }

    @Override
    public synchronized Long zremrangebylex(String key, String min, String max) throws WrongTypeException, NotValidStringRangeItemException {
        Set<IRedisSortedSet.ZsetPair> range = this.zrangebylex(key, min, max, new String[0]);
        for (IRedisSortedSet.ZsetPair pair : range) {
            this.zrem(key, pair.member, new String[0]);
        }
        return range.size();
    }

    @Override
    public synchronized Long zremrangebyrank(String key, long min, long max) throws WrongTypeException {
        this.checkType(key, "zset");
        Object members = this.zsetCache.get(key);
        HashSet<String> toRem = new HashSet<String>();
        long card = this.zcard(key);
        if (min < 0L) {
            min = card + min;
        }
        if (max < 0L) {
            max = card + max;
        }
        long count = 0L;
        Iterator iterator = members.iterator();
        while (iterator.hasNext()) {
            String member = (String)iterator.next();
            if (min <= count && count <= max) {
                toRem.add(member);
            }
            if (count > max) break;
            ++count;
        }
        for (String rem : toRem) {
            this.zrem(key, rem, new String[0]);
        }
        return toRem.size();
    }

    @Override
    public synchronized Long zremrangebyscore(String key, String min, String max) throws WrongTypeException, NotFloatMinMaxException {
        try {
            Set<IRedisSortedSet.ZsetPair> range = this.zrangebyscore(key, min, max, new String[0]);
            for (IRedisSortedSet.ZsetPair pair : range) {
                this.zrem(key, pair.member, new String[0]);
            }
            return range.size();
        }
        catch (WrongTypeException e) {
            throw e;
        }
        catch (NotFloatMinMaxException e) {
            throw e;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public synchronized Set<IRedisSortedSet.ZsetPair> zrevrange(String key, long start, long stop, String ... options) throws WrongTypeException {
        Set<IRedisSortedSet.ZsetPair> range = this.zrange(key, start, stop, options);
        TreeSet<IRedisSortedSet.ZsetPair> revRange = new TreeSet<IRedisSortedSet.ZsetPair>(IRedisSortedSet.ZsetPair.descendingComparator());
        revRange.addAll(range);
        return revRange;
    }

    @Override
    public synchronized Set<IRedisSortedSet.ZsetPair> zrevrangebyscore(String key, String max, String min, String ... options) throws WrongTypeException, NotFloatMinMaxException, NotIntegerException, SyntaxErrorException {
        Set<IRedisSortedSet.ZsetPair> range = this.zrangebyscore(key, min, max, options);
        TreeSet<IRedisSortedSet.ZsetPair> revRange = new TreeSet<IRedisSortedSet.ZsetPair>(IRedisSortedSet.ZsetPair.descendingComparator());
        revRange.addAll(range);
        return revRange;
    }

    @Override
    public synchronized Long zrevrank(String key, String member) throws WrongTypeException {
        this.checkType(key, "zset");
        Long rank = this.zrank(key, member);
        if (rank == null) {
            return null;
        }
        return this.zcard(key) - rank - 1L;
    }

    @Override
    public synchronized Double zscore(String key, String member) throws WrongTypeException {
        this.checkType(key, "zset");
        return this.zsetCache.getScore(key, member);
    }

    @Override
    public synchronized Long zunionstore(String destination, int numkeys, String ... options) throws WrongTypeException, SyntaxErrorException {
        Object object;
        int i;
        if (this.exists(destination).booleanValue()) {
            this.del(destination);
        }
        ArrayList<String> keys = new ArrayList<String>(numkeys);
        HashMap weights = new HashMap();
        String aggregate = "sum";
        if (options.length < numkeys) {
            throw new SyntaxErrorException();
        }
        for (i = 0; i < numkeys; ++i) {
            this.checkType(options[i], "zset");
            keys.add(options[i]);
        }
        i = numkeys;
        while (i < options.length) {
            if (options[i] == null) continue;
            if ("weights".equals(options[i].toLowerCase())) {
                if (i + 1 >= options.length) {
                    throw new SyntaxErrorException();
                }
                int ki = 0;
                ++i;
                while (i < options.length && !"aggregate".equals(options[i])) {
                    weights.put(keys.get(ki), Double.valueOf(options[i]));
                    ++ki;
                    ++i;
                }
                continue;
            }
            if ("aggregate".equals(options[i].toLowerCase())) {
                if (i + 1 >= options.length) {
                    throw new SyntaxErrorException();
                }
                aggregate = options[i + 1];
                i += 2;
                continue;
            }
            throw new SyntaxErrorException();
        }
        String key = (String)keys.get(0);
        Set<IRedisSortedSet.ZsetPair> range = this.zrange(key, 0L, -1L, "withscores");
        HashMap<String, Double> rangeMap = new HashMap<String, Double>();
        for (IRedisSortedSet.ZsetPair pair : range) {
            if (weights.containsKey(key)) {
                object = pair;
                Double.valueOf(((IRedisSortedSet.ZsetPair)object).score * (Double)weights.get(key));
                ((IRedisSortedSet.ZsetPair)object).score = ((IRedisSortedSet.ZsetPair)object).score;
            }
            rangeMap.put(pair.member, pair.score);
        }
        for (String k : keys.subList(1, numkeys)) {
            object = this.zsetCache.get(k).iterator();
            while (object.hasNext()) {
                IRedisSortedSet.ZsetPair zsetPair;
                String m = (String)object.next();
                IRedisSortedSet.ZsetPair pair = new IRedisSortedSet.ZsetPair(m, this.zsetCache.getScore(k, m));
                Double score = (Double)rangeMap.get(m);
                if (weights.containsKey(k)) {
                    zsetPair = pair;
                    Double.valueOf(zsetPair.score * (Double)weights.get(k));
                    zsetPair.score = zsetPair.score;
                }
                if ("min".equals(aggregate)) {
                    if (score != null) {
                        pair.score = Math.min(pair.score, score);
                    }
                } else if ("max".equals(aggregate)) {
                    if (score != null) {
                        pair.score = Math.max(pair.score, score);
                    }
                } else if (score != null) {
                    zsetPair = pair;
                    Double.valueOf(zsetPair.score + score);
                    zsetPair.score = zsetPair.score;
                }
                rangeMap.put(pair.member, pair.score);
            }
        }
        Long count = 0L;
        for (String member : rangeMap.keySet()) {
            this.zadd(destination, new IRedisSortedSet.ZsetPair(member, (Double)rangeMap.get(member)), new IRedisSortedSet.ZsetPair[0]);
            count = count + 1L;
        }
        return count;
    }

    @Override
    public synchronized ScanResult<Set<IRedisSortedSet.ZsetPair>> zscan(String key, long cursor, String ... options) throws WrongTypeException {
        this.checkType(key, "zset");
        Long count = null;
        Pattern match = null;
        for (int idx = 0; idx < options.length; ++idx) {
            if (options[idx].equals("count")) {
                count = Long.valueOf(options[idx + 1]);
                continue;
            }
            if (!options[idx].equals("match")) continue;
            match = Pattern.compile(GlobToRegEx.convertGlobToRegEx(options[idx + 1]));
        }
        if (count == null) {
            count = 10L;
        }
        TreeSet<IRedisSortedSet.ZsetPair> scanned = new TreeSet<IRedisSortedSet.ZsetPair>(IRedisSortedSet.ZsetPair.comparator());
        Set<IRedisSortedSet.ZsetPair> members = this.zrange(key, 0L, -1L, "withscores");
        Long idx = 0L;
        for (IRedisSortedSet.ZsetPair pair : members) {
            if ((idx = Long.valueOf(idx + 1L)) <= cursor) continue;
            if (match == null || match.matcher(pair.member).matches()) {
                scanned.add(pair);
            }
            if ((long)scanned.size() < count) continue;
            break;
        }
        if (idx >= this.zcard(key)) {
            idx = 0L;
        }
        return new ScanResult<Set<IRedisSortedSet.ZsetPair>>(idx, scanned);
    }

    private final class WatchKey {
        public Boolean modified = false;
        public List<Integer> watchers = new ArrayList<Integer>();
    }
}

