/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis.adapter.jedis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rarefiedredis.redis.AbstractRedisClient;
import org.rarefiedredis.redis.ArgException;
import org.rarefiedredis.redis.BitArgException;
import org.rarefiedredis.redis.DiscardWithoutMultiException;
import org.rarefiedredis.redis.ExecWithoutMultiException;
import org.rarefiedredis.redis.IRedisSortedSet;
import org.rarefiedredis.redis.IndexOutOfRangeException;
import org.rarefiedredis.redis.NoKeyException;
import org.rarefiedredis.redis.NotFloatException;
import org.rarefiedredis.redis.NotFloatHashException;
import org.rarefiedredis.redis.NotFloatMinMaxException;
import org.rarefiedredis.redis.NotIntegerException;
import org.rarefiedredis.redis.NotIntegerHashException;
import org.rarefiedredis.redis.NotValidStringRangeItemException;
import org.rarefiedredis.redis.ScanResult;
import org.rarefiedredis.redis.SyntaxErrorException;
import org.rarefiedredis.redis.WrongTypeException;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJedisIRedisClient
extends AbstractRedisClient {
    public abstract Object command(String var1, Object ... var2);

    @Override
    public Long del(String ... keys) {
        return (Long)this.command("del", new Object[]{keys});
    }

    @Override
    public String dump(String key) {
        return (String)this.command("dump", key);
    }

    @Override
    public Boolean exists(String key) {
        return (Boolean)this.command("exists", key);
    }

    @Override
    public Boolean expire(String key, int seconds) {
        Object ret = this.command("expire", key, seconds);
        if (ret == null) {
            return null;
        }
        return (Long)ret == 1L;
    }

    @Override
    public Boolean expireat(String key, long timestamp) {
        Object ret = this.command("expireat", key, timestamp);
        if (ret == null) {
            return null;
        }
        return (Long)ret == 1L;
    }

    @Override
    public Long move(String key, int db) {
        return (Long)this.command("move", key, db);
    }

    @Override
    public Boolean persist(String key) {
        Object ret = this.command("persist", key);
        if (ret == null) {
            return null;
        }
        return (Long)ret == 1L;
    }

    @Override
    public Boolean pexpire(String key, long milliseconds) {
        Object ret = this.command("pexpire", key, milliseconds);
        if (ret == null) {
            return null;
        }
        return (Long)ret == 1L;
    }

    @Override
    public Boolean pexpireat(String key, long timestamp) {
        Object ret = this.command("pexpireAt", key, timestamp);
        if (ret == null) {
            return null;
        }
        return (Long)ret == 1L;
    }

    @Override
    public Long pttl(String key) {
        return (Long)this.command("pttl", key);
    }

    @Override
    public String randomkey() {
        return (String)this.command("randomkey", new Object[0]);
    }

    @Override
    public String rename(String key, String newkey) {
        return (String)this.command("rename", key, newkey);
    }

    @Override
    public Boolean renamenx(String key, String newkey) {
        Object ret = this.command("renamenx", key, newkey);
        if (ret == null) {
            return null;
        }
        return (Long)ret == 1L;
    }

    @Override
    public String restore(String key, int ttl, String serialized_value) {
        return (String)this.command("restore", key, ttl, serialized_value.getBytes());
    }

    @Override
    public Long ttl(String key) {
        return (Long)this.command("ttl", key);
    }

    @Override
    public String type(String key) {
        return (String)this.command("type", key);
    }

    @Override
    public Long append(String key, String value) throws WrongTypeException {
        Object ret = this.command("append", key, value);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long bitcount(String key, long ... options) throws WrongTypeException {
        if (options.length > 0) {
            long start = options[0];
            long end = options.length == 1 ? -1L : options[1];
            Object ret = this.command("bitcount", key, start, end);
            if (ret instanceof WrongTypeException) {
                throw (WrongTypeException)ret;
            }
            return (Long)ret;
        }
        Object ret = this.command("bitcount", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long bitop(String operation, String destkey, String ... keys) throws WrongTypeException {
        BitOP op = null;
        if (operation.toLowerCase().equals("and")) {
            op = BitOP.AND;
        } else if (operation.toLowerCase().equals("or")) {
            op = BitOP.OR;
        } else if (operation.toLowerCase().equals("xor")) {
            op = BitOP.XOR;
        } else if (operation.toLowerCase().equals("not")) {
            op = BitOP.NOT;
        }
        Object ret = this.command("bitop", op, destkey, keys);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long bitpos(String key, long bit, long ... options) throws WrongTypeException, BitArgException {
        boolean value;
        Object ret;
        if (bit != 0L && bit != 1L) {
            throw new BitArgException();
        }
        BitPosParams params = null;
        if (options.length > 0) {
            params = options.length > 1 ? new BitPosParams(options[0], options[1]) : new BitPosParams(options[0]);
        }
        if ((ret = this.command("bitpos", key, value = bit == 1L, params)) instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long decr(String key) throws WrongTypeException, NotIntegerException {
        Object ret = this.command("decr", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotIntegerException) {
            throw (NotIntegerException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long decrby(String key, long decrement) throws WrongTypeException, NotIntegerException {
        Object ret = this.command("decrBy", key, decrement);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotIntegerException) {
            throw (NotIntegerException)ret;
        }
        return (Long)ret;
    }

    @Override
    public String get(String key) throws WrongTypeException {
        Object ret = this.command("get", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (String)ret;
    }

    @Override
    public Boolean getbit(String key, long offset) throws WrongTypeException {
        Object ret = this.command("getbit", key, offset);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Boolean)ret;
    }

    @Override
    public String getrange(String key, long start, long end) throws WrongTypeException {
        Object ret = this.command("getrange", key, start, end);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (String)ret;
    }

    @Override
    public String getset(String key, String value) throws WrongTypeException {
        Object ret = this.command("getSet", key, value);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (String)ret;
    }

    @Override
    public Long incr(String key) throws WrongTypeException, NotIntegerException {
        Object ret = this.command("incr", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotIntegerException) {
            throw (NotIntegerException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long incrby(String key, long increment) throws WrongTypeException, NotIntegerException {
        Object ret = this.command("incrBy", key, increment);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotIntegerException) {
            throw (NotIntegerException)ret;
        }
        return (Long)ret;
    }

    @Override
    public String incrbyfloat(String key, double increment) throws WrongTypeException, NotFloatException {
        Object ret = this.command("incrByFloat", key, increment);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotFloatException) {
            throw (NotFloatException)ret;
        }
        return String.valueOf((Double)ret);
    }

    @Override
    public String[] mget(String ... keys) {
        List jret = (List)this.command("mget", new Object[]{keys});
        return jret.toArray(new String[0]);
    }

    @Override
    public String mset(String ... keysvalues) throws ArgException {
        Object ret = this.command("mset", new Object[]{keysvalues});
        if (ret instanceof ArgException) {
            throw (ArgException)ret;
        }
        return (String)ret;
    }

    @Override
    public Boolean msetnx(String ... keysvalues) throws ArgException {
        Object ret = this.command("msetnx", new Object[]{keysvalues});
        if (ret instanceof ArgException) {
            throw (ArgException)ret;
        }
        return (Long)ret == 1L;
    }

    @Override
    public String psetex(String key, long milliseconds, String value) {
        return (String)this.command("psetex", key, milliseconds, value);
    }

    @Override
    public String set(String key, String value, String ... options) {
        if (options.length == 0) {
            return (String)this.command("set", key, value);
        }
        String nxxx = null;
        String expx = null;
        long time = -1L;
        for (int idx = 0; idx < options.length; ++idx) {
            if (options[idx] == "nx") {
                nxxx = "nx";
                continue;
            }
            if (options[idx] == "xx") {
                nxxx = "xx";
                continue;
            }
            if (options[idx] == "ex") {
                expx = "ex";
                time = Long.valueOf(options[idx + 1]);
                continue;
            }
            if (options[idx] != "px") continue;
            expx = "px";
            time = Long.valueOf(options[idx + 1]);
        }
        if (nxxx != null && expx == null) {
            return (String)this.command("set", key, value, nxxx);
        }
        if (nxxx == null && expx != null) {
            if (expx.equals("ex")) {
                return this.setex(key, (int)time, value);
            }
            if (expx.equals("px")) {
                return this.psetex(key, time, value);
            }
        }
        return (String)this.command("set", key, value, nxxx, expx, time);
    }

    @Override
    public String setex(String key, int seconds, String value) {
        return (String)this.command("setex", key, seconds, value);
    }

    @Override
    public Long setnx(String key, String value) {
        return (Long)this.command("setnx", key, value);
    }

    @Override
    public Long setrange(String key, long offset, String value) throws WrongTypeException {
        Object ret = this.command("setrange", key, offset, value);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long strlen(String key) throws WrongTypeException {
        Object ret = this.command("strlen", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public String lindex(String key, long index) throws WrongTypeException {
        Object ret = this.command("lindex", key, index);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (String)ret;
    }

    @Override
    public Long linsert(String key, String before_after, String pivot, String value) throws WrongTypeException {
        Object ret;
        BinaryClient.LIST_POSITION lpos = null;
        if (before_after.toLowerCase().equals("before")) {
            lpos = BinaryClient.LIST_POSITION.BEFORE;
        }
        if (before_after.toLowerCase().equals("after")) {
            lpos = BinaryClient.LIST_POSITION.AFTER;
        }
        if ((ret = this.command("linsert", key, lpos, pivot, value)) instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long llen(String key) throws WrongTypeException {
        Object ret = this.command("llen", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public String lpop(String key) throws WrongTypeException {
        Object ret = this.command("lpop", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (String)ret;
    }

    @Override
    public Long lpush(String key, String element, String ... elements) throws WrongTypeException {
        String[] strings = new String[1 + elements.length];
        strings[0] = element;
        for (int idx = 0; idx < elements.length; ++idx) {
            strings[idx + 1] = elements[idx];
        }
        Object ret = this.command("lpush", key, strings);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long lpushx(String key, String element) throws WrongTypeException {
        Object ret = this.command("lpushx", key, new String[]{element});
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public List<String> lrange(String key, long start, long end) throws WrongTypeException {
        Object ret = this.command("lrange", key, start, end);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (List)ret;
    }

    @Override
    public Long lrem(String key, long count, String element) throws WrongTypeException {
        Object ret = this.command("lrem", key, count, element);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public String lset(String key, long index, String element) throws WrongTypeException, NoKeyException, IndexOutOfRangeException {
        Object ret = this.command("lset", key, index, element);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NoKeyException) {
            throw (NoKeyException)ret;
        }
        if (ret instanceof IndexOutOfRangeException) {
            throw (IndexOutOfRangeException)ret;
        }
        return (String)ret;
    }

    @Override
    public String ltrim(String key, long start, long end) throws WrongTypeException {
        Object ret = this.command("ltrim", key, start, end);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (String)ret;
    }

    @Override
    public String rpop(String key) throws WrongTypeException {
        Object ret = this.command("rpop", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (String)ret;
    }

    @Override
    public String rpoplpush(String source, String dest) throws WrongTypeException {
        Object ret = this.command("rpoplpush", source, dest);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (String)ret;
    }

    @Override
    public Long rpush(String key, String element, String ... elements) throws WrongTypeException {
        String[] strings = new String[1 + elements.length];
        strings[0] = element;
        for (int idx = 0; idx < elements.length; ++idx) {
            strings[idx + 1] = elements[idx];
        }
        Object ret = this.command("rpush", key, strings);
        if (ret == null) {
            return null;
        }
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long rpushx(String key, String element) throws WrongTypeException {
        Object ret = this.command("rpushx", key, new String[]{element});
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long sadd(String key, String member, String ... members) throws WrongTypeException {
        String[] ms = new String[1 + members.length];
        ms[0] = member;
        for (int idx = 0; idx < members.length; ++idx) {
            ms[idx + 1] = members[idx];
        }
        Object ret = this.command("sadd", key, ms);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long scard(String key) throws WrongTypeException {
        Object ret = this.command("scard", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Set<String> sdiff(String key, String ... keys) throws WrongTypeException {
        String[] ks = new String[1 + keys.length];
        ks[0] = key;
        for (int idx = 0; idx < keys.length; ++idx) {
            ks[idx + 1] = keys[idx];
        }
        Object ret = this.command("sdiff", new Object[]{ks});
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Set)ret;
    }

    @Override
    public Long sdiffstore(String destination, String key, String ... keys) throws WrongTypeException {
        String[] ks = new String[1 + keys.length];
        ks[0] = key;
        for (int idx = 0; idx < keys.length; ++idx) {
            ks[idx + 1] = keys[idx];
        }
        Object ret = this.command("sdiffstore", destination, ks);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Set<String> sinter(String key, String ... keys) throws WrongTypeException {
        String[] ks = new String[1 + keys.length];
        ks[0] = key;
        for (int idx = 0; idx < keys.length; ++idx) {
            ks[idx + 1] = keys[idx];
        }
        Object ret = this.command("sinter", new Object[]{ks});
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Set)ret;
    }

    @Override
    public Long sinterstore(String destination, String key, String ... keys) throws WrongTypeException {
        String[] ks = new String[1 + keys.length];
        ks[0] = key;
        for (int idx = 0; idx < keys.length; ++idx) {
            ks[idx + 1] = keys[idx];
        }
        Object ret = this.command("sinterstore", destination, ks);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Boolean sismember(String key, String member) throws WrongTypeException {
        Object ret = this.command("sismember", key, member);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Boolean)ret;
    }

    @Override
    public Set<String> smembers(String key) throws WrongTypeException {
        Object ret = this.command("smembers", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Set)ret;
    }

    @Override
    public Boolean smove(String source, String dest, String member) throws WrongTypeException {
        Object ret = this.command("smove", source, dest, member);
        if (ret == null) {
            return null;
        }
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret == 1L;
    }

    @Override
    public String spop(String key) throws WrongTypeException {
        Object ret = this.command("spop", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (String)ret;
    }

    @Override
    public String srandmember(String key) throws WrongTypeException {
        Object ret = this.command("srandmember", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (String)ret;
    }

    @Override
    public List<String> srandmember(String key, long count) throws WrongTypeException {
        Object ret = this.command("srandmember", key, (int)count);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (List)ret;
    }

    @Override
    public Long srem(String key, String member, String ... members) throws WrongTypeException {
        String[] ms = new String[1 + members.length];
        ms[0] = member;
        for (int idx = 0; idx < members.length; ++idx) {
            ms[idx + 1] = members[idx];
        }
        Object ret = this.command("srem", key, ms);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Set<String> sunion(String key, String ... keys) throws WrongTypeException {
        String[] ks = new String[1 + keys.length];
        ks[0] = key;
        for (int idx = 0; idx < keys.length; ++idx) {
            ks[idx + 1] = keys[idx];
        }
        Object ret = this.command("sunion", new Object[]{ks});
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Set)ret;
    }

    @Override
    public Long sunionstore(String destination, String key, String ... keys) throws WrongTypeException {
        String[] ks = new String[1 + keys.length];
        ks[0] = key;
        for (int idx = 0; idx < keys.length; ++idx) {
            ks[idx + 1] = keys[idx];
        }
        Object ret = this.command("sunionstore", destination, ks);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public ScanResult<Set<String>> sscan(String key, long cursor, String ... options) throws WrongTypeException {
        Object ret = null;
        if (options.length == 0) {
            ret = this.command("sscan", key, String.valueOf(cursor));
        } else {
            ScanParams params = new ScanParams();
            for (int idx = 0; idx < options.length; ++idx) {
                if (options[idx].equals("count")) {
                    params.count(Integer.valueOf(options[idx + 1]).intValue());
                    continue;
                }
                if (!options[idx].equals("match")) continue;
                params.match(options[idx + 1]);
            }
            ret = this.command("sscan", key, String.valueOf(cursor), params);
        }
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        redis.clients.jedis.ScanResult scanResult = (redis.clients.jedis.ScanResult)ret;
        HashSet results = new HashSet(scanResult.getResult());
        return new ScanResult<Set<String>>(Long.valueOf(scanResult.getCursor()), results);
    }

    @Override
    public Long hdel(String key, String field, String ... fields) throws WrongTypeException {
        String[] fs = new String[1 + fields.length];
        fs[0] = field;
        for (int idx = 0; idx < fields.length; ++idx) {
            fs[idx + 1] = fields[idx];
        }
        Object ret = this.command("hdel", key, fs);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Boolean hexists(String key, String field) throws WrongTypeException {
        Object ret = this.command("hexists", key, field);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Boolean)ret;
    }

    @Override
    public String hget(String key, String field) throws WrongTypeException {
        Object ret = this.command("hget", key, field);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (String)ret;
    }

    @Override
    public Map<String, String> hgetall(String key) throws WrongTypeException {
        Object ret = this.command("hgetAll", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Map)ret;
    }

    @Override
    public Long hincrby(String key, String field, long increment) throws WrongTypeException, NotIntegerHashException {
        Object ret = this.command("hincrBy", key, field, increment);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotIntegerHashException) {
            throw (NotIntegerHashException)ret;
        }
        return (Long)ret;
    }

    @Override
    public String hincrbyfloat(String key, String field, double increment) throws WrongTypeException, NotFloatHashException {
        Object ret = this.command("hincrByFloat", key, field, increment);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotFloatHashException) {
            throw (NotFloatHashException)ret;
        }
        return String.valueOf((Double)ret);
    }

    @Override
    public Set<String> hkeys(String key) throws WrongTypeException {
        Object ret = this.command("hkeys", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Set)ret;
    }

    @Override
    public Long hlen(String key) throws WrongTypeException {
        Object ret = this.command("hlen", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public List<String> hmget(String key, String field, String ... fields) throws WrongTypeException {
        String[] fs = new String[1 + fields.length];
        fs[0] = field;
        for (int idx = 0; idx < fields.length; ++idx) {
            fs[idx + 1] = fields[idx];
        }
        Object ret = this.command("hmget", key, fs);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (List)ret;
    }

    @Override
    public String hmset(String key, String field, String value, String ... fieldsvalues) throws WrongTypeException, ArgException {
        if (fieldsvalues.length % 2 != 0) {
            throw new ArgException("HMSET");
        }
        HashMap<String, String> hash = new HashMap<String, String>();
        hash.put(field, value);
        for (int idx = 0; idx < fieldsvalues.length; ++idx) {
            if (idx % 2 != 0) continue;
            hash.put(fieldsvalues[idx], fieldsvalues[idx + 1]);
        }
        Object ret = this.command("hmset", key, hash);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (String)ret;
    }

    @Override
    public Boolean hset(String key, String field, String value) throws WrongTypeException {
        Object ret = this.command("hset", key, field, value);
        if (ret == null) {
            return null;
        }
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret == 1L;
    }

    @Override
    public Boolean hsetnx(String key, String field, String value) throws WrongTypeException {
        Object ret = this.command("hsetnx", key, field, value);
        if (ret == null) {
            return null;
        }
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret == 1L;
    }

    @Override
    public Long hstrlen(String key, String field) throws WrongTypeException {
        Object ret = this.command("hstrlen", key, field);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public List<String> hvals(String key) throws WrongTypeException {
        Object ret = this.command("hvals", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (List)ret;
    }

    @Override
    public ScanResult<Map<String, String>> hscan(String key, long cursor, String ... options) throws WrongTypeException {
        Object ret = null;
        if (options.length == 0) {
            ret = this.command("hscan", key, String.valueOf(cursor));
        } else {
            ScanParams params = new ScanParams();
            for (int idx = 0; idx < options.length; ++idx) {
                if (options[idx].equals("count")) {
                    params.count(Integer.valueOf(options[idx + 1]).intValue());
                    continue;
                }
                if (!options[idx].equals("match")) continue;
                params.match(options[idx + 1]);
            }
            ret = this.command("hscan", key, String.valueOf(cursor), params);
        }
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        redis.clients.jedis.ScanResult scanResult = (redis.clients.jedis.ScanResult)ret;
        HashMap results = new HashMap();
        for (Map.Entry entry : scanResult.getResult()) {
            results.put(entry.getKey(), entry.getValue());
        }
        return new ScanResult<Map<String, String>>(Long.valueOf(scanResult.getCursor()), results);
    }

    @Override
    public String discard() throws DiscardWithoutMultiException {
        throw new DiscardWithoutMultiException();
    }

    @Override
    public List<Object> exec() throws ExecWithoutMultiException {
        throw new ExecWithoutMultiException();
    }

    @Override
    public String unwatch() {
        return (String)this.command("unwatch", new Object[0]);
    }

    @Override
    public Long zadd(String key, IRedisSortedSet.ZsetPair scoremember, IRedisSortedSet.ZsetPair ... scoresmembers) throws WrongTypeException {
        if (scoremember == null) {
            return null;
        }
        HashMap<String, Double> sms = new HashMap<String, Double>();
        sms.put(scoremember.member, scoremember.score);
        for (IRedisSortedSet.ZsetPair pair : scoresmembers) {
            if (pair == null) continue;
            sms.put(pair.member, pair.score);
        }
        Object ret = this.command("zadd", key, sms);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long zadd(String key, double score, String member, Object ... scoresmembers) throws WrongTypeException, SyntaxErrorException, NotFloatException {
        if (scoresmembers.length % 2 != 0) {
            throw new SyntaxErrorException();
        }
        HashMap<String, Double> sms = new HashMap<String, Double>();
        sms.put(member, score);
        for (int idx = 0; idx < scoresmembers.length; ++idx) {
            if (idx % 2 != 0) continue;
            if (scoresmembers[idx] instanceof Number) {
                scoresmembers[idx] = ((Number)scoresmembers[idx]).doubleValue();
            }
            if (!(scoresmembers[idx] instanceof Double)) {
                throw new NotFloatException();
            }
            if (!(scoresmembers[idx + 1] instanceof String)) {
                scoresmembers[idx + 1] = scoresmembers[idx + 1].toString();
            }
            sms.put((String)scoresmembers[idx + 1], (Double)scoresmembers[idx]);
        }
        Object ret = this.command("zadd", key, sms);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof SyntaxErrorException) {
            throw (SyntaxErrorException)ret;
        }
        if (ret instanceof NotFloatException) {
            throw (NotFloatException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long zcard(String key) throws WrongTypeException {
        Object ret = this.command("zcard", key);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long zcount(String key, double min, double max) throws WrongTypeException {
        Object ret = this.command("zcount", key, min, max);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public String zincrby(String key, double increment, String member) throws WrongTypeException {
        Object ret = this.command("zincrby", key, increment, member);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return String.valueOf((Double)ret);
    }

    @Override
    public Long zinterstore(String destination, int numkeys, String ... options) throws WrongTypeException, SyntaxErrorException {
        int i;
        if (options.length < numkeys) {
            throw new SyntaxErrorException();
        }
        String[] sets = new String[numkeys];
        for (i = 0; i < numkeys; ++i) {
            sets[i] = options[i];
        }
        i = numkeys;
        ZParams params = null;
        ArrayList<Double> weights = new ArrayList<Double>();
        String aggregate = null;
        while (i < options.length) {
            if (options[i] == null) continue;
            if ("weights".equals(options[i].toLowerCase())) {
                if (i + 1 >= options.length) {
                    throw new SyntaxErrorException();
                }
                if (params == null) {
                    params = new ZParams();
                }
                int ki = 0;
                ++i;
                while (i < options.length && !"aggregate".equals(options[i])) {
                    weights.add(Double.valueOf(options[i]));
                    ++ki;
                    ++i;
                }
                continue;
            }
            if ("aggregate".equals(options[i].toLowerCase())) {
                if (i + 1 >= options.length) {
                    throw new SyntaxErrorException();
                }
                aggregate = options[i + 1];
                i += 2;
                continue;
            }
            throw new SyntaxErrorException();
        }
        if (!weights.isEmpty()) {
            if (params == null) {
                params = new ZParams();
            }
            double[] weightsArr = new double[weights.size()];
            Double[] weightsToArr = weights.toArray(new Double[weights.size()]);
            for (int j = 0; j < weightsToArr.length; ++j) {
                weightsArr[j] = weightsToArr[j];
            }
            params = params.weightsByDouble(weightsArr);
        }
        if (aggregate != null) {
            if (params == null) {
                params = new ZParams();
            }
            params = "min".equals(aggregate) ? params.aggregate(ZParams.Aggregate.MIN) : ("max".equals(aggregate) ? params.aggregate(ZParams.Aggregate.MAX) : params.aggregate(ZParams.Aggregate.SUM));
        }
        Object ret = null;
        ret = params == null ? this.command("zinterstore", destination, sets) : this.command("zinterstore", destination, params, sets);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof SyntaxErrorException) {
            throw (SyntaxErrorException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long zlexcount(String key, String min, String max) throws WrongTypeException, NotValidStringRangeItemException {
        Object ret = this.command("zlexcount", key, min, max);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotValidStringRangeItemException) {
            throw (NotValidStringRangeItemException)ret;
        }
        return (Long)ret;
    }

    private Set<IRedisSortedSet.ZsetPair> toZsetPairSet(Set<String> range) {
        if (range == null) {
            return null;
        }
        LinkedHashSet<IRedisSortedSet.ZsetPair> zrange = new LinkedHashSet<IRedisSortedSet.ZsetPair>();
        for (String element : range) {
            zrange.add(new IRedisSortedSet.ZsetPair(element, null));
        }
        return zrange;
    }

    private Set<IRedisSortedSet.ZsetPair> toZsetPairSetFromTupleSet(Collection<Tuple> range) {
        if (range == null) {
            return null;
        }
        LinkedHashSet<IRedisSortedSet.ZsetPair> zrange = new LinkedHashSet<IRedisSortedSet.ZsetPair>();
        for (Tuple tuple : range) {
            zrange.add(new IRedisSortedSet.ZsetPair(tuple.getElement(), tuple.getScore()));
        }
        return zrange;
    }

    @Override
    public Set<IRedisSortedSet.ZsetPair> zrange(String key, long start, long stop, String ... options) throws WrongTypeException {
        boolean withscores = false;
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals("withscores")) continue;
            withscores = true;
        }
        Object ret = null;
        ret = withscores ? this.command("zrangeWithScores", key, start, stop) : this.command("zrange", key, start, stop);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (withscores) {
            return this.toZsetPairSetFromTupleSet((Set)ret);
        }
        return this.toZsetPairSet((Set)ret);
    }

    @Override
    public Set<IRedisSortedSet.ZsetPair> zrevrange(String key, long start, long stop, String ... options) throws WrongTypeException {
        boolean withscores = false;
        for (int i = 0; i < options.length; ++i) {
            if (!options[i].equals("withscores")) continue;
            withscores = true;
        }
        Object ret = null;
        ret = withscores ? this.command("zrevrangeWithScores", key, start, stop) : this.command("zrevrange", key, start, stop);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (withscores) {
            return this.toZsetPairSetFromTupleSet((Set)ret);
        }
        return this.toZsetPairSet((Set)ret);
    }

    @Override
    public Set<IRedisSortedSet.ZsetPair> zrangebylex(String key, String min, String max, String ... options) throws WrongTypeException, NotValidStringRangeItemException {
        Integer offset = null;
        Integer count = null;
        for (int i = 0; i < options.length; ++i) {
            if (options[i].equals(offset)) {
                try {
                    offset = Integer.valueOf(options[i + 1]);
                }
                catch (Exception e) {
                    offset = null;
                }
            }
            if (!options[i].equals(count)) continue;
            try {
                count = Integer.valueOf(options[i + 1]);
                continue;
            }
            catch (Exception e) {
                count = null;
            }
        }
        Object ret = null;
        ret = offset != null && count != null ? this.command("zrangeByLex", key, min, max, offset, count) : this.command("zrangeByLex", key, min, max);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotValidStringRangeItemException) {
            throw (NotValidStringRangeItemException)ret;
        }
        return this.toZsetPairSet((Set)ret);
    }

    @Override
    public Set<IRedisSortedSet.ZsetPair> zrevrangebylex(String key, String max, String min, String ... options) throws WrongTypeException, NotValidStringRangeItemException {
        Integer offset = null;
        Integer count = null;
        for (int i = 0; i < options.length; ++i) {
            if (options[i].equals(offset)) {
                try {
                    offset = Integer.valueOf(options[i + 1]);
                }
                catch (Exception e) {
                    offset = null;
                }
            }
            if (!options[i].equals(count)) continue;
            try {
                count = Integer.valueOf(options[i + 1]);
                continue;
            }
            catch (Exception e) {
                count = null;
            }
        }
        Object ret = null;
        ret = offset != null && count != null ? this.command("zrevrangeByLex", key, max, min, offset, count) : this.command("zrevrangeByLex", key, max, min);
        if (ret instanceof WrongTypeException) {
            throw new WrongTypeException();
        }
        if (ret instanceof NotValidStringRangeItemException) {
            throw new NotValidStringRangeItemException();
        }
        return this.toZsetPairSet((Set)ret);
    }

    @Override
    public Set<IRedisSortedSet.ZsetPair> zrangebyscore(String key, String min, String max, String ... options) throws WrongTypeException, NotFloatMinMaxException, NotIntegerException, SyntaxErrorException {
        boolean withscores = false;
        int limitOffset = -1;
        int limitCount = -1;
        for (int idx = 0; idx < options.length; ++idx) {
            String option = options[idx];
            if (option == null) continue;
            if ("withscores".equals(option.toLowerCase())) {
                withscores = true;
            }
            if (!"limit".equals(option.toLowerCase())) continue;
            if (options.length <= idx + 2) {
                throw new SyntaxErrorException();
            }
            try {
                limitOffset = Integer.parseInt(options[idx + 1]);
                limitCount = Integer.parseInt(options[idx + 2]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new NotIntegerException();
            }
        }
        Object ret = null;
        ret = withscores ? (limitOffset != -1 && limitCount != -1 ? this.command("zrangeByScoreWithScores", key, min, max, limitOffset, limitCount) : this.command("zrangeByScoreWithScores", key, min, max)) : (limitOffset != -1 && limitCount != -1 ? this.command("zrangeByScore", key, min, max, limitOffset, limitCount) : this.command("zrangeByScore", key, min, max));
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotFloatMinMaxException) {
            throw (NotFloatMinMaxException)ret;
        }
        if (ret instanceof NotIntegerException) {
            throw (NotIntegerException)ret;
        }
        if (ret instanceof SyntaxErrorException) {
            throw (SyntaxErrorException)ret;
        }
        if (withscores) {
            return this.toZsetPairSetFromTupleSet((Set)ret);
        }
        return this.toZsetPairSet((Set)ret);
    }

    @Override
    public Set<IRedisSortedSet.ZsetPair> zrevrangebyscore(String key, String max, String min, String ... options) throws WrongTypeException, NotFloatMinMaxException, NotIntegerException, SyntaxErrorException {
        boolean withscores = false;
        long limitOffset = -1L;
        long limitCount = -1L;
        for (int idx = 0; idx < options.length; ++idx) {
            String option = options[idx];
            if (option == null) continue;
            if ("withscores".equals(option.toLowerCase())) {
                withscores = true;
            }
            if (!"limit".equals(option.toLowerCase())) continue;
            if (options.length <= idx + 2) {
                throw new SyntaxErrorException();
            }
            try {
                limitOffset = Long.parseLong(options[idx + 1]);
                limitCount = Long.parseLong(options[idx + 2]);
                continue;
            }
            catch (NumberFormatException e) {
                throw new NotIntegerException();
            }
        }
        Object ret = null;
        ret = withscores ? (limitOffset != -1L && limitCount != -1L ? this.command("zrevrangeByScoreWithScores", key, max, min, limitOffset, limitCount) : this.command("zrevrangeByScoreWithScores", key, max, min)) : (limitOffset != -1L && limitCount != -1L ? this.command("zrevrangeByScore", key, max, min, limitOffset, limitCount) : this.command("zrevrangeByScore", key, max, min));
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotFloatMinMaxException) {
            throw (NotFloatMinMaxException)ret;
        }
        if (ret instanceof NotIntegerException) {
            throw (NotIntegerException)ret;
        }
        if (ret instanceof SyntaxErrorException) {
            throw (SyntaxErrorException)ret;
        }
        if (withscores) {
            return this.toZsetPairSetFromTupleSet((Set)ret);
        }
        return this.toZsetPairSet((Set)ret);
    }

    @Override
    public Long zrank(String key, String member) throws WrongTypeException {
        Object ret = this.command("zrank", key, member);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long zrem(String key, String member, String ... members) throws WrongTypeException {
        String[] ms = new String[1 + members.length];
        ms[0] = member;
        for (int idx = 0; idx < members.length; ++idx) {
            ms[idx + 1] = members[idx];
        }
        Object ret = this.command("zrem", key, ms);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long zremrangebylex(String key, String min, String max) throws WrongTypeException, NotValidStringRangeItemException {
        Object ret = this.command("zremrangeByLex", key, min, max);
        if (ret == null) {
            return null;
        }
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotValidStringRangeItemException) {
            throw (NotValidStringRangeItemException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long zremrangebyrank(String key, long start, long stop) throws WrongTypeException {
        Object ret = this.command("zremrangeByRank", key, start, stop);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long zremrangebyscore(String key, String min, String max) throws WrongTypeException, NotFloatMinMaxException {
        Object ret = this.command("zremrangeByScore", key, min, max);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        if (ret instanceof NotFloatMinMaxException) {
            throw (NotFloatMinMaxException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Long zrevrank(String key, String member) throws WrongTypeException {
        Object ret = this.command("zrevrank", key, member);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Long)ret;
    }

    @Override
    public Double zscore(String key, String member) throws WrongTypeException {
        Object ret = this.command("zscore", key, member);
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        return (Double)ret;
    }

    @Override
    public Long zunionstore(String destination, int numkeys, String ... options) throws WrongTypeException, SyntaxErrorException {
        int i;
        if (options.length < numkeys) {
            throw new SyntaxErrorException();
        }
        String[] sets = new String[numkeys];
        for (i = 0; i < numkeys; ++i) {
            sets[i] = options[i];
        }
        i = numkeys;
        ZParams params = null;
        ArrayList<Double> weights = new ArrayList<Double>();
        String aggregate = null;
        while (i < options.length) {
            if (options[i] == null) continue;
            if ("weights".equals(options[i].toLowerCase())) {
                if (i + 1 >= options.length) {
                    throw new SyntaxErrorException();
                }
                if (params == null) {
                    params = new ZParams();
                }
                int ki = 0;
                ++i;
                while (i < options.length && !"aggregate".equals(options[i])) {
                    weights.add(Double.valueOf(options[i]));
                    ++ki;
                    ++i;
                }
                continue;
            }
            if ("aggregate".equals(options[i].toLowerCase())) {
                if (i + 1 >= options.length) {
                    throw new SyntaxErrorException();
                }
                aggregate = options[i + 1];
                i += 2;
                continue;
            }
            throw new SyntaxErrorException();
        }
        if (!weights.isEmpty()) {
            if (params == null) {
                params = new ZParams();
            }
            double[] weightsArr = new double[weights.size()];
            Double[] weightsToArr = weights.toArray(new Double[weights.size()]);
            for (int j = 0; j < weightsToArr.length; ++j) {
                weightsArr[j] = weightsToArr[j];
            }
            params = params.weightsByDouble(weightsArr);
        }
        if (aggregate != null) {
            if (params == null) {
                params = new ZParams();
            }
            params = "min".equals(aggregate) ? params.aggregate(ZParams.Aggregate.MIN) : ("max".equals(aggregate) ? params.aggregate(ZParams.Aggregate.MAX) : params.aggregate(ZParams.Aggregate.SUM));
        }
        Object ret = null;
        ret = params == null ? this.command("zunionstore", destination, sets) : this.command("zunionstore", destination, params, sets);
        if (ret instanceof WrongTypeException) {
            throw new WrongTypeException();
        }
        if (ret instanceof SyntaxErrorException) {
            throw new SyntaxErrorException();
        }
        return (Long)ret;
    }

    @Override
    public ScanResult<Set<IRedisSortedSet.ZsetPair>> zscan(String key, long cursor, String ... options) throws WrongTypeException {
        Object ret = null;
        if (options.length == 0) {
            ret = this.command("zscan", key, String.valueOf(cursor));
        } else {
            ScanParams params = new ScanParams();
            for (int idx = 0; idx < options.length; ++idx) {
                if (options[idx].equals("count")) {
                    params.count(Integer.valueOf(options[idx + 1]).intValue());
                    continue;
                }
                if (!options[idx].equals("match")) continue;
                params.match(options[idx + 1]);
            }
            ret = this.command("zscan", key, String.valueOf(cursor), params);
        }
        if (ret == null) {
            return null;
        }
        if (ret instanceof WrongTypeException) {
            throw (WrongTypeException)ret;
        }
        redis.clients.jedis.ScanResult scanResult = (redis.clients.jedis.ScanResult)ret;
        Set<IRedisSortedSet.ZsetPair> results = this.toZsetPairSetFromTupleSet(scanResult.getResult());
        return new ScanResult<Set<IRedisSortedSet.ZsetPair>>(Long.valueOf(scanResult.getCursor()), results);
    }
}

