/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis.adapter.jedis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rarefiedredis.redis.IRedisClient;
import org.rarefiedredis.redis.IRedisSortedSet;
import org.rarefiedredis.redis.RedisMock;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.exceptions.JedisException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JedisAdapter
extends Jedis {
    private IRedisClient redis;

    public JedisAdapter() {
        super("");
        this.redis = new RedisMock();
    }

    public JedisAdapter(IRedisClient redis) {
        super("");
        this.redis = redis;
    }

    private Set<Tuple> toTupleSet(Set<IRedisSortedSet.ZsetPair> pairs) {
        HashSet<Tuple> set = new HashSet<Tuple>();
        for (IRedisSortedSet.ZsetPair pair : pairs) {
            set.add(new Tuple(pair.member, pair.score));
        }
        return set;
    }

    public String set(String key, String value) {
        try {
            return this.redis.set(key, value, new String[0]);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String set(String key, String value, String nxxx, String expx, long time) {
        try {
            return this.redis.set(key, value, nxxx, expx, String.valueOf(time));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String get(String key) {
        try {
            return this.redis.get(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Boolean exists(String key) {
        try {
            return this.redis.exists(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long del(String ... keys) {
        try {
            return this.redis.del(keys);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long del(String key) {
        try {
            return this.redis.del(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String type(String key) {
        try {
            return this.redis.type(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long expire(String key, int seconds) {
        try {
            return this.redis.expire(key, seconds) != false ? 1L : 0L;
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long expireAt(String key, long unixTime) {
        try {
            return this.redis.expireat(key, unixTime) != false ? 1L : 0L;
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long ttl(String key) {
        try {
            return this.redis.ttl(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long move(String key, int dbIndex) {
        try {
            return this.redis.move(key, dbIndex);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String getSet(String key, String value) {
        try {
            return this.redis.getset(key, value);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public List<String> mget(String ... keys) {
        try {
            String[] mget = this.redis.mget(keys);
            ArrayList<String> lst = new ArrayList<String>(mget.length);
            for (String get : mget) {
                lst.add(get);
            }
            return lst;
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long setnx(String key, String value) {
        try {
            return this.redis.setnx(key, value);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String setex(String key, int seconds, String value) {
        try {
            return this.redis.setex(key, seconds, value);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String mset(String ... keysvalues) {
        try {
            return this.redis.mset(keysvalues);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long msetnx(String ... keysvalues) {
        try {
            return this.redis.msetnx(keysvalues) != false ? 1L : 0L;
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long decrBy(String key, long integer) {
        try {
            return this.redis.decrby(key, integer);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long decr(String key) {
        try {
            return this.redis.decr(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long incrBy(String key, long integer) {
        try {
            return this.redis.incrby(key, integer);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Double incrByFloat(String key, double value) {
        try {
            return Double.parseDouble(this.redis.incrbyfloat(key, value));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long incr(String key) {
        try {
            return this.redis.incr(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long append(String key, String value) {
        try {
            return this.redis.append(key, value);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String substr(String key, int start, int end) {
        try {
            return this.redis.getrange(key, start, end);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long hset(String key, String field, String value) {
        try {
            return this.redis.hset(key, field, value) != false ? 1L : 0L;
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String hget(String key, String field) {
        try {
            return this.redis.hget(key, field);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long hsetnx(String key, String field, String value) {
        try {
            return this.redis.hsetnx(key, field, value) != false ? 1L : 0L;
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String hmset(String key, Map<String, String> hash) {
        try {
            String field = null;
            String value = null;
            String[] args = new String[(hash.size() - 1) * 2];
            int idx = 0;
            for (String f : hash.keySet()) {
                if (field == null) {
                    field = f;
                    value = hash.get(f);
                    continue;
                }
                args[idx] = f;
                args[idx + 1] = hash.get(f);
                idx += 2;
            }
            return this.redis.hmset(key, field, value, args);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public List<String> hmget(String key, String ... fields) {
        try {
            String field = fields[0];
            String[] f = new String[fields.length - 1];
            for (int idx = 1; idx < fields.length; ++idx) {
                f[idx - 1] = fields[idx];
            }
            return this.redis.hmget(key, field, f);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long hincrBy(String key, String field, long value) {
        try {
            return this.redis.hincrby(key, field, value);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Double hincrByFloat(String key, String field, double value) {
        try {
            return Double.parseDouble(this.redis.hincrbyfloat(key, field, value));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Boolean hexists(String key, String field) {
        try {
            return this.redis.hexists(key, field);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long hdel(String key, String ... fields) {
        try {
            String field = fields[0];
            String[] f = new String[fields.length - 1];
            for (int idx = 1; idx < fields.length; ++idx) {
                f[idx - 1] = fields[idx];
            }
            return this.redis.hdel(key, field, f);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long hlen(String key) {
        try {
            return this.redis.hlen(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> hkeys(String key) {
        try {
            return this.redis.hkeys(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public List<String> hvals(String key) {
        try {
            return this.redis.hvals(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Map<String, String> hgetAll(String key) {
        try {
            return this.redis.hgetall(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long rpush(String key, String ... strings) {
        try {
            String element = strings[0];
            String[] elements = new String[strings.length - 1];
            for (int idx = 1; idx < strings.length; ++idx) {
                elements[idx - 1] = strings[idx];
            }
            return this.redis.rpush(key, element, elements);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long lpush(String key, String ... strings) {
        try {
            String element = strings[0];
            String[] elements = new String[strings.length - 1];
            for (int idx = 1; idx < strings.length; ++idx) {
                elements[idx - 1] = strings[idx];
            }
            return this.redis.lpush(key, element, elements);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long llen(String key) {
        try {
            return this.redis.llen(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public List<String> lrange(String key, long start, long end) {
        try {
            return this.redis.lrange(key, start, end);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String ltrim(String key, long start, long end) {
        try {
            return this.redis.ltrim(key, start, end);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String lindex(String key, long index) {
        try {
            return this.redis.lindex(key, index);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String lset(String key, long index, String value) {
        try {
            return this.redis.lset(key, index, value);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long lrem(String key, long count, String value) {
        try {
            return this.redis.lrem(key, count, value);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String lpop(String key) {
        try {
            return this.redis.lpop(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String rpop(String key) {
        try {
            return this.redis.rpop(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String rpoplpush(String srckey, String dstkey) {
        try {
            return this.redis.rpoplpush(srckey, dstkey);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long sadd(String key, String ... members) {
        try {
            String member = members[0];
            String[] m = new String[members.length - 1];
            for (int idx = 1; idx < members.length; ++idx) {
                m[idx - 1] = members[idx];
            }
            return this.redis.sadd(key, member, m);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> smembers(String key) {
        try {
            return this.redis.smembers(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long srem(String key, String ... members) {
        try {
            String member = members[0];
            String[] m = new String[members.length - 1];
            for (int idx = 1; idx < members.length; ++idx) {
                m[idx - 1] = members[idx];
            }
            return this.redis.srem(key, member, m);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String spop(String key) {
        try {
            return this.redis.spop(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long smove(String srckey, String dstkey, String member) {
        try {
            return this.redis.smove(srckey, dstkey, member) != false ? 1L : 0L;
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long scard(String key) {
        try {
            return this.redis.scard(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Boolean sismember(String key, String member) {
        try {
            return this.redis.sismember(key, member);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> sinter(String ... keys) {
        try {
            String key = keys[0];
            String[] k = new String[keys.length - 1];
            for (int idx = 0; idx < keys.length; ++idx) {
                k[idx - 1] = keys[idx];
            }
            return this.redis.sinter(key, k);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long sinterstore(String dstkey, String ... keys) {
        try {
            String key = keys[0];
            String[] k = new String[keys.length - 1];
            for (int idx = 0; idx < keys.length; ++idx) {
                k[idx - 1] = keys[idx];
            }
            return this.redis.sinterstore(dstkey, key, k);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> sunion(String ... keys) {
        try {
            String key = keys[0];
            String[] k = new String[keys.length - 1];
            for (int idx = 0; idx < keys.length; ++idx) {
                k[idx - 1] = keys[idx];
            }
            return this.redis.sunion(key, k);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long sunionstore(String dstkey, String ... keys) {
        try {
            String key = keys[0];
            String[] k = new String[keys.length - 1];
            for (int idx = 0; idx < keys.length; ++idx) {
                k[idx - 1] = keys[idx];
            }
            return this.redis.sunionstore(dstkey, key, k);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> sdiff(String ... keys) {
        try {
            String key = keys[0];
            String[] k = new String[keys.length - 1];
            for (int idx = 0; idx < keys.length; ++idx) {
                k[idx - 1] = keys[idx];
            }
            return this.redis.sdiff(key, k);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long sdiffstore(String dstkey, String ... keys) {
        try {
            String key = keys[0];
            String[] k = new String[keys.length - 1];
            for (int idx = 0; idx < keys.length; ++idx) {
                k[idx - 1] = keys[idx];
            }
            return this.redis.sdiffstore(dstkey, key, k);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String srandmember(String key) {
        try {
            return this.redis.srandmember(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public List<String> srandmember(String key, int count) {
        try {
            return this.redis.srandmember(key, count);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long zadd(String key, double score, String member) {
        try {
            return this.redis.zadd(key, new IRedisSortedSet.ZsetPair(member, score), new IRedisSortedSet.ZsetPair[0]);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long zadd(String key, Map<String, Double> scoreMembers) {
        try {
            Double score = null;
            String member = null;
            ArrayList<IRedisSortedSet.ZsetPair> scoresmembers = new ArrayList<IRedisSortedSet.ZsetPair>((scoreMembers.size() - 1) * 2);
            for (String m : scoreMembers.keySet()) {
                if (m == null) {
                    member = m;
                    score = scoreMembers.get(m);
                    continue;
                }
                scoresmembers.add(new IRedisSortedSet.ZsetPair(m, scoreMembers.get(m)));
            }
            return this.redis.zadd(key, new IRedisSortedSet.ZsetPair(member, score), (IRedisSortedSet.ZsetPair[])scoresmembers.toArray());
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> zrange(String key, long start, long end) {
        try {
            return IRedisSortedSet.ZsetPair.members(this.redis.zrange(key, start, end, new String[0]));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long zrem(String key, String ... members) {
        try {
            String member = members[0];
            String[] ms = new String[members.length - 1];
            for (int idx = 1; idx < members.length; ++idx) {
                ms[idx - 1] = members[idx];
            }
            return this.redis.zrem(key, member, ms);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Double zincrby(String key, double score, String member) {
        try {
            return Double.parseDouble(this.redis.zincrby(key, score, member));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long zrank(String key, String member) {
        try {
            return this.redis.zrank(key, member);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long zrevrank(String key, String member) {
        try {
            return this.redis.zrevrank(key, member);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> zrevrange(String key, long start, long end) {
        try {
            return IRedisSortedSet.ZsetPair.members(this.redis.zrevrange(key, start, end, new String[0]));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        try {
            return this.toTupleSet(this.redis.zrange(key, start, end, "withscores"));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        try {
            return this.toTupleSet(this.redis.zrevrange(key, start, end, "withscores"));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long zcard(String key) {
        try {
            return this.redis.zcard(key);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Double zscore(String key, String member) {
        try {
            return this.zscore(key, member);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public String watch(String ... keys) {
        try {
            for (String key : keys) {
                this.redis.watch(key);
            }
            return "OK";
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long zcount(String key, double min, double max) {
        try {
            return this.redis.zcount(key, min, max);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long zcount(String key, String min, String max) {
        try {
            return this.redis.zcount(key, Double.parseDouble(min), Double.parseDouble(max));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        try {
            return IRedisSortedSet.ZsetPair.members(this.redis.zrangebyscore(key, String.valueOf(min), String.valueOf(max), new String[0]));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        try {
            return IRedisSortedSet.ZsetPair.members(this.redis.zrangebyscore(key, min, max, new String[0]));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        try {
            return IRedisSortedSet.ZsetPair.members(this.redis.zrangebyscore(key, String.valueOf(min), String.valueOf(max), "limit", String.valueOf(offset), String.valueOf(count)));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        try {
            return IRedisSortedSet.ZsetPair.members(this.redis.zrangebyscore(key, min, max, "limit", String.valueOf(offset), String.valueOf(count)));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        try {
            return this.toTupleSet(this.redis.zrangebyscore(key, String.valueOf(min), String.valueOf(max), "withscores"));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        try {
            return this.toTupleSet(this.redis.zrangebyscore(key, min, max, "withscores"));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        try {
            return this.toTupleSet(this.redis.zrangebyscore(key, String.valueOf(min), String.valueOf(max), "limit", String.valueOf(offset), String.valueOf(count), "withscores"));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        try {
            return this.toTupleSet(this.redis.zrangebyscore(key, min, max, "limit", String.valueOf(offset), String.valueOf(count), "withscores"));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        try {
            return IRedisSortedSet.ZsetPair.members(this.redis.zrevrangebyscore(key, String.valueOf(max), String.valueOf(min), new String[0]));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        try {
            return IRedisSortedSet.ZsetPair.members(this.redis.zrevrangebyscore(key, max, min, new String[0]));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        try {
            return IRedisSortedSet.ZsetPair.members(this.redis.zrevrangebyscore(key, String.valueOf(max), String.valueOf(min), "limit", String.valueOf(offset), String.valueOf(count)));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        try {
            return this.toTupleSet(this.redis.zrevrangebyscore(key, String.valueOf(max), String.valueOf(min), "withscores"));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        try {
            return this.toTupleSet(this.redis.zrevrangebyscore(key, String.valueOf(max), String.valueOf(min), "limit", String.valueOf(offset), String.valueOf(count), "withscores"));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        try {
            return this.toTupleSet(this.redis.zrevrangebyscore(key, max, min, "limit", String.valueOf(offset), String.valueOf(count), "withscores"));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        try {
            return IRedisSortedSet.ZsetPair.members(this.redis.zrevrangebyscore(key, max, min, "limit", String.valueOf(offset), String.valueOf(count)));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        try {
            return this.toTupleSet(this.redis.zrevrangebyscore(key, max, min, "withscores"));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long zremrangeByRank(String key, long start, long end) {
        try {
            return this.redis.zremrangebyrank(key, start, end);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long zremrangeByScore(String key, double start, double end) {
        try {
            return this.redis.zremrangebyscore(key, String.valueOf(start), String.valueOf(end));
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long zremrangeByScore(String key, String start, String end) {
        try {
            return this.redis.zremrangebyscore(key, start, end);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }

    public Long zunionstore(String dstkey, String ... sets) {
        try {
            return this.redis.zunionstore(dstkey, sets.length, sets);
        }
        catch (Exception e) {
            throw new JedisException((Throwable)e);
        }
    }
}

