/*
 * Decompiled with CFR 0.152.
 */
package org.rarefiedredis.redis.adapter.jedis;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.rarefiedredis.redis.ArgException;
import org.rarefiedredis.redis.IRedisClient;
import org.rarefiedredis.redis.IndexOutOfRangeException;
import org.rarefiedredis.redis.NoKeyException;
import org.rarefiedredis.redis.NotFloatException;
import org.rarefiedredis.redis.NotFloatHashException;
import org.rarefiedredis.redis.NotFloatMinMaxException;
import org.rarefiedredis.redis.NotIntegerException;
import org.rarefiedredis.redis.NotIntegerHashException;
import org.rarefiedredis.redis.NotValidStringRangeItemException;
import org.rarefiedredis.redis.SyntaxErrorException;
import org.rarefiedredis.redis.WrongTypeException;
import org.rarefiedredis.redis.adapter.jedis.AbstractJedisIRedisClient;
import org.rarefiedredis.redis.adapter.jedis.JedisIRedisClientMulti;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;

public final class JedisIRedisClient
extends AbstractJedisIRedisClient {
    private final JedisPool pool;
    private final Jedis jedis;

    public JedisIRedisClient(JedisPool pool) {
        this.pool = pool;
        this.jedis = null;
    }

    public JedisIRedisClient(Jedis jedis) {
        this.pool = null;
        this.jedis = jedis;
    }

    public IRedisClient createClient() {
        block3: {
            if (this.pool != null) {
                Jedis client = null;
                try {
                    client = this.pool.getResource();
                    return new JedisIRedisClient(client);
                }
                catch (Exception e) {
                    if (client == null) break block3;
                    client.close();
                }
            }
        }
        return this;
    }

    public void close() {
        if (this.jedis != null) {
            this.jedis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object command(String name, Object ... args) {
        Jedis jedis = null;
        Object ret = null;
        try {
            jedis = this.jedis != null ? this.jedis : this.pool.getResource();
            if (jedis == null) {
                Object var5_5 = null;
                return var5_5;
            }
            Class[] parameterTypes = new Class[args.length];
            for (int idx = 0; idx < args.length; ++idx) {
                if (args[idx] == null) continue;
                parameterTypes[idx] = args[idx].getClass();
                if (parameterTypes[idx].equals(Integer.class)) {
                    parameterTypes[idx] = Integer.TYPE;
                }
                if (parameterTypes[idx].equals(Long.class)) {
                    parameterTypes[idx] = Long.TYPE;
                }
                if (parameterTypes[idx].equals(Double.class)) {
                    parameterTypes[idx] = Double.TYPE;
                }
                if (!parameterTypes[idx].equals(HashMap.class)) continue;
                parameterTypes[idx] = Map.class;
            }
            ret = jedis.getClass().getDeclaredMethod(name, parameterTypes).invoke((Object)jedis, args);
        }
        catch (NoSuchMethodException e) {
            ret = null;
        }
        catch (IllegalAccessException e) {
            ret = null;
        }
        catch (InvocationTargetException e) {
            ret = null;
            String msg = e.getCause().getMessage();
            if (msg.contains("WRONGTYPE")) {
                ret = new WrongTypeException();
            } else if (msg.contains("no such key")) {
                ret = new NoKeyException();
            } else if (msg.contains("index out of range")) {
                ret = new IndexOutOfRangeException();
            } else if (msg.contains("hash value is not an integer")) {
                ret = new NotIntegerHashException();
            } else if (msg.contains("value is not an integer")) {
                ret = new NotIntegerException();
            } else if (msg.contains("hash value is not a valid float")) {
                ret = new NotFloatHashException();
            } else if (msg.contains("value is not a valid float")) {
                ret = new NotFloatException();
            } else if (msg.contains("syntax error")) {
                ret = new SyntaxErrorException();
            } else if (msg.contains("wrong number of arguments")) {
                ret = new ArgException(e.getCause());
            } else if (msg.contains("not valid string range item")) {
                ret = new NotValidStringRangeItemException();
            } else if (msg.contains("min or max is not a float")) {
                ret = new NotFloatMinMaxException();
            }
        }
        finally {
            if (this.jedis == null && jedis != null) {
                jedis.close();
            }
        }
        return ret;
    }

    public IRedisClient multi() {
        if (this.jedis != null) {
            return new JedisIRedisClientMulti(this.jedis);
        }
        return new JedisIRedisClientMulti(this.pool);
    }

    public String watch(String key) {
        String[] keys = new String[]{key};
        if (this.pool != null) {
            return null;
        }
        return (String)this.command("watch", new Object[]{keys});
    }
}

