/*
 * Decompiled with CFR 0.152.
 */
package org.reflections.maven.plugin;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;
import org.jfrog.jade.plugins.common.injectable.MvnInjectableMojoSupport;
import org.jfrog.maven.annomojo.annotations.MojoGoal;
import org.jfrog.maven.annomojo.annotations.MojoParameter;
import org.jfrog.maven.annomojo.annotations.MojoPhase;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.ReflectionsException;
import org.reflections.maven.plugin.MavenLogAdapter;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.scanners.TypeElementsScanner;
import org.reflections.scanners.TypesScanner;
import org.reflections.serializers.JavaCodeSerializer;
import org.reflections.serializers.Serializer;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.reflections.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MojoGoal(value="reflections")
@MojoPhase(value="process-classes")
public class ReflectionsMojo
extends MvnInjectableMojoSupport {
    @MojoParameter(description="a comma separated list of scanner classes names (fully qualified names or simple names).defaults to {@link org.reflections.scanners.TypeAnnotationsScanner}, {@link org.reflections.scanners.SubTypesScanner}")
    private String scanners;
    private static final String DEFAULT_INCLUDE_EXCLUDE = "-java\\..*, -javax\\..*, -sun\\..*, -com\\.sun\\..*";
    @MojoParameter(description="a comma separated list of include exclude filters, to be used with {@link org.reflections.util.FilterBuilder} to filter the inputs of all scanners.defaults to -java\\..*, -javax\\..*, -sun\\..*, -com\\.sun\\..*", defaultValue="-java\\..*, -javax\\..*, -sun\\..*, -com\\.sun\\..*")
    private String includeExclude;
    @MojoParameter(description="destination path to save metadata to.defaults to ${project.build.outputDirectory/testOutputDirectory}/META-INF/reflections/${project.artifactId}-reflections.xml")
    private String destinations;
    @MojoParameter(description="serializer class name to be used for saving (fully qualified names or simple names).defaults to {@link org.reflections.serializers.XmlSerializer}")
    private String serializer;
    @MojoParameter(description="indicates whether to use parallel scanning of classes, using j.u.c FixedThreadPool.default to false", defaultValue="false")
    private Boolean parallel;
    @MojoParameter(description="If set to true, the mojo will generate the metadata for the test classes as well", defaultValue="false")
    private boolean tests;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Scanner[] scannerArray;
        String outputDirectory;
        if (StringUtils.isEmpty((String)this.destinations)) {
            this.destinations = this.resolveOutputDirectory() + "/META-INF/reflections/" + this.getProject().getArtifactId() + "-reflections.xml";
        }
        if (!new File(outputDirectory = this.resolveOutputDirectory()).exists()) {
            this.getLog().warn((CharSequence)String.format("Reflections plugin is skipping because %s was not found", outputDirectory));
            return;
        }
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.setUrls(this.parseUrls());
        if (!Utils.isEmpty((String)this.includeExclude)) {
            config.filterInputsBy((Predicate)FilterBuilder.parse((String)this.includeExclude));
        }
        if (!Utils.isEmpty((String)this.scanners)) {
            scannerArray = this.parseScanners();
        } else {
            Scanner[] scannerArray2 = new Scanner[2];
            scannerArray2[0] = new SubTypesScanner();
            scannerArray = scannerArray2;
            scannerArray2[1] = new TypeAnnotationsScanner();
        }
        config.setScanners(scannerArray);
        if (!Utils.isEmpty((String)this.serializer)) {
            try {
                Serializer serializerInstance = (Serializer)ReflectionsMojo.forName(this.serializer, "org.reflections.serializers").newInstance();
                config.setSerializer(serializerInstance);
                if (serializerInstance instanceof JavaCodeSerializer) {
                    int size = config.getScanners().size();
                    config.addScanners(new Scanner[]{new TypesScanner(), new TypeElementsScanner()});
                    if (size != config.getScanners().size()) {
                        this.getLog().info((CharSequence)"added type scanners for JavaCodeSerializer");
                    }
                }
            }
            catch (Exception ex) {
                throw new ReflectionsException("could not create serializer instance", (Throwable)ex);
            }
        }
        if (this.parallel != null && this.parallel.equals(Boolean.TRUE)) {
            config.useParallelExecutor();
        }
        if (Reflections.log == null) {
            try {
                Reflections.log = new MavenLogAdapter(this.getLog());
            }
            catch (Error e) {
                // empty catch block
            }
        }
        Reflections reflections = new Reflections((Configuration)config);
        reflections.save(this.destinations.trim());
    }

    private Set<URL> parseUrls() throws MojoExecutionException {
        HashSet urls = Sets.newHashSet();
        urls.add(this.parseOutputDirUrl());
        if (!Utils.isEmpty((String)this.includeExclude)) {
            for (String string : this.includeExclude.split(",")) {
                String trimmed = string.trim();
                char prefix = trimmed.charAt(0);
                String pattern = trimmed.substring(1);
                if (prefix != '+') continue;
                urls.addAll(ClasspathHelper.forPackage((String)pattern, (ClassLoader[])new ClassLoader[0]));
            }
        }
        return urls;
    }

    private Scanner[] parseScanners() throws MojoExecutionException {
        HashSet<Scanner> scannersSet = new HashSet<Scanner>(0);
        if (StringUtils.isNotEmpty((String)this.scanners)) {
            String[] scannerClasses;
            for (String scannerClass : scannerClasses = this.scanners.split(",")) {
                try {
                    scannersSet.add((Scanner)ReflectionsMojo.forName(scannerClass.trim(), "org.reflections.scanners").newInstance());
                }
                catch (Exception e) {
                    throw new MojoExecutionException(String.format("error getting scanner %s or org.reflections.scanners.%s", scannerClass.trim(), scannerClass.trim()), e);
                }
            }
        }
        return scannersSet.toArray(new Scanner[scannersSet.size()]);
    }

    private static <T> Class<T> forName(String name, String ... prefixes) throws ClassNotFoundException {
        try {
            return Class.forName(name.trim());
        }
        catch (Exception e) {
            if (prefixes != null) {
                for (String prefix : prefixes) {
                    try {
                        return Class.forName(prefix + "." + name.trim());
                    }
                    catch (Exception e1) {
                    }
                }
            }
            throw new ClassNotFoundException(name);
        }
    }

    private URL parseOutputDirUrl() throws MojoExecutionException {
        try {
            File outputDirectoryFile = new File(this.resolveOutputDirectory() + '/');
            return outputDirectoryFile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private String resolveOutputDirectory() {
        return this.tests ? this.getProject().getBuild().getTestOutputDirectory() : this.getProject().getBuild().getOutputDirectory();
    }
}

