/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.rocksdb.AccessHint;
import org.rocksdb.Cache;
import org.rocksdb.DBOptionsInterface;
import org.rocksdb.DbPath;
import org.rocksdb.Env;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.Logger;
import org.rocksdb.RateLimiter;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksObject;
import org.rocksdb.SstFileManager;
import org.rocksdb.Statistics;
import org.rocksdb.WALRecoveryMode;

public class DBOptions
extends RocksObject
implements DBOptionsInterface<DBOptions> {
    static final int DEFAULT_NUM_SHARD_BITS = -1;
    private Env env_;
    private int numShardBits_;
    private RateLimiter rateLimiter_;
    private Cache rowCache_;

    public DBOptions() {
        super(DBOptions.newDBOptions());
        this.numShardBits_ = -1;
    }

    public DBOptions(DBOptions dBOptions) {
        super(DBOptions.copyDBOptions(dBOptions.nativeHandle_));
        this.env_ = dBOptions.env_;
        this.numShardBits_ = dBOptions.numShardBits_;
        this.rateLimiter_ = dBOptions.rateLimiter_;
        this.rowCache_ = dBOptions.rowCache_;
    }

    public static DBOptions getDBOptionsFromProps(Properties properties) {
        if (properties == null || properties.size() == 0) {
            throw new IllegalArgumentException("Properties value must contain at least one value.");
        }
        DBOptions dBOptions = null;
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : properties.stringPropertyNames()) {
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(properties.getProperty(string));
            stringBuilder.append(";");
        }
        long l = DBOptions.getDBOptionsFromProps(stringBuilder.toString());
        if (l != 0L) {
            dBOptions = new DBOptions(l);
        }
        return dBOptions;
    }

    @Override
    public DBOptions optimizeForSmallDb() {
        this.optimizeForSmallDb(this.nativeHandle_);
        return this;
    }

    @Override
    public DBOptions setIncreaseParallelism(int n) {
        assert (this.isOwningHandle());
        this.setIncreaseParallelism(this.nativeHandle_, n);
        return this;
    }

    @Override
    public DBOptions setCreateIfMissing(boolean bl) {
        assert (this.isOwningHandle());
        this.setCreateIfMissing(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean createIfMissing() {
        assert (this.isOwningHandle());
        return this.createIfMissing(this.nativeHandle_);
    }

    @Override
    public DBOptions setCreateMissingColumnFamilies(boolean bl) {
        assert (this.isOwningHandle());
        this.setCreateMissingColumnFamilies(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean createMissingColumnFamilies() {
        assert (this.isOwningHandle());
        return this.createMissingColumnFamilies(this.nativeHandle_);
    }

    @Override
    public DBOptions setEnv(Env env) {
        this.setEnv(this.nativeHandle_, env.nativeHandle_);
        this.env_ = env;
        return this;
    }

    @Override
    public Env getEnv() {
        return this.env_;
    }

    @Override
    public DBOptions setErrorIfExists(boolean bl) {
        assert (this.isOwningHandle());
        this.setErrorIfExists(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean errorIfExists() {
        assert (this.isOwningHandle());
        return this.errorIfExists(this.nativeHandle_);
    }

    @Override
    public DBOptions setParanoidChecks(boolean bl) {
        assert (this.isOwningHandle());
        this.setParanoidChecks(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean paranoidChecks() {
        assert (this.isOwningHandle());
        return this.paranoidChecks(this.nativeHandle_);
    }

    @Override
    public DBOptions setRateLimiter(RateLimiter rateLimiter) {
        assert (this.isOwningHandle());
        this.rateLimiter_ = rateLimiter;
        this.setRateLimiter(this.nativeHandle_, rateLimiter.nativeHandle_);
        return this;
    }

    @Override
    public DBOptions setSstFileManager(SstFileManager sstFileManager) {
        assert (this.isOwningHandle());
        this.setSstFileManager(this.nativeHandle_, sstFileManager.nativeHandle_);
        return this;
    }

    @Override
    public DBOptions setLogger(Logger logger) {
        assert (this.isOwningHandle());
        this.setLogger(this.nativeHandle_, logger.nativeHandle_);
        return this;
    }

    @Override
    public DBOptions setInfoLogLevel(InfoLogLevel infoLogLevel) {
        assert (this.isOwningHandle());
        this.setInfoLogLevel(this.nativeHandle_, infoLogLevel.getValue());
        return this;
    }

    @Override
    public InfoLogLevel infoLogLevel() {
        assert (this.isOwningHandle());
        return InfoLogLevel.getInfoLogLevel(this.infoLogLevel(this.nativeHandle_));
    }

    @Override
    public DBOptions setMaxOpenFiles(int n) {
        assert (this.isOwningHandle());
        this.setMaxOpenFiles(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxOpenFiles() {
        assert (this.isOwningHandle());
        return this.maxOpenFiles(this.nativeHandle_);
    }

    @Override
    public DBOptions setMaxFileOpeningThreads(int n) {
        assert (this.isOwningHandle());
        this.setMaxFileOpeningThreads(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxFileOpeningThreads() {
        assert (this.isOwningHandle());
        return this.maxFileOpeningThreads(this.nativeHandle_);
    }

    @Override
    public DBOptions setMaxTotalWalSize(long l) {
        assert (this.isOwningHandle());
        this.setMaxTotalWalSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxTotalWalSize() {
        assert (this.isOwningHandle());
        return this.maxTotalWalSize(this.nativeHandle_);
    }

    @Override
    public DBOptions setStatistics(Statistics statistics) {
        assert (this.isOwningHandle());
        this.setStatistics(this.nativeHandle_, statistics.nativeHandle_);
        return this;
    }

    @Override
    public Statistics statistics() {
        assert (this.isOwningHandle());
        long l = this.statistics(this.nativeHandle_);
        if (l == 0L) {
            return null;
        }
        return new Statistics(l);
    }

    @Override
    public DBOptions setUseFsync(boolean bl) {
        assert (this.isOwningHandle());
        this.setUseFsync(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean useFsync() {
        assert (this.isOwningHandle());
        return this.useFsync(this.nativeHandle_);
    }

    @Override
    public DBOptions setDbPaths(Collection<DbPath> collection) {
        assert (this.isOwningHandle());
        int n = collection.size();
        String[] stringArray = new String[n];
        long[] lArray = new long[n];
        int n2 = 0;
        for (DbPath dbPath : collection) {
            stringArray[n2] = dbPath.path.toString();
            lArray[n2] = dbPath.targetSize;
            ++n2;
        }
        this.setDbPaths(this.nativeHandle_, stringArray, lArray);
        return this;
    }

    @Override
    public List<DbPath> dbPaths() {
        int n = (int)this.dbPathsLen(this.nativeHandle_);
        if (n == 0) {
            return Collections.emptyList();
        }
        String[] stringArray = new String[n];
        long[] lArray = new long[n];
        this.dbPaths(this.nativeHandle_, stringArray, lArray);
        ArrayList<DbPath> arrayList = new ArrayList<DbPath>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new DbPath(Paths.get(stringArray[i], new String[0]), lArray[i]));
        }
        return arrayList;
    }

    @Override
    public DBOptions setDbLogDir(String string) {
        assert (this.isOwningHandle());
        this.setDbLogDir(this.nativeHandle_, string);
        return this;
    }

    @Override
    public String dbLogDir() {
        assert (this.isOwningHandle());
        return this.dbLogDir(this.nativeHandle_);
    }

    @Override
    public DBOptions setWalDir(String string) {
        assert (this.isOwningHandle());
        this.setWalDir(this.nativeHandle_, string);
        return this;
    }

    @Override
    public String walDir() {
        assert (this.isOwningHandle());
        return this.walDir(this.nativeHandle_);
    }

    @Override
    public DBOptions setDeleteObsoleteFilesPeriodMicros(long l) {
        assert (this.isOwningHandle());
        this.setDeleteObsoleteFilesPeriodMicros(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long deleteObsoleteFilesPeriodMicros() {
        assert (this.isOwningHandle());
        return this.deleteObsoleteFilesPeriodMicros(this.nativeHandle_);
    }

    @Override
    public void setBaseBackgroundCompactions(int n) {
        assert (this.isOwningHandle());
        this.setBaseBackgroundCompactions(this.nativeHandle_, n);
    }

    @Override
    public int baseBackgroundCompactions() {
        assert (this.isOwningHandle());
        return this.baseBackgroundCompactions(this.nativeHandle_);
    }

    @Override
    public DBOptions setMaxBackgroundCompactions(int n) {
        assert (this.isOwningHandle());
        this.setMaxBackgroundCompactions(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxBackgroundCompactions() {
        assert (this.isOwningHandle());
        return this.maxBackgroundCompactions(this.nativeHandle_);
    }

    @Override
    public void setMaxSubcompactions(int n) {
        assert (this.isOwningHandle());
        this.setMaxSubcompactions(this.nativeHandle_, n);
    }

    @Override
    public int maxSubcompactions() {
        assert (this.isOwningHandle());
        return this.maxSubcompactions(this.nativeHandle_);
    }

    @Override
    public DBOptions setMaxBackgroundFlushes(int n) {
        assert (this.isOwningHandle());
        this.setMaxBackgroundFlushes(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxBackgroundFlushes() {
        assert (this.isOwningHandle());
        return this.maxBackgroundFlushes(this.nativeHandle_);
    }

    @Override
    public DBOptions setMaxBackgroundJobs(int n) {
        assert (this.isOwningHandle());
        this.setMaxBackgroundJobs(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int maxBackgroundJobs() {
        assert (this.isOwningHandle());
        return this.maxBackgroundJobs(this.nativeHandle_);
    }

    @Override
    public DBOptions setMaxLogFileSize(long l) {
        assert (this.isOwningHandle());
        this.setMaxLogFileSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxLogFileSize() {
        assert (this.isOwningHandle());
        return this.maxLogFileSize(this.nativeHandle_);
    }

    @Override
    public DBOptions setLogFileTimeToRoll(long l) {
        assert (this.isOwningHandle());
        this.setLogFileTimeToRoll(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long logFileTimeToRoll() {
        assert (this.isOwningHandle());
        return this.logFileTimeToRoll(this.nativeHandle_);
    }

    @Override
    public DBOptions setKeepLogFileNum(long l) {
        assert (this.isOwningHandle());
        this.setKeepLogFileNum(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long keepLogFileNum() {
        assert (this.isOwningHandle());
        return this.keepLogFileNum(this.nativeHandle_);
    }

    @Override
    public DBOptions setRecycleLogFileNum(long l) {
        assert (this.isOwningHandle());
        this.setRecycleLogFileNum(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long recycleLogFileNum() {
        assert (this.isOwningHandle());
        return this.recycleLogFileNum(this.nativeHandle_);
    }

    @Override
    public DBOptions setMaxManifestFileSize(long l) {
        assert (this.isOwningHandle());
        this.setMaxManifestFileSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long maxManifestFileSize() {
        assert (this.isOwningHandle());
        return this.maxManifestFileSize(this.nativeHandle_);
    }

    @Override
    public DBOptions setTableCacheNumshardbits(int n) {
        assert (this.isOwningHandle());
        this.setTableCacheNumshardbits(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int tableCacheNumshardbits() {
        assert (this.isOwningHandle());
        return this.tableCacheNumshardbits(this.nativeHandle_);
    }

    @Override
    public DBOptions setWalTtlSeconds(long l) {
        assert (this.isOwningHandle());
        this.setWalTtlSeconds(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long walTtlSeconds() {
        assert (this.isOwningHandle());
        return this.walTtlSeconds(this.nativeHandle_);
    }

    @Override
    public DBOptions setWalSizeLimitMB(long l) {
        assert (this.isOwningHandle());
        this.setWalSizeLimitMB(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long walSizeLimitMB() {
        assert (this.isOwningHandle());
        return this.walSizeLimitMB(this.nativeHandle_);
    }

    @Override
    public DBOptions setManifestPreallocationSize(long l) {
        assert (this.isOwningHandle());
        this.setManifestPreallocationSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long manifestPreallocationSize() {
        assert (this.isOwningHandle());
        return this.manifestPreallocationSize(this.nativeHandle_);
    }

    @Override
    public DBOptions setUseDirectReads(boolean bl) {
        assert (this.isOwningHandle());
        this.setUseDirectReads(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean useDirectReads() {
        assert (this.isOwningHandle());
        return this.useDirectReads(this.nativeHandle_);
    }

    @Override
    public DBOptions setUseDirectIoForFlushAndCompaction(boolean bl) {
        assert (this.isOwningHandle());
        this.setUseDirectIoForFlushAndCompaction(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean useDirectIoForFlushAndCompaction() {
        assert (this.isOwningHandle());
        return this.useDirectIoForFlushAndCompaction(this.nativeHandle_);
    }

    @Override
    public DBOptions setAllowFAllocate(boolean bl) {
        assert (this.isOwningHandle());
        this.setAllowFAllocate(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allowFAllocate() {
        assert (this.isOwningHandle());
        return this.allowFAllocate(this.nativeHandle_);
    }

    @Override
    public DBOptions setAllowMmapReads(boolean bl) {
        assert (this.isOwningHandle());
        this.setAllowMmapReads(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allowMmapReads() {
        assert (this.isOwningHandle());
        return this.allowMmapReads(this.nativeHandle_);
    }

    @Override
    public DBOptions setAllowMmapWrites(boolean bl) {
        assert (this.isOwningHandle());
        this.setAllowMmapWrites(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allowMmapWrites() {
        assert (this.isOwningHandle());
        return this.allowMmapWrites(this.nativeHandle_);
    }

    @Override
    public DBOptions setIsFdCloseOnExec(boolean bl) {
        assert (this.isOwningHandle());
        this.setIsFdCloseOnExec(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean isFdCloseOnExec() {
        assert (this.isOwningHandle());
        return this.isFdCloseOnExec(this.nativeHandle_);
    }

    @Override
    public DBOptions setStatsDumpPeriodSec(int n) {
        assert (this.isOwningHandle());
        this.setStatsDumpPeriodSec(this.nativeHandle_, n);
        return this;
    }

    @Override
    public int statsDumpPeriodSec() {
        assert (this.isOwningHandle());
        return this.statsDumpPeriodSec(this.nativeHandle_);
    }

    @Override
    public DBOptions setAdviseRandomOnOpen(boolean bl) {
        assert (this.isOwningHandle());
        this.setAdviseRandomOnOpen(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean adviseRandomOnOpen() {
        return this.adviseRandomOnOpen(this.nativeHandle_);
    }

    @Override
    public DBOptions setDbWriteBufferSize(long l) {
        assert (this.isOwningHandle());
        this.setDbWriteBufferSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long dbWriteBufferSize() {
        assert (this.isOwningHandle());
        return this.dbWriteBufferSize(this.nativeHandle_);
    }

    @Override
    public DBOptions setAccessHintOnCompactionStart(AccessHint accessHint) {
        assert (this.isOwningHandle());
        this.setAccessHintOnCompactionStart(this.nativeHandle_, accessHint.getValue());
        return this;
    }

    @Override
    public AccessHint accessHintOnCompactionStart() {
        assert (this.isOwningHandle());
        return AccessHint.getAccessHint(this.accessHintOnCompactionStart(this.nativeHandle_));
    }

    @Override
    public DBOptions setNewTableReaderForCompactionInputs(boolean bl) {
        assert (this.isOwningHandle());
        this.setNewTableReaderForCompactionInputs(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean newTableReaderForCompactionInputs() {
        assert (this.isOwningHandle());
        return this.newTableReaderForCompactionInputs(this.nativeHandle_);
    }

    @Override
    public DBOptions setCompactionReadaheadSize(long l) {
        assert (this.isOwningHandle());
        this.setCompactionReadaheadSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long compactionReadaheadSize() {
        assert (this.isOwningHandle());
        return this.compactionReadaheadSize(this.nativeHandle_);
    }

    @Override
    public DBOptions setRandomAccessMaxBufferSize(long l) {
        assert (this.isOwningHandle());
        this.setRandomAccessMaxBufferSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long randomAccessMaxBufferSize() {
        assert (this.isOwningHandle());
        return this.randomAccessMaxBufferSize(this.nativeHandle_);
    }

    @Override
    public DBOptions setWritableFileMaxBufferSize(long l) {
        assert (this.isOwningHandle());
        this.setWritableFileMaxBufferSize(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long writableFileMaxBufferSize() {
        assert (this.isOwningHandle());
        return this.writableFileMaxBufferSize(this.nativeHandle_);
    }

    @Override
    public DBOptions setUseAdaptiveMutex(boolean bl) {
        assert (this.isOwningHandle());
        this.setUseAdaptiveMutex(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean useAdaptiveMutex() {
        assert (this.isOwningHandle());
        return this.useAdaptiveMutex(this.nativeHandle_);
    }

    @Override
    public DBOptions setBytesPerSync(long l) {
        assert (this.isOwningHandle());
        this.setBytesPerSync(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long bytesPerSync() {
        return this.bytesPerSync(this.nativeHandle_);
    }

    @Override
    public DBOptions setWalBytesPerSync(long l) {
        assert (this.isOwningHandle());
        this.setWalBytesPerSync(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long walBytesPerSync() {
        assert (this.isOwningHandle());
        return this.walBytesPerSync(this.nativeHandle_);
    }

    @Override
    public DBOptions setEnableThreadTracking(boolean bl) {
        assert (this.isOwningHandle());
        this.setEnableThreadTracking(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean enableThreadTracking() {
        assert (this.isOwningHandle());
        return this.enableThreadTracking(this.nativeHandle_);
    }

    @Override
    public DBOptions setDelayedWriteRate(long l) {
        assert (this.isOwningHandle());
        this.setDelayedWriteRate(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long delayedWriteRate() {
        return this.delayedWriteRate(this.nativeHandle_);
    }

    @Override
    public DBOptions setAllowConcurrentMemtableWrite(boolean bl) {
        this.setAllowConcurrentMemtableWrite(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allowConcurrentMemtableWrite() {
        return this.allowConcurrentMemtableWrite(this.nativeHandle_);
    }

    @Override
    public DBOptions setEnableWriteThreadAdaptiveYield(boolean bl) {
        this.setEnableWriteThreadAdaptiveYield(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean enableWriteThreadAdaptiveYield() {
        return this.enableWriteThreadAdaptiveYield(this.nativeHandle_);
    }

    @Override
    public DBOptions setWriteThreadMaxYieldUsec(long l) {
        this.setWriteThreadMaxYieldUsec(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long writeThreadMaxYieldUsec() {
        return this.writeThreadMaxYieldUsec(this.nativeHandle_);
    }

    @Override
    public DBOptions setWriteThreadSlowYieldUsec(long l) {
        this.setWriteThreadSlowYieldUsec(this.nativeHandle_, l);
        return this;
    }

    @Override
    public long writeThreadSlowYieldUsec() {
        return this.writeThreadSlowYieldUsec(this.nativeHandle_);
    }

    @Override
    public DBOptions setSkipStatsUpdateOnDbOpen(boolean bl) {
        assert (this.isOwningHandle());
        this.setSkipStatsUpdateOnDbOpen(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean skipStatsUpdateOnDbOpen() {
        assert (this.isOwningHandle());
        return this.skipStatsUpdateOnDbOpen(this.nativeHandle_);
    }

    @Override
    public DBOptions setWalRecoveryMode(WALRecoveryMode wALRecoveryMode) {
        assert (this.isOwningHandle());
        this.setWalRecoveryMode(this.nativeHandle_, wALRecoveryMode.getValue());
        return this;
    }

    @Override
    public WALRecoveryMode walRecoveryMode() {
        assert (this.isOwningHandle());
        return WALRecoveryMode.getWALRecoveryMode(this.walRecoveryMode(this.nativeHandle_));
    }

    @Override
    public DBOptions setAllow2pc(boolean bl) {
        assert (this.isOwningHandle());
        this.setAllow2pc(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean allow2pc() {
        assert (this.isOwningHandle());
        return this.allow2pc(this.nativeHandle_);
    }

    @Override
    public DBOptions setRowCache(Cache cache) {
        assert (this.isOwningHandle());
        this.setRowCache(this.nativeHandle_, cache.nativeHandle_);
        this.rowCache_ = cache;
        return this;
    }

    @Override
    public Cache rowCache() {
        assert (this.isOwningHandle());
        return this.rowCache_;
    }

    @Override
    public DBOptions setFailIfOptionsFileError(boolean bl) {
        assert (this.isOwningHandle());
        this.setFailIfOptionsFileError(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean failIfOptionsFileError() {
        assert (this.isOwningHandle());
        return this.failIfOptionsFileError(this.nativeHandle_);
    }

    @Override
    public DBOptions setDumpMallocStats(boolean bl) {
        assert (this.isOwningHandle());
        this.setDumpMallocStats(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean dumpMallocStats() {
        assert (this.isOwningHandle());
        return this.dumpMallocStats(this.nativeHandle_);
    }

    @Override
    public DBOptions setAvoidFlushDuringRecovery(boolean bl) {
        assert (this.isOwningHandle());
        this.setAvoidFlushDuringRecovery(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean avoidFlushDuringRecovery() {
        assert (this.isOwningHandle());
        return this.avoidFlushDuringRecovery(this.nativeHandle_);
    }

    @Override
    public DBOptions setAvoidFlushDuringShutdown(boolean bl) {
        assert (this.isOwningHandle());
        this.setAvoidFlushDuringShutdown(this.nativeHandle_, bl);
        return this;
    }

    @Override
    public boolean avoidFlushDuringShutdown() {
        assert (this.isOwningHandle());
        return this.avoidFlushDuringShutdown(this.nativeHandle_);
    }

    private DBOptions(long l) {
        super(l);
    }

    private static native long getDBOptionsFromProps(String var0);

    private static native long newDBOptions();

    private static native long copyDBOptions(long var0);

    @Override
    protected final native void disposeInternal(long var1);

    private native void optimizeForSmallDb(long var1);

    private native void setIncreaseParallelism(long var1, int var3);

    private native void setCreateIfMissing(long var1, boolean var3);

    private native boolean createIfMissing(long var1);

    private native void setCreateMissingColumnFamilies(long var1, boolean var3);

    private native boolean createMissingColumnFamilies(long var1);

    private native void setEnv(long var1, long var3);

    private native void setErrorIfExists(long var1, boolean var3);

    private native boolean errorIfExists(long var1);

    private native void setParanoidChecks(long var1, boolean var3);

    private native boolean paranoidChecks(long var1);

    private native void setRateLimiter(long var1, long var3);

    private native void setSstFileManager(long var1, long var3);

    private native void setLogger(long var1, long var3);

    private native void setInfoLogLevel(long var1, byte var3);

    private native byte infoLogLevel(long var1);

    private native void setMaxOpenFiles(long var1, int var3);

    private native int maxOpenFiles(long var1);

    private native void setMaxFileOpeningThreads(long var1, int var3);

    private native int maxFileOpeningThreads(long var1);

    private native void setMaxTotalWalSize(long var1, long var3);

    private native long maxTotalWalSize(long var1);

    private native void setStatistics(long var1, long var3);

    private native long statistics(long var1);

    private native boolean useFsync(long var1);

    private native void setUseFsync(long var1, boolean var3);

    private native void setDbPaths(long var1, String[] var3, long[] var4);

    private native long dbPathsLen(long var1);

    private native void dbPaths(long var1, String[] var3, long[] var4);

    private native void setDbLogDir(long var1, String var3);

    private native String dbLogDir(long var1);

    private native void setWalDir(long var1, String var3);

    private native String walDir(long var1);

    private native void setDeleteObsoleteFilesPeriodMicros(long var1, long var3);

    private native long deleteObsoleteFilesPeriodMicros(long var1);

    private native void setBaseBackgroundCompactions(long var1, int var3);

    private native int baseBackgroundCompactions(long var1);

    private native void setMaxBackgroundCompactions(long var1, int var3);

    private native int maxBackgroundCompactions(long var1);

    private native void setMaxSubcompactions(long var1, int var3);

    private native int maxSubcompactions(long var1);

    private native void setMaxBackgroundFlushes(long var1, int var3);

    private native int maxBackgroundFlushes(long var1);

    private native void setMaxBackgroundJobs(long var1, int var3);

    private native int maxBackgroundJobs(long var1);

    private native void setMaxLogFileSize(long var1, long var3) throws IllegalArgumentException;

    private native long maxLogFileSize(long var1);

    private native void setLogFileTimeToRoll(long var1, long var3) throws IllegalArgumentException;

    private native long logFileTimeToRoll(long var1);

    private native void setKeepLogFileNum(long var1, long var3) throws IllegalArgumentException;

    private native long keepLogFileNum(long var1);

    private native void setRecycleLogFileNum(long var1, long var3);

    private native long recycleLogFileNum(long var1);

    private native void setMaxManifestFileSize(long var1, long var3);

    private native long maxManifestFileSize(long var1);

    private native void setTableCacheNumshardbits(long var1, int var3);

    private native int tableCacheNumshardbits(long var1);

    private native void setWalTtlSeconds(long var1, long var3);

    private native long walTtlSeconds(long var1);

    private native void setWalSizeLimitMB(long var1, long var3);

    private native long walSizeLimitMB(long var1);

    private native void setManifestPreallocationSize(long var1, long var3) throws IllegalArgumentException;

    private native long manifestPreallocationSize(long var1);

    private native void setUseDirectReads(long var1, boolean var3);

    private native boolean useDirectReads(long var1);

    private native void setUseDirectIoForFlushAndCompaction(long var1, boolean var3);

    private native boolean useDirectIoForFlushAndCompaction(long var1);

    private native void setAllowFAllocate(long var1, boolean var3);

    private native boolean allowFAllocate(long var1);

    private native void setAllowMmapReads(long var1, boolean var3);

    private native boolean allowMmapReads(long var1);

    private native void setAllowMmapWrites(long var1, boolean var3);

    private native boolean allowMmapWrites(long var1);

    private native void setIsFdCloseOnExec(long var1, boolean var3);

    private native boolean isFdCloseOnExec(long var1);

    private native void setStatsDumpPeriodSec(long var1, int var3);

    private native int statsDumpPeriodSec(long var1);

    private native void setAdviseRandomOnOpen(long var1, boolean var3);

    private native boolean adviseRandomOnOpen(long var1);

    private native void setDbWriteBufferSize(long var1, long var3);

    private native long dbWriteBufferSize(long var1);

    private native void setAccessHintOnCompactionStart(long var1, byte var3);

    private native byte accessHintOnCompactionStart(long var1);

    private native void setNewTableReaderForCompactionInputs(long var1, boolean var3);

    private native boolean newTableReaderForCompactionInputs(long var1);

    private native void setCompactionReadaheadSize(long var1, long var3);

    private native long compactionReadaheadSize(long var1);

    private native void setRandomAccessMaxBufferSize(long var1, long var3);

    private native long randomAccessMaxBufferSize(long var1);

    private native void setWritableFileMaxBufferSize(long var1, long var3);

    private native long writableFileMaxBufferSize(long var1);

    private native void setUseAdaptiveMutex(long var1, boolean var3);

    private native boolean useAdaptiveMutex(long var1);

    private native void setBytesPerSync(long var1, long var3);

    private native long bytesPerSync(long var1);

    private native void setWalBytesPerSync(long var1, long var3);

    private native long walBytesPerSync(long var1);

    private native void setEnableThreadTracking(long var1, boolean var3);

    private native boolean enableThreadTracking(long var1);

    private native void setDelayedWriteRate(long var1, long var3);

    private native long delayedWriteRate(long var1);

    private native void setAllowConcurrentMemtableWrite(long var1, boolean var3);

    private native boolean allowConcurrentMemtableWrite(long var1);

    private native void setEnableWriteThreadAdaptiveYield(long var1, boolean var3);

    private native boolean enableWriteThreadAdaptiveYield(long var1);

    private native void setWriteThreadMaxYieldUsec(long var1, long var3);

    private native long writeThreadMaxYieldUsec(long var1);

    private native void setWriteThreadSlowYieldUsec(long var1, long var3);

    private native long writeThreadSlowYieldUsec(long var1);

    private native void setSkipStatsUpdateOnDbOpen(long var1, boolean var3);

    private native boolean skipStatsUpdateOnDbOpen(long var1);

    private native void setWalRecoveryMode(long var1, byte var3);

    private native byte walRecoveryMode(long var1);

    private native void setAllow2pc(long var1, boolean var3);

    private native boolean allow2pc(long var1);

    private native void setRowCache(long var1, long var3);

    private native void setFailIfOptionsFileError(long var1, boolean var3);

    private native boolean failIfOptionsFileError(long var1);

    private native void setDumpMallocStats(long var1, boolean var3);

    private native boolean dumpMallocStats(long var1);

    private native void setAvoidFlushDuringRecovery(long var1, boolean var3);

    private native boolean avoidFlushDuringRecovery(long var1);

    private native void setAvoidFlushDuringShutdown(long var1, boolean var3);

    private native boolean avoidFlushDuringShutdown(long var1);

    static {
        RocksDB.loadLibrary();
    }
}

