/*
 * Status.java February 2007
 *
 * Copyright (C) 2007, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */

package org.simpleframework.transport;

/**
 * The <code>Status</code> enumeration is used to determine what
 * action is required within a negotiation. This allows the
 * negotiation to control the selection for read and write ready
 * operations. Also, status signals completion of the handshake.
 * 
 * @author Niall Gallagher
 */
enum Status {
   
   /**
    * Tells the negotiation that a read operations is needed.
    */
   CLIENT,
   
   /**
    * Tells the negotiation that a write operation is required.
    */
   SERVER,
   
   /**
    * Tells the negotiation that the the handshake is complete. 
    */
   DONE
}