/*
 * ContractQueue.java May 2004
 *
 * Copyright (C) 2004, Niall Gallagher <niallg@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General 
 * Public License along with this library; if not, write to the 
 * Free Software Foundation, Inc., 59 Temple Place, Suite 330, 
 * Boston, MA  02111-1307  USA
 */

package org.simpleframework.util.lease;

import java.util.concurrent.DelayQueue;

/**
 * The <code>ContraceQueue</code> object is used to queue contracts
 * between two asynchronous threads of execution. This allows the
 * controller to schedule the lease contract for expiry. Taking the
 * contracts from the queue is delayed for the contract duration.
 * 
 * @author Niall Gallagher
 * 
 * @see org.simpleframework.util.lease.Contract
 */
class ContractQueue<T> extends DelayQueue<Contract<T>> {
   
   /**
    * Constructor for the <code>ContractQueue</code> object. This
    * is used to create a queue for passing contracts between two
    * asynchronous threads of execution. This is used by the 
    * lease controller to schedule the lease contract for expiry.    
    */
    public  ContractQueue() {
      super();
    }
}
