/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.java;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.sonar.api.Plugin;
import org.sonar.api.SonarProduct;
import org.sonar.api.config.PropertyDefinition;
import org.sonar.api.utils.Version;
import org.sonar.java.DefaultJavaResourceLocator;
import org.sonar.java.JavaClasspath;
import org.sonar.java.JavaClasspathProperties;
import org.sonar.java.JavaTestClasspath;
import org.sonar.java.SonarComponents;
import org.sonar.java.filters.PostAnalysisIssueFilter;
import org.sonar.plugins.jacoco.JaCoCoExtensions;
import org.sonar.plugins.java.Java;
import org.sonar.plugins.java.JavaRulesDefinition;
import org.sonar.plugins.java.JavaSonarWayProfile;
import org.sonar.plugins.java.JavaSquidSensor;
import org.sonar.plugins.java.XmlFileSensor;
import org.sonar.plugins.surefire.SurefireExtensions;

public class JavaPlugin
implements Plugin {
    private static final Version SQ_6_0 = Version.create((int)6, (int)0);

    public void define(Plugin.Context context) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Version sonarQubeVersion = context.getSonarQubeVersion();
        if (!sonarQubeVersion.isGreaterThanOrEqual(SQ_6_0) || context.getRuntime().getProduct() != SonarProduct.SONARLINT) {
            builder.addAll((Iterable)SurefireExtensions.getExtensions());
            builder.addAll((Iterable)JaCoCoExtensions.getExtensions((Version)sonarQubeVersion));
        }
        builder.addAll((Iterable)JavaClasspathProperties.getProperties());
        builder.add(new Object[]{JavaClasspath.class, JavaTestClasspath.class, Java.class, PropertyDefinition.builder((String)"sonar.java.file.suffixes").defaultValue(".java,.jav").name("File suffixes").description("Comma-separated list of suffixes for files to analyze. To not filter, leave the list empty.").subCategory("General").onQualifiers("TRK", new String[0]).build(), JavaRulesDefinition.class, JavaSonarWayProfile.class, SonarComponents.class, DefaultJavaResourceLocator.class, JavaSquidSensor.class, PostAnalysisIssueFilter.class, XmlFileSensor.class});
        context.addExtensions((Collection)builder.build());
    }
}

