/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.cfg;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sonar.javascript.cfg.CfgBlock;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;

class JsCfgBlock
implements CfgBlock {
    private Set<JsCfgBlock> predecessors = new HashSet<JsCfgBlock>();
    private JsCfgBlock successor;
    private LinkedList<Tree> elements = new LinkedList();
    private final Set<SyntaxToken> disconnectingJumps = new HashSet<SyntaxToken>();

    JsCfgBlock(JsCfgBlock successor) {
        Preconditions.checkArgument((successor != null ? 1 : 0) != 0, (Object)"Successor cannot be null");
        this.successor = successor;
    }

    JsCfgBlock() {
    }

    @Override
    public Set<CfgBlock> predecessors() {
        return Collections.unmodifiableSet(this.predecessors);
    }

    @Override
    public Set<CfgBlock> successors() {
        return ImmutableSet.of((Object)this.successor);
    }

    @Override
    public List<Tree> elements() {
        return Collections.unmodifiableList(this.elements);
    }

    public void addElement(Tree element) {
        Preconditions.checkArgument((element != null ? 1 : 0) != 0, (Object)"Cannot add a null element to a block");
        this.elements.addFirst(element);
    }

    void addPredecessor(JsCfgBlock predecessor) {
        this.predecessors.add(predecessor);
    }

    public void replaceSuccessors(Map<JsCfgBlock, JsCfgBlock> replacements) {
        this.successor = JsCfgBlock.replacement(this.successor, replacements);
    }

    static JsCfgBlock replacement(JsCfgBlock successor, Map<JsCfgBlock, JsCfgBlock> replacements) {
        JsCfgBlock newSuccessor = replacements.get(successor);
        return newSuccessor == null ? successor : newSuccessor;
    }

    Set<SyntaxToken> disconnectingJumps() {
        return this.disconnectingJumps;
    }

    void addDisconnectingJump(SyntaxToken jumpToken) {
        this.disconnectingJumps.add(jumpToken);
    }

    JsCfgBlock skipEmptyBlocks() {
        JsCfgBlock block = this;
        while (block.successors().size() == 1 && block.elements().isEmpty()) {
            block = (JsCfgBlock)block.successors().iterator().next();
        }
        return block;
    }
}

