/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sonar.javascript.se.Type;

public class Constraint {
    private int bitSet;
    public static final Constraint ANY_VALUE = Constraint.anyValue();
    public static final Constraint NO_POSSIBLE_VALUE = ANY_VALUE.not();
    public static final Constraint NULL = new Constraint(ValueSubSet.NULL);
    public static final Constraint UNDEFINED = new Constraint(ValueSubSet.UNDEFINED);
    public static final Constraint ZERO = new Constraint(ValueSubSet.ZERO);
    public static final Constraint EMPTY_STRING_PRIMITIVE = new Constraint(ValueSubSet.EMPTY_STRING);
    public static final Constraint NAN = new Constraint(ValueSubSet.NAN);
    public static final Constraint FALSE = new Constraint(ValueSubSet.FALSE);
    public static final Constraint TRUE = new Constraint(ValueSubSet.TRUE);
    public static final Constraint FUNCTION = new Constraint(ValueSubSet.FUNCTION);
    public static final Constraint POSITIVE_NUMBER_PRIMITIVE = new Constraint(ValueSubSet.POSITIVE_NUMBER);
    public static final Constraint NEGATIVE_NUMBER_PRIMITIVE = new Constraint(ValueSubSet.NEGATIVE_NUMBER);
    public static final Constraint TRUTHY_STRING_PRIMITIVE = new Constraint(ValueSubSet.TRUTHY_STRING);
    public static final Constraint ARRAY = new Constraint(ValueSubSet.ARRAY);
    public static final Constraint DATE = new Constraint(ValueSubSet.DATE);
    public static final Constraint REGEXP = new Constraint(ValueSubSet.REGEXP);
    public static final Constraint STRING_OBJECT = new Constraint(ValueSubSet.STRING_OBJECT);
    public static final Constraint NUMBER_OBJECT = new Constraint(ValueSubSet.NUMBER_OBJECT);
    public static final Constraint BOOLEAN_OBJECT = new Constraint(ValueSubSet.BOOLEAN_OBJECT);
    public static final Constraint OTHER_OBJECT = new Constraint(ValueSubSet.OTHER_OBJECT);
    public static final Constraint NULL_OR_UNDEFINED = NULL.or(UNDEFINED);
    public static final Constraint TRUTHY_NUMBER_PRIMITIVE = Constraint.or(POSITIVE_NUMBER_PRIMITIVE, NEGATIVE_NUMBER_PRIMITIVE);
    public static final Constraint KNOWN_OBJECTS = Constraint.or(FUNCTION, ARRAY, DATE, REGEXP, STRING_OBJECT, NUMBER_OBJECT, BOOLEAN_OBJECT);
    public static final Constraint NOT_NULLY = NULL_OR_UNDEFINED.not();
    public static final Constraint TRUTHY = Constraint.or(TRUE, TRUTHY_NUMBER_PRIMITIVE, TRUTHY_STRING_PRIMITIVE, KNOWN_OBJECTS, OTHER_OBJECT);
    public static final Constraint FALSY = TRUTHY.not();
    public static final Constraint NUMBER_PRIMITIVE = Constraint.or(ZERO, NAN, TRUTHY_NUMBER_PRIMITIVE);
    public static final Constraint ANY_NUMBER = Constraint.or(NUMBER_PRIMITIVE, NUMBER_OBJECT);
    public static final Constraint STRING_PRIMITIVE = Constraint.or(EMPTY_STRING_PRIMITIVE, TRUTHY_STRING_PRIMITIVE);
    public static final Constraint ANY_STRING = Constraint.or(STRING_PRIMITIVE, STRING_OBJECT);
    public static final Constraint BOOLEAN_PRIMITIVE = Constraint.or(TRUE, FALSE);
    public static final Constraint ANY_BOOLEAN = Constraint.or(BOOLEAN_PRIMITIVE, BOOLEAN_OBJECT);
    public static final Constraint OBJECT = Constraint.or(KNOWN_OBJECTS, OTHER_OBJECT);
    private static final Map<Constraint, String> COMMON_CONSTRAINT_NAMES = ImmutableMap.builder().put((Object)ANY_VALUE, (Object)"ANY_VALUE").put((Object)NO_POSSIBLE_VALUE, (Object)"NO_POSSIBLE_VALUE").put((Object)TRUTHY, (Object)"TRUTHY").put((Object)FALSY, (Object)"FALSY").put((Object)NOT_NULLY, (Object)"NOT_NULLY").build();
    private static final Map<Constraint, Range<Integer>> NUMERIC_RANGES = ImmutableMap.builder().put((Object)POSITIVE_NUMBER_PRIMITIVE, (Object)Range.greaterThan((Comparable)Integer.valueOf(0))).put((Object)POSITIVE_NUMBER_PRIMITIVE.or(ZERO), (Object)Range.atLeast((Comparable)Integer.valueOf(0))).put((Object)NEGATIVE_NUMBER_PRIMITIVE.or(ZERO), (Object)Range.atMost((Comparable)Integer.valueOf(0))).put((Object)NEGATIVE_NUMBER_PRIMITIVE, (Object)Range.lessThan((Comparable)Integer.valueOf(0))).put((Object)ZERO, (Object)Range.singleton((Comparable)Integer.valueOf(0))).build();
    private static final Set<Constraint> SINGLE_VALUE_CONSTRAINTS = new HashSet<Constraint>();

    private Constraint(ValueSubSet subSet) {
        this(subSet.bitSet());
    }

    private Constraint(int bitSet) {
        this.bitSet = bitSet;
    }

    private static Constraint get(int bitSet) {
        return new Constraint(bitSet);
    }

    private static Constraint anyValue() {
        int bitSet = 0;
        for (ValueSubSet subSet : ValueSubSet.values()) {
            bitSet |= subSet.bitSet();
        }
        return new Constraint(bitSet);
    }

    private static Constraint or(Constraint ... constraints) {
        Preconditions.checkArgument((constraints.length > 0 ? 1 : 0) != 0);
        Constraint constraint = constraints[0];
        for (int i = 1; i < constraints.length; ++i) {
            constraint = constraint.or(constraints[i]);
        }
        return constraint;
    }

    public Constraint and(Constraint other) {
        return Constraint.get(this.bitSet & other.bitSet);
    }

    public Constraint or(Constraint other) {
        return Constraint.get(this.bitSet | other.bitSet);
    }

    public Constraint not() {
        return Constraint.get(~this.bitSet & Constraint.ANY_VALUE.bitSet);
    }

    public Type type() {
        return Type.find(this);
    }

    public Optional<Range<Integer>> numericRange() {
        if (NUMERIC_RANGES.containsKey(this)) {
            return Optional.of(NUMERIC_RANGES.get(this));
        }
        return Optional.empty();
    }

    public boolean isSingleValue() {
        return SINGLE_VALUE_CONSTRAINTS.contains(this);
    }

    public Set<Type> typeSet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Type type : Type.values()) {
            if (this.isIncompatibleWith(type.constraint())) continue;
            builder.add((Object)type);
        }
        return builder.build();
    }

    public boolean isStricterOrEqualTo(Constraint other) {
        return this.and(other).equals(this);
    }

    public boolean isIncompatibleWith(Constraint other) {
        return this.and(other).equals(NO_POSSIBLE_VALUE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Constraint that = (Constraint)o;
        return this.bitSet == that.bitSet;
    }

    public int hashCode() {
        return this.bitSet;
    }

    public String toString() {
        String name = COMMON_CONSTRAINT_NAMES.get(this);
        if (name != null) {
            return name;
        }
        StringBuilder result = new StringBuilder();
        for (ValueSubSet subSet : ValueSubSet.values()) {
            if ((this.bitSet & subSet.bitSet()) != subSet.bitSet()) continue;
            result.append("|").append((Object)subSet);
        }
        return result.substring(1);
    }

    static {
        SINGLE_VALUE_CONSTRAINTS.add(ZERO);
        SINGLE_VALUE_CONSTRAINTS.add(TRUE);
        SINGLE_VALUE_CONSTRAINTS.add(FALSE);
        SINGLE_VALUE_CONSTRAINTS.add(EMPTY_STRING_PRIMITIVE);
    }

    private static enum ValueSubSet {
        NULL,
        UNDEFINED,
        ZERO,
        EMPTY_STRING,
        NAN,
        FALSE,
        TRUE,
        FUNCTION,
        NEGATIVE_NUMBER,
        POSITIVE_NUMBER,
        TRUTHY_STRING,
        ARRAY,
        DATE,
        REGEXP,
        STRING_OBJECT,
        NUMBER_OBJECT,
        BOOLEAN_OBJECT,
        OTHER_OBJECT;


        private int bitSet() {
            return 1 << this.ordinal();
        }
    }
}

