/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ExpressionStack;
import org.sonar.javascript.se.ProgramStateConstraints;
import org.sonar.javascript.se.Relation;
import org.sonar.javascript.se.RelationOnSymbols;
import org.sonar.javascript.se.SymbolicExecution;
import org.sonar.javascript.se.builtins.BuiltInObjectSymbolicValue;
import org.sonar.javascript.se.sv.FunctionWithTreeSymbolicValue;
import org.sonar.javascript.se.sv.SimpleSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

public class ProgramState
implements ProgramStateConstraints {
    private final ImmutableMap<Symbol, SymbolicValue> values;
    private final ImmutableMap<SymbolicValue, Constraint> constraints;
    private final ExpressionStack stack;
    private final ImmutableSet<Relation> relations;
    private int counter;

    private ProgramState(ImmutableMap<Symbol, SymbolicValue> values, ImmutableMap<SymbolicValue, Constraint> constraints, ExpressionStack stack, ImmutableSet<Relation> relations, int counter) {
        HashSet<SymbolicValue> allReferencedValues = new HashSet<SymbolicValue>((Collection<SymbolicValue>)values.values());
        if (!stack.isEmpty()) {
            allReferencedValues.add(stack.peek());
        }
        ImmutableMap.Builder constraintsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : constraints.entrySet()) {
            if (!allReferencedValues.contains(entry.getKey())) continue;
            constraintsBuilder.put(entry.getKey(), entry.getValue());
        }
        ImmutableSet.Builder relationsBuilder = ImmutableSet.builder();
        for (Relation relation : relations) {
            if (!allReferencedValues.containsAll(relation.operands())) continue;
            relationsBuilder.add((Object)relation);
        }
        this.values = values;
        this.constraints = constraintsBuilder.build();
        this.stack = stack;
        this.relations = relationsBuilder.build();
        this.counter = counter;
    }

    public ImmutableMap<Symbol, SymbolicValue> values() {
        return this.values;
    }

    public static ProgramState emptyState() {
        return new ProgramState((ImmutableMap<Symbol, SymbolicValue>)ImmutableMap.of(), (ImmutableMap<SymbolicValue, Constraint>)ImmutableMap.of(), ExpressionStack.emptyStack(), (ImmutableSet<Relation>)ImmutableSet.of(), 0);
    }

    private ProgramState addConstraint(SymbolicValue value, Constraint constraint) {
        if (this.constraints.containsKey((Object)value)) {
            throw new IllegalStateException();
        }
        ImmutableMap.Builder constraintsBuilder = ImmutableMap.builder();
        constraintsBuilder.putAll(this.constraints);
        constraintsBuilder.put((Object)value, (Object)constraint);
        return new ProgramState((ImmutableMap<Symbol, SymbolicValue>)ImmutableMap.copyOf(this.values), (ImmutableMap<SymbolicValue, Constraint>)constraintsBuilder.build(), this.stack, this.relations, this.counter);
    }

    public ProgramState newSymbolicValue(Symbol symbol, @Nullable Constraint constraint) {
        SymbolicValue value = this.newSymbolicValue();
        ProgramState newProgramState = new ProgramState(ProgramState.updateValue(this.values, symbol, value), (ImmutableMap<SymbolicValue, Constraint>)ImmutableMap.copyOf(this.constraints), this.stack, this.relations, this.counter);
        if (constraint != null) {
            newProgramState = newProgramState.addConstraint(value, constraint);
        }
        return newProgramState;
    }

    public ProgramState newFunctionSymbolicValue(Symbol symbol, FunctionTree functionTree) {
        FunctionWithTreeSymbolicValue value = new FunctionWithTreeSymbolicValue(functionTree);
        return new ProgramState(ProgramState.updateValue(this.values, symbol, value), (ImmutableMap<SymbolicValue, Constraint>)ImmutableMap.copyOf(this.constraints), this.stack, this.relations, this.counter);
    }

    private static ImmutableMap<Symbol, SymbolicValue> updateValue(ImmutableMap<Symbol, SymbolicValue> values, Symbol symbol, SymbolicValue newValue) {
        ImmutableMap.Builder valuesBuilder = ImmutableMap.builder();
        for (Map.Entry entry : values.entrySet()) {
            if (((Symbol)entry.getKey()).equals(symbol)) continue;
            valuesBuilder.put(entry.getKey(), entry.getValue());
        }
        valuesBuilder.put((Object)symbol, (Object)newValue);
        return valuesBuilder.build();
    }

    public Optional<ProgramState> constrain(@Nullable SymbolicValue value, @Nullable Constraint constraint) {
        Optional<ProgramState> ps = this.constrainWithoutEquivalent(value, constraint);
        if (ps.isPresent()) {
            Constraint newConstraint = ps.get().getConstraint(value);
            Set<SymbolicValue> equivalentValues = this.getEquivalentValues(value);
            for (SymbolicValue equivalentValue : equivalentValues) {
                if (!ps.isPresent()) break;
                ps = ps.get().constrainWithoutEquivalent(equivalentValue, newConstraint);
            }
        }
        return ps;
    }

    private Optional<ProgramState> constrainWithoutEquivalent(@Nullable SymbolicValue value, @Nullable Constraint constraint) {
        if (value == null || constraint == null || value.equals(UnknownSymbolicValue.UNKNOWN)) {
            return Optional.of(this);
        }
        if (this.getConstraint(value).isIncompatibleWith(constraint)) {
            return Optional.empty();
        }
        Constraint newConstraint = this.getConstraint(value).and(constraint);
        ProgramState newState = new ProgramState(this.values, this.replaceConstraint(value, newConstraint), this.stack, this.relations, this.counter);
        return value.constrainDependencies(newState, constraint);
    }

    private Set<SymbolicValue> getEquivalentValues(@Nullable SymbolicValue value) {
        HashSet<SymbolicValue> equivalentValues = new HashSet<SymbolicValue>();
        for (Relation relation : this.relations) {
            if (relation.operator() != Relation.Operator.STRICT_EQUAL_TO) continue;
            if (relation.leftOperand().equals(value)) {
                equivalentValues.add(relation.rightOperand());
                continue;
            }
            if (!relation.rightOperand().equals(value)) continue;
            equivalentValues.add(relation.leftOperand());
        }
        return equivalentValues;
    }

    private ImmutableMap<SymbolicValue, Constraint> replaceConstraint(SymbolicValue value, Constraint newConstraint) {
        ImmutableMap.Builder constraintsBuilder = ImmutableMap.builder();
        for (Map.Entry entry : this.constraints.entrySet()) {
            if (((SymbolicValue)entry.getKey()).equals(value)) continue;
            constraintsBuilder.put(entry.getKey(), entry.getValue());
        }
        constraintsBuilder.put((Object)value, (Object)newConstraint);
        return constraintsBuilder.build();
    }

    private SymbolicValue newSymbolicValue() {
        SimpleSymbolicValue value = new SimpleSymbolicValue(this.counter);
        ++this.counter;
        return value;
    }

    @CheckForNull
    public SymbolicValue getSymbolicValue(@Nullable Symbol symbol) {
        return (SymbolicValue)this.values.get((Object)symbol);
    }

    @Override
    public Constraint getConstraint(@Nullable SymbolicValue value) {
        Constraint storedConstraint = (Constraint)this.constraints.get((Object)value);
        storedConstraint = storedConstraint == null ? Constraint.ANY_VALUE : storedConstraint;
        return value == null ? storedConstraint : storedConstraint.and(value.baseConstraint(this));
    }

    public Constraint getConstraint(@Nullable Symbol symbol) {
        return this.getConstraint(this.getSymbolicValue(symbol));
    }

    private Map<Symbol, Constraint> constraintsBySymbol() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry entry : this.values.entrySet()) {
            Constraint constraint = this.getConstraint((SymbolicValue)entry.getValue());
            if (constraint == null) continue;
            builder.put(entry.getKey(), (Object)constraint);
        }
        return builder.build();
    }

    private Map<Symbol, FunctionTree> functionsBySymbol() {
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        for (Map.Entry entry : this.values.entrySet()) {
            if (!(entry.getValue() instanceof FunctionWithTreeSymbolicValue)) continue;
            builder.put(entry.getKey(), (Object)((FunctionWithTreeSymbolicValue)entry.getValue()).getFunctionTree());
        }
        return builder.build();
    }

    public ProgramState pushToStack(SymbolicValue value) {
        return new ProgramState(this.values, this.constraints, this.stack.push(value), this.relations, this.counter);
    }

    public ProgramState removeLastValue() {
        return new ProgramState(this.values, this.constraints, this.stack.removeLastValue(), this.relations, this.counter);
    }

    public ProgramState clearStack(Tree element) {
        Preconditions.checkState((this.stack.size() == 1 ? 1 : 0) != 0, (String)"Stack should contain only one element before being cleaned at line %s: %s", (Object[])new Object[]{ProgramState.line(element), this.stack});
        return new ProgramState(this.values, this.constraints, ExpressionStack.emptyStack(), this.relations, this.counter);
    }

    public void assertEmptyStack(Tree element) {
        Preconditions.checkState((boolean)this.stack.isEmpty(), (String)"Stack should be empty at line %s: %s", (Object[])new Object[]{ProgramState.line(element), this.stack});
    }

    private static int line(Tree element) {
        return element.firstToken().line();
    }

    public ProgramState execute(ExpressionTree expression) {
        return new ProgramState(this.values, this.constraints, this.stack.execute(expression, this), this.relations, this.counter);
    }

    public ProgramState withStack(ExpressionStack newStack) {
        return new ProgramState(this.values, this.constraints, newStack, this.relations, this.counter);
    }

    public ProgramState assignment(Symbol variable) {
        SymbolicValue value = this.stack.peek();
        ExpressionStack newStack = this.stack;
        if (UnknownSymbolicValue.UNKNOWN.equals(value)) {
            value = this.newSymbolicValue();
            newStack = newStack.removeLastValue();
            newStack = newStack.push(value);
        }
        HashMap<Symbol, SymbolicValue> newValues = new HashMap<Symbol, SymbolicValue>((Map<Symbol, SymbolicValue>)this.values);
        newValues.put(variable, value);
        return new ProgramState((ImmutableMap<Symbol, SymbolicValue>)ImmutableMap.copyOf(newValues), this.constraints, newStack, this.relations, this.counter);
    }

    public ProgramState assignment(Symbol variable, SymbolicValue value) {
        HashMap<Symbol, SymbolicValue> newValues = new HashMap<Symbol, SymbolicValue>((Map<Symbol, SymbolicValue>)this.values);
        newValues.put(variable, value);
        return new ProgramState((ImmutableMap<Symbol, SymbolicValue>)ImmutableMap.copyOf(newValues), this.constraints, this.stack, this.relations, this.counter);
    }

    public Set<Relation> relations() {
        return this.relations;
    }

    public ProgramState addRelation(Relation relation) {
        ImmutableSet newRelations = ImmutableSet.builder().addAll(this.relations).add((Object)relation).build();
        return new ProgramState(this.values, this.constraints, this.stack, (ImmutableSet<Relation>)newRelations, this.counter);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramState that = (ProgramState)o;
        return Objects.equals(this.constraintsBySymbol(), that.constraintsBySymbol()) && Objects.equals(this.stack, that.stack) && Objects.equals(this.constraintOnPeek(), that.constraintOnPeek()) && Objects.equals(this.functionsBySymbol(), that.functionsBySymbol()) && Objects.equals(this.relationsOnSymbols(), that.relationsOnSymbols());
    }

    public int hashCode() {
        return Objects.hash(this.constraintsBySymbol(), this.stack, this.constraintOnPeek(), this.relationsOnSymbols(), this.functionsBySymbol());
    }

    private Set<RelationOnSymbols> relationsOnSymbols() {
        HashMultimap symbolsByValue = HashMultimap.create();
        for (Map.Entry entry : this.values.entrySet()) {
            symbolsByValue.put(entry.getValue(), entry.getKey());
        }
        HashSet<RelationOnSymbols> relationsOnSymbols = new HashSet<RelationOnSymbols>();
        for (Relation relation : this.relations) {
            for (Symbol leftOperand : symbolsByValue.get((Object)relation.leftOperand())) {
                for (Symbol rightOperand : symbolsByValue.get((Object)relation.rightOperand())) {
                    relationsOnSymbols.add(new RelationOnSymbols(relation.operator(), leftOperand, rightOperand));
                }
            }
        }
        return relationsOnSymbols;
    }

    @CheckForNull
    private Constraint constraintOnPeek() {
        if (this.stack.isEmpty()) {
            return null;
        }
        return this.getConstraint(this.peekStack());
    }

    public SymbolicValue peekStack() {
        return this.stack.peek();
    }

    public SymbolicValue peekStack(int n) {
        return this.stack.peek(n);
    }

    public ProgramState removeSymbols(Set<Symbol> symbolsToKeep) {
        Map newValues = Maps.filterKeys(this.values, (Predicate)Predicates.in(symbolsToKeep));
        return new ProgramState((ImmutableMap<Symbol, SymbolicValue>)ImmutableMap.copyOf((Map)newValues), this.constraints, this.stack, this.relations, this.counter);
    }

    @Deprecated
    public ExpressionStack getStack() {
        return this.stack;
    }

    public String toString() {
        return "[" + this.values + ";" + this.constraints + ";" + this.stack + ";" + this.relations + "]";
    }

    @Nullable
    public SymbolicValue getSymbolicValue(IdentifierTree identifier, SymbolicExecution execution) {
        Symbol symbol = execution.trackedVariable(identifier);
        if (symbol != null) {
            return this.getSymbolicValue(symbol);
        }
        return BuiltInObjectSymbolicValue.find(identifier.name()).orElse(null);
    }
}

