/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.sonar.javascript.cfg.ControlFlowGraph;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SeCheck;
import org.sonar.javascript.se.SymbolicExecution;
import org.sonar.javascript.tree.symbols.Scope;
import org.sonar.plugins.javascript.api.tree.ScriptTree;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.declaration.FunctionTree;
import org.sonar.plugins.javascript.api.tree.statement.BlockTree;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.SubscriptionVisitorCheck;
import org.sonar.plugins.javascript.api.visitors.TreeVisitorContext;

public class SeChecksDispatcher
extends SubscriptionVisitorCheck {
    private List<SeCheck> checks;

    public SeChecksDispatcher(List<SeCheck> checks) {
        this.checks = checks;
    }

    @Override
    public Set<Tree.Kind> nodesToVisit() {
        return ImmutableSet.of((Object)Tree.Kind.SCRIPT, (Object)Tree.Kind.FUNCTION_DECLARATION, (Object)Tree.Kind.GENERATOR_DECLARATION, (Object)Tree.Kind.FUNCTION_EXPRESSION, (Object)Tree.Kind.GENERATOR_FUNCTION_EXPRESSION, (Object)Tree.Kind.METHOD, (Object[])new Tree.Kind[]{Tree.Kind.GENERATOR_METHOD, Tree.Kind.ARROW_FUNCTION});
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(Tree.Kind.SCRIPT)) {
            this.checks.forEach(seCheck -> seCheck.startOfFile((ScriptTree)tree));
            return;
        }
        FunctionTree functionTree = (FunctionTree)tree;
        if (functionTree.body().is(Tree.Kind.BLOCK)) {
            ControlFlowGraph cfg = ControlFlowGraph.build((BlockTree)functionTree.body());
            Scope functionScope = this.getContext().getSymbolModel().getScope(functionTree);
            new SymbolicExecution(functionScope, cfg, this.checks).visitCfg(ProgramState.emptyState());
        }
    }

    @Override
    public void leaveNode(Tree tree) {
        if (tree.is(Tree.Kind.SCRIPT)) {
            this.checks.forEach(seCheck -> seCheck.endOfFile((ScriptTree)tree));
        }
    }

    @Override
    public List<Issue> scanFile(TreeVisitorContext context) {
        if (this.checks.isEmpty()) {
            return new ArrayList<Issue>();
        }
        for (SeCheck check : this.checks) {
            check.setContext(context);
        }
        super.scanFile(context);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SeCheck check : this.checks) {
            builder.addAll(check.scanFile(this.getContext()));
        }
        return builder.build();
    }
}

