/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.builtins;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.builtins.ArrayBuiltInProperties;
import org.sonar.javascript.se.builtins.BooleanBuiltInProperties;
import org.sonar.javascript.se.builtins.BuiltInConstructorSymbolicValue;
import org.sonar.javascript.se.builtins.BuiltInProperty;
import org.sonar.javascript.se.builtins.DateBuiltInProperties;
import org.sonar.javascript.se.builtins.FunctionBuiltInProperties;
import org.sonar.javascript.se.builtins.MathBuiltInProperties;
import org.sonar.javascript.se.builtins.NumberBuiltInProperties;
import org.sonar.javascript.se.builtins.ObjectBuiltInProperties;
import org.sonar.javascript.se.builtins.RegexpBuiltInProperties;
import org.sonar.javascript.se.builtins.StringBuiltInProperties;
import org.sonar.javascript.se.sv.BuiltInFunctionSymbolicValue;
import org.sonar.javascript.se.sv.ObjectSymbolicValue;
import org.sonar.javascript.se.sv.SpecialSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;

public class BuiltInObjectSymbolicValue
implements ObjectSymbolicValue {
    public static final BuiltInObjectSymbolicValue OBJECT_PROTOTYPE = BuiltInObjectSymbolicValue.create(ObjectBuiltInProperties.PROTOTYPE_PROPERTIES, null, Constraint.OTHER_OBJECT);
    public static final BuiltInObjectSymbolicValue FUNCTION_PROTOTYPE = BuiltInObjectSymbolicValue.create(FunctionBuiltInProperties.PROTOTYPE_PROPERTIES, OBJECT_PROTOTYPE, Constraint.FUNCTION);
    public static final BuiltInObjectSymbolicValue STRING_PROTOTYPE = BuiltInObjectSymbolicValue.create(StringBuiltInProperties.PROTOTYPE_PROPERTIES, OBJECT_PROTOTYPE, Constraint.STRING_OBJECT);
    public static final BuiltInObjectSymbolicValue NUMBER_PROTOTYPE = BuiltInObjectSymbolicValue.create(NumberBuiltInProperties.PROTOTYPE_PROPERTIES, OBJECT_PROTOTYPE, Constraint.NUMBER_OBJECT);
    public static final BuiltInObjectSymbolicValue BOOLEAN_PROTOTYPE = BuiltInObjectSymbolicValue.create(BooleanBuiltInProperties.PROTOTYPE_PROPERTIES, OBJECT_PROTOTYPE, Constraint.BOOLEAN_OBJECT);
    public static final BuiltInObjectSymbolicValue ARRAY_PROTOTYPE = BuiltInObjectSymbolicValue.create(ArrayBuiltInProperties.PROTOTYPE_PROPERTIES, OBJECT_PROTOTYPE, Constraint.ARRAY);
    public static final BuiltInObjectSymbolicValue DATE_PROTOTYPE = BuiltInObjectSymbolicValue.create(DateBuiltInProperties.PROTOTYPE_PROPERTIES, OBJECT_PROTOTYPE, Constraint.DATE);
    public static final BuiltInObjectSymbolicValue REGEXP_PROTOTYPE = BuiltInObjectSymbolicValue.create(RegexpBuiltInProperties.PROTOTYPE_PROPERTIES, OBJECT_PROTOTYPE, Constraint.REGEXP);
    public static final BuiltInObjectSymbolicValue MATH = BuiltInObjectSymbolicValue.create(MathBuiltInProperties.PROPERTIES, OBJECT_PROTOTYPE, Constraint.OTHER_OBJECT);
    public static final BuiltInConstructorSymbolicValue OBJECT = BuiltInConstructorSymbolicValue.constructor(ObjectBuiltInProperties.PROPERTIES, Constraint.OTHER_OBJECT, OBJECT_PROTOTYPE);
    public static final BuiltInConstructorSymbolicValue FUNCTION = BuiltInConstructorSymbolicValue.constructor(FunctionBuiltInProperties.PROPERTIES, Constraint.FUNCTION, FUNCTION_PROTOTYPE);
    public static final BuiltInConstructorSymbolicValue STRING = BuiltInConstructorSymbolicValue.constructor(StringBuiltInProperties.PROPERTIES, Constraint.STRING_PRIMITIVE, STRING_PROTOTYPE);
    public static final BuiltInConstructorSymbolicValue NUMBER = BuiltInConstructorSymbolicValue.constructor(NumberBuiltInProperties.PROPERTIES, Constraint.NUMBER_PRIMITIVE, NUMBER_PROTOTYPE);
    public static final BuiltInConstructorSymbolicValue BOOLEAN = BuiltInConstructorSymbolicValue.constructor(BooleanBuiltInProperties.PROPERTIES, Constraint.BOOLEAN_PRIMITIVE, BOOLEAN_PROTOTYPE);
    public static final BuiltInConstructorSymbolicValue ARRAY = BuiltInConstructorSymbolicValue.constructor(ArrayBuiltInProperties.PROPERTIES, Constraint.ARRAY, ARRAY_PROTOTYPE);
    public static final BuiltInConstructorSymbolicValue DATE = BuiltInConstructorSymbolicValue.constructor(DateBuiltInProperties.PROPERTIES, Constraint.STRING_PRIMITIVE, DATE_PROTOTYPE);
    public static final BuiltInConstructorSymbolicValue REGEXP = BuiltInConstructorSymbolicValue.constructor(RegexpBuiltInProperties.PROPERTIES, Constraint.REGEXP, REGEXP_PROTOTYPE);
    private static final BuiltInFunctionSymbolicValue.ArgumentsConstrainer IS_NAN_ARGUMENT_CONSTRAINER = (arguments, state, constraint) -> {
        boolean truthy = constraint.isStricterOrEqualTo(Constraint.TRUTHY);
        boolean hasArguments = !arguments.isEmpty();
        Constraint alwaysNaN = Constraint.UNDEFINED.or(Constraint.NAN).or(Constraint.FUNCTION).or(Constraint.REGEXP).or(Constraint.OTHER_OBJECT);
        Constraint alwaysNotNaN = Constraint.NULL.or(Constraint.ZERO).or(Constraint.EMPTY_STRING_PRIMITIVE).or(Constraint.ANY_BOOLEAN).or(Constraint.TRUTHY_NUMBER_PRIMITIVE);
        if (truthy && hasArguments) {
            return state.constrain((SymbolicValue)arguments.get(0), alwaysNotNaN.not());
        }
        if (truthy) {
            return Optional.of(state);
        }
        if (!hasArguments) {
            return Optional.empty();
        }
        return state.constrain((SymbolicValue)arguments.get(0), alwaysNaN.not());
    };
    public static final SymbolicValue IS_NAN = new BuiltInFunctionSymbolicValue(Constraint.BOOLEAN_PRIMITIVE, IS_NAN_ARGUMENT_CONSTRAINER, index -> index == 0 ? Constraint.ANY_VALUE : null, false);
    private static final Map<String, SymbolicValue> GLOBALS = ImmutableMap.builder().put((Object)"Object", (Object)OBJECT).put((Object)"Function", (Object)FUNCTION).put((Object)"String", (Object)STRING).put((Object)"Number", (Object)NUMBER).put((Object)"Boolean", (Object)BOOLEAN).put((Object)"Array", (Object)ARRAY).put((Object)"Date", (Object)DATE).put((Object)"RegExp", (Object)REGEXP).put((Object)"Math", (Object)MATH).put((Object)"isNaN", (Object)IS_NAN).put((Object)"NaN", (Object)new SymbolicValueWithConstraint(Constraint.NAN)).build();
    private final Map<String, BuiltInProperty> properties;
    private final BuiltInObjectSymbolicValue prototype;
    private final Constraint baseConstraint;

    BuiltInObjectSymbolicValue(Map<String, BuiltInProperty> properties, @Nullable BuiltInObjectSymbolicValue prototype, Constraint baseConstraint) {
        this.properties = properties;
        this.prototype = prototype;
        this.baseConstraint = baseConstraint;
    }

    public static BuiltInObjectSymbolicValue create(Map<String, BuiltInProperty> properties, BuiltInObjectSymbolicValue prototype, Constraint baseConstraint) {
        return new BuiltInObjectSymbolicValue(properties, prototype, baseConstraint);
    }

    public static Optional<SymbolicValue> find(String name) {
        return Optional.ofNullable(GLOBALS.get(name));
    }

    public Constraint baseConstraint() {
        return this.baseConstraint;
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        return this.baseConstraint();
    }

    @Override
    public SymbolicValue getPropertyValue(String propertyName) {
        BuiltInProperty property = this.properties.get(propertyName);
        if (property != null) {
            return property.access();
        }
        if (this.prototype != null) {
            return this.prototype.getPropertyValue(propertyName);
        }
        return SpecialSymbolicValue.UNDEFINED;
    }

    public BuiltInObjectSymbolicValue prototype() {
        return this.prototype;
    }
}

