/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.points;

import java.util.Optional;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.SymbolicExecution;
import org.sonar.javascript.se.points.LiteralProgramPoint;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.UnknownSymbolicValue;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;

public class IdentifierProgramPoint
implements ProgramPoint {
    private IdentifierTree identifier;
    private SymbolicExecution execution;

    public IdentifierProgramPoint(Tree tree, SymbolicExecution execution) {
        this.identifier = (IdentifierTree)tree;
        this.execution = execution;
    }

    @Override
    public Optional<ProgramState> execute(ProgramState state) {
        SymbolicValue symbolicValue = state.getSymbolicValue(this.identifier, this.execution);
        if (symbolicValue == null) {
            symbolicValue = UnknownSymbolicValue.UNKNOWN;
        }
        return Optional.of(state.pushToStack(symbolicValue));
    }

    public static boolean originatesFrom(Tree element) {
        return element.is(Tree.Kind.IDENTIFIER_REFERENCE) && !LiteralProgramPoint.isUndefined(element);
    }
}

