/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.points;

import java.util.Deque;
import java.util.Optional;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ExpressionStack;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.points.ProgramPoint;
import org.sonar.javascript.se.sv.LiteralSymbolicValue;
import org.sonar.javascript.se.sv.SpecialSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;
import org.sonar.javascript.tree.KindSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.ArrayLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.expression.LiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.ObjectLiteralTree;
import org.sonar.plugins.javascript.api.tree.expression.PairPropertyTree;
import org.sonar.plugins.javascript.api.tree.expression.TemplateLiteralTree;

public class LiteralProgramPoint
implements ProgramPoint {
    private Tree tree;

    public LiteralProgramPoint(Tree tree) {
        this.tree = tree;
    }

    public static boolean originatesFrom(Tree element) {
        return LiteralProgramPoint.isUndefined(element) || element.is(KindSet.LITERAL_KINDS);
    }

    @Override
    public Optional<ProgramState> execute(ProgramState state) {
        ExpressionStack stack = state.getStack();
        ExpressionStack stackAfterExecution = stack.apply(newStack -> {
            SymbolicValue value = SpecialSymbolicValue.UNDEFINED;
            if (this.tree.is(Tree.Kind.NULL_LITERAL)) {
                value = SpecialSymbolicValue.NULL;
            } else if (this.tree.is(Tree.Kind.NUMERIC_LITERAL, Tree.Kind.STRING_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.REGULAR_EXPRESSION_LITERAL)) {
                value = LiteralSymbolicValue.get((LiteralTree)this.tree);
            } else if (this.tree.is(Tree.Kind.ARRAY_LITERAL)) {
                LiteralProgramPoint.pop(newStack, ((ArrayLiteralTree)this.tree).elements().size());
                value = new SymbolicValueWithConstraint(Constraint.ARRAY);
            } else if (this.tree.is(Tree.Kind.OBJECT_LITERAL)) {
                LiteralProgramPoint.popObjectLiteralProperties(newStack, (ObjectLiteralTree)this.tree);
                value = new SymbolicValueWithConstraint(Constraint.OTHER_OBJECT);
            } else if (this.tree.is(Tree.Kind.TEMPLATE_LITERAL)) {
                LiteralProgramPoint.pop(newStack, ((TemplateLiteralTree)this.tree).expressions().size());
                value = new SymbolicValueWithConstraint(Constraint.STRING_PRIMITIVE);
            }
            newStack.push(value);
        });
        return Optional.of(state.withStack(stackAfterExecution));
    }

    static boolean isUndefined(Tree element) {
        return element.is(Tree.Kind.IDENTIFIER_REFERENCE) && "undefined".equals(((IdentifierTree)element).name());
    }

    private static void pop(Deque<SymbolicValue> newStack, int n) {
        for (int i = 0; i < n; ++i) {
            newStack.pop();
        }
    }

    private static void popObjectLiteralProperties(Deque<SymbolicValue> newStack, ObjectLiteralTree objectLiteralTree) {
        for (Tree property : objectLiteralTree.properties()) {
            if (property.is(Tree.Kind.PAIR_PROPERTY)) {
                Tree key = ((PairPropertyTree)property).key();
                if (key.is(Tree.Kind.STRING_LITERAL, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.COMPUTED_PROPERTY_NAME)) {
                    newStack.pop();
                }
            }
            if (property.is(Tree.Kind.GENERATOR_METHOD, Tree.Kind.METHOD, Tree.Kind.SET_METHOD, Tree.Kind.GET_METHOD)) continue;
            newStack.pop();
        }
    }
}

