/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.se.sv;

import java.util.List;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.javascript.se.Constraint;
import org.sonar.javascript.se.ProgramState;
import org.sonar.javascript.se.sv.FunctionSymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValue;
import org.sonar.javascript.se.sv.SymbolicValueWithConstraint;

public class BuiltInFunctionSymbolicValue
implements FunctionSymbolicValue {
    private final Constraint returnedValueConstraint;
    private final ArgumentsConstrainer argumentsConstrainer;
    private final IntFunction<Constraint> signature;
    private final boolean hasSideEffect;

    public BuiltInFunctionSymbolicValue(Constraint returnedValueConstraint, IntFunction<Constraint> signature) {
        this(returnedValueConstraint, null, signature, false);
    }

    public BuiltInFunctionSymbolicValue(Constraint returnedValueConstraint, IntFunction<Constraint> signature, boolean hasSideEffect) {
        this(returnedValueConstraint, null, signature, hasSideEffect);
    }

    public BuiltInFunctionSymbolicValue(Constraint returnedValueConstraint) {
        this(returnedValueConstraint, null, null, false);
    }

    public BuiltInFunctionSymbolicValue(Constraint returnedValueConstraint, @Nullable ArgumentsConstrainer argumentsConstrainer, @Nullable IntFunction<Constraint> signature, boolean hasSideEffect) {
        this.returnedValueConstraint = returnedValueConstraint;
        this.argumentsConstrainer = argumentsConstrainer;
        this.signature = signature;
        this.hasSideEffect = hasSideEffect;
    }

    @Override
    public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
        return Optional.of(state);
    }

    @Override
    public Constraint baseConstraint(ProgramState state) {
        return Constraint.FUNCTION.or(Constraint.UNDEFINED);
    }

    @Override
    public SymbolicValue call(List<SymbolicValue> argumentValues) {
        if (this.argumentsConstrainer == null) {
            return new SymbolicValueWithConstraint(this.returnedValueConstraint);
        }
        return new ReturnSymbolicValue(argumentValues);
    }

    @CheckForNull
    public IntFunction<Constraint> signature() {
        return this.signature;
    }

    public boolean hasSideEffect() {
        return this.hasSideEffect;
    }

    public static class ListSignature
    implements IntFunction<Constraint> {
        private List<Constraint> parameterTypes;

        public ListSignature(List<Constraint> parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        @Override
        public Constraint apply(int parameterIndex) {
            if (parameterIndex < this.parameterTypes.size()) {
                return this.parameterTypes.get(parameterIndex);
            }
            return null;
        }
    }

    private class ReturnSymbolicValue
    implements SymbolicValue {
        List<SymbolicValue> arguments;

        ReturnSymbolicValue(List<SymbolicValue> argumentValues) {
            this.arguments = argumentValues;
        }

        @Override
        public Optional<ProgramState> constrainDependencies(ProgramState state, Constraint constraint) {
            return BuiltInFunctionSymbolicValue.this.argumentsConstrainer.constrain(this.arguments, state, constraint);
        }

        @Override
        public Constraint baseConstraint(ProgramState state) {
            return BuiltInFunctionSymbolicValue.this.returnedValueConstraint;
        }
    }

    @FunctionalInterface
    public static interface ArgumentsConstrainer {
        public Optional<ProgramState> constrain(List<SymbolicValue> var1, ProgramState var2, Constraint var3);
    }
}

