/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.impl.expression;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.sonar.javascript.tree.impl.JavaScriptTree;
import org.sonar.javascript.tree.symbols.type.TypableTree;
import org.sonar.plugins.javascript.api.symbols.Type;
import org.sonar.plugins.javascript.api.symbols.TypeSet;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.tree.expression.DotMemberExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.ExpressionTree;
import org.sonar.plugins.javascript.api.tree.expression.IdentifierTree;
import org.sonar.plugins.javascript.api.tree.lexical.SyntaxToken;
import org.sonar.plugins.javascript.api.visitors.DoubleDispatchVisitor;

public class DotMemberExpressionTreeImpl
extends JavaScriptTree
implements DotMemberExpressionTree,
TypableTree {
    private ExpressionTree object;
    private final SyntaxToken dot;
    private final IdentifierTree property;
    private TypeSet types = TypeSet.emptyTypeSet();

    public DotMemberExpressionTreeImpl(ExpressionTree object, SyntaxToken dot, IdentifierTree property) {
        this.object = object;
        this.dot = dot;
        this.property = property;
    }

    @Override
    public ExpressionTree object() {
        return this.object;
    }

    @Override
    public SyntaxToken dotToken() {
        return this.dot;
    }

    @Override
    public IdentifierTree property() {
        return this.property;
    }

    @Override
    public void add(Type type) {
        this.types.add(type);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.DOT_MEMBER_EXPRESSION;
    }

    @Override
    public TypeSet types() {
        return this.types.immutableCopy();
    }

    @Override
    public Iterator<Tree> childrenIterator() {
        return Iterators.forArray((Object[])new Tree[]{this.object, this.dot, this.property});
    }

    @Override
    public void accept(DoubleDispatchVisitor visitor) {
        visitor.visitMemberExpression(this);
    }
}

