/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.tree.symbols;

import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.plugins.javascript.api.symbols.Symbol;
import org.sonar.plugins.javascript.api.tree.Tree;

public class Scope {
    private Scope outer;
    private final Tree tree;
    protected Map<String, Symbol> symbols = Maps.newHashMap();
    private final boolean isBlock;

    public Scope(Scope outer, Tree tree, boolean isBlock) {
        this.outer = outer;
        this.tree = tree;
        this.isBlock = isBlock;
    }

    public Tree tree() {
        return this.tree;
    }

    public Scope outer() {
        return this.outer;
    }

    public Symbol lookupSymbol(String name) {
        Scope scope = this;
        while (scope != null && !scope.symbols.containsKey(name)) {
            scope = scope.outer;
        }
        return scope == null ? null : scope.symbols.get(name);
    }

    public List<Symbol> getSymbols(Symbol.Kind kind) {
        LinkedList<Symbol> result = new LinkedList<Symbol>();
        for (Symbol symbol : this.symbols.values()) {
            if (!symbol.is(kind)) continue;
            result.add(symbol);
        }
        return result;
    }

    public boolean isGlobal() {
        return this.tree.is(Tree.Kind.SCRIPT);
    }

    public void addSymbol(Symbol symbol) {
        this.symbols.put(symbol.name(), symbol);
    }

    @Nullable
    public Symbol getSymbol(String name) {
        return this.symbols.get(name);
    }

    public boolean isBlock() {
        return this.isBlock;
    }
}

