/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.javascript.visitors;

import java.util.ArrayList;
import java.util.List;
import org.sonar.plugins.javascript.api.JavaScriptCheck;
import org.sonar.plugins.javascript.api.tree.Tree;
import org.sonar.plugins.javascript.api.visitors.Issue;
import org.sonar.plugins.javascript.api.visitors.IssueLocation;
import org.sonar.plugins.javascript.api.visitors.LineIssue;
import org.sonar.plugins.javascript.api.visitors.PreciseIssue;

public class Issues {
    private List<Issue> issueList;
    private JavaScriptCheck check;

    public Issues(JavaScriptCheck check) {
        this.check = check;
        this.issueList = new ArrayList<Issue>();
    }

    public LineIssue addLineIssue(Tree tree, String message) {
        return this.addIssue(new LineIssue(this.check, tree, message));
    }

    public PreciseIssue addIssue(Tree tree, String message) {
        PreciseIssue preciseIssue = new PreciseIssue(this.check, new IssueLocation(tree, message));
        this.addIssue(preciseIssue);
        return preciseIssue;
    }

    public <T extends Issue> T addIssue(T issue) {
        this.issueList.add(issue);
        return issue;
    }

    public List<Issue> getList() {
        return this.issueList;
    }

    public void reset() {
        this.issueList = new ArrayList<Issue>();
    }
}

