/*
 * Copyright 2025-2025 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.ai.model;

public final class SpringAIModels {

	private SpringAIModels() {
		// Avoids instantiation
	}

	public static final String ANTHROPIC = "anthropic";

	public static final String AZURE_OPENAI = "azure-openai";

	public static final String BEDROCK_COHERE = "bedrock-cohere";

	public static final String BEDROCK_CONVERSE = "bedrock-converse";

	public static final String BEDROCK_TITAN = "bedrock-titan";

	public static final String HUGGINGFACE = "huggingface";

	public static final String MINIMAX = "minimax";

	public static final String MISTRAL = "mistral";

	public static final String OCI_GENAI = "oci-genai";

	public static final String OLLAMA = "ollama";

	public static final String OPENAI = "openai";

	public static final String POSTGRESML = "postgresml";

	public static final String STABILITY_AI = "stabilityai";

	public static final String TRANSFORMERS = "transformers";

	public static final String VERTEX_AI = "vertexai";

	public static final String ZHIPUAI = "zhipuai";

	public static final String DEEPSEEK = "deepseek";

}
