/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.core;

import com.couchbase.client.java.codec.RawJsonTranscoder;
import com.couchbase.client.java.codec.Transcoder;
import com.couchbase.client.java.kv.GetAnyReplicaOptions;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.couchbase.core.ReactiveCouchbaseTemplate;
import org.springframework.data.couchbase.core.ReactiveFindFromReplicasByIdOperation;
import org.springframework.data.couchbase.core.ReactiveTemplateSupport;
import org.springframework.data.couchbase.core.TransactionalSupport;
import org.springframework.data.couchbase.core.query.OptionsBuilder;
import org.springframework.data.couchbase.core.support.PseudoArgs;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveFindFromReplicasByIdOperationSupport
implements ReactiveFindFromReplicasByIdOperation {
    private final ReactiveCouchbaseTemplate template;
    private static final Logger LOG = LoggerFactory.getLogger(ReactiveFindFromReplicasByIdOperationSupport.class);

    ReactiveFindFromReplicasByIdOperationSupport(ReactiveCouchbaseTemplate template) {
        this.template = template;
    }

    @Override
    public <T> ReactiveFindFromReplicasByIdOperation.ReactiveFindFromReplicasById<T> findFromReplicasById(Class<T> domainType) {
        return new ReactiveFindFromReplicasByIdSupport<T>(this.template, domainType, domainType, OptionsBuilder.getScopeFrom(domainType), OptionsBuilder.getCollectionFrom(domainType), null, this.template.support());
    }

    static class ReactiveFindFromReplicasByIdSupport<T>
    implements ReactiveFindFromReplicasByIdOperation.ReactiveFindFromReplicasById<T> {
        private final ReactiveCouchbaseTemplate template;
        private final Class<?> domainType;
        private final Class<T> returnType;
        private final String scope;
        private final String collection;
        private final GetAnyReplicaOptions options;
        private final ReactiveTemplateSupport support;

        ReactiveFindFromReplicasByIdSupport(ReactiveCouchbaseTemplate template, Class<?> domainType, Class<T> returnType, String scope, String collection, GetAnyReplicaOptions options, ReactiveTemplateSupport support) {
            this.template = template;
            this.domainType = domainType;
            this.returnType = returnType;
            this.scope = scope;
            this.collection = collection;
            this.options = options;
            this.support = support;
        }

        @Override
        public Mono<T> any(String id) {
            GetAnyReplicaOptions garOptions;
            GetAnyReplicaOptions getAnyReplicaOptions = garOptions = this.options != null ? this.options : GetAnyReplicaOptions.getAnyReplicaOptions();
            if (garOptions.build().transcoder() == null) {
                garOptions.transcoder((Transcoder)RawJsonTranscoder.INSTANCE);
            }
            PseudoArgs<GetAnyReplicaOptions> pArgs = new PseudoArgs<GetAnyReplicaOptions>(this.template, this.scope, this.collection, garOptions, this.domainType);
            if (LOG.isDebugEnabled()) {
                LOG.debug("getAnyReplica key={} {}", (Object)id, pArgs);
            }
            return TransactionalSupport.verifyNotInTransaction("findFromReplicasById").then(Mono.just((Object)id)).flatMap(docId -> this.template.getCouchbaseClientFactory().withScope(pArgs.getScope()).getCollection(pArgs.getCollection()).reactive().getAnyReplica(docId, (GetAnyReplicaOptions)pArgs.getOptions())).flatMap(result -> this.support.decodeEntity(id, (String)result.contentAs(String.class), result.cas(), result.expiryTime().orElse(null), this.returnType, pArgs.getScope(), pArgs.getCollection(), null, null)).onErrorMap(throwable -> {
                if (throwable instanceof RuntimeException) {
                    return this.template.potentiallyConvertRuntimeException((RuntimeException)throwable);
                }
                return throwable;
            });
        }

        @Override
        public Flux<? extends T> any(Collection<String> ids) {
            return Flux.fromIterable(ids).flatMap(this::any);
        }

        @Override
        public ReactiveFindFromReplicasByIdOperation.TerminatingFindFromReplicasById<T> withOptions(GetAnyReplicaOptions options) {
            return new ReactiveFindFromReplicasByIdSupport<T>(this.template, this.domainType, this.returnType, this.scope, this.collection, options != null ? options : this.options, this.support);
        }

        @Override
        public ReactiveFindFromReplicasByIdOperation.FindFromReplicasByIdWithOptions<T> inCollection(String collection) {
            return new ReactiveFindFromReplicasByIdSupport<T>(this.template, this.domainType, this.returnType, this.scope, collection != null ? collection : this.collection, this.options, this.support);
        }

        @Override
        public ReactiveFindFromReplicasByIdOperation.FindFromReplicasByIdInCollection<T> inScope(String scope) {
            return new ReactiveFindFromReplicasByIdSupport<T>(this.template, this.domainType, this.returnType, scope != null ? scope : this.scope, this.collection, this.options, this.support);
        }
    }
}

