/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import java.util.Iterator;
import java.util.Optional;
import org.springframework.data.couchbase.core.convert.CouchbaseConverter;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.core.query.N1QLExpression;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.core.query.QueryCriteria;
import org.springframework.data.couchbase.core.query.StringQuery;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class StringN1qlQueryCreator
extends AbstractQueryCreator<Query, QueryCriteria> {
    private final ParameterAccessor accessor;
    private final MappingContext<?, CouchbasePersistentProperty> context;
    private final ValueExpressionDelegate valueExpressionDelegate;
    private final CouchbaseQueryMethod queryMethod;
    private final CouchbaseConverter couchbaseConverter;
    private final String queryString;

    public StringN1qlQueryCreator(ParameterAccessor accessor, CouchbaseQueryMethod queryMethod, CouchbaseConverter couchbaseConverter, ValueExpressionDelegate valueExpressionDelegate, NamedQueries namedQueries) {
        super(new PartTree("dummy", new Object(){
            String dummy;
        }.getClass()), accessor);
        String qString;
        this.accessor = accessor;
        this.context = couchbaseConverter.getMappingContext();
        this.queryMethod = queryMethod;
        this.couchbaseConverter = couchbaseConverter;
        this.valueExpressionDelegate = valueExpressionDelegate;
        String namedQueryName = queryMethod.getNamedQueryName();
        if (queryMethod.hasInlineN1qlQuery()) {
            qString = queryMethod.getInlineN1qlQuery();
        } else if (namedQueries.hasQuery(namedQueryName)) {
            qString = namedQueries.getQuery(namedQueryName);
        } else {
            throw new IllegalArgumentException("query has no inline Query or named Query not found");
        }
        this.queryString = qString;
    }

    protected QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected String getTypeField() {
        return this.couchbaseConverter.getTypeKey();
    }

    protected Class getType() {
        return this.getQueryMethod().getEntityInformation().getJavaType();
    }

    protected QueryCriteria create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)path.getLeafProperty();
        return this.from(part, property, QueryCriteria.where(N1QLExpression.x(path.toDotPath())), iterator);
    }

    public Query createQuery() {
        Query q = (Query)this.createQuery(Optional.of(this.accessor).map(ParameterAccessor::getSort).orElse(Sort.unsorted()));
        Pageable pageable = this.accessor.getPageable();
        if (pageable.isPaged()) {
            q.skip(pageable.getOffset());
            q.limit(pageable.getPageSize());
        }
        return q;
    }

    protected QueryCriteria and(Part part, QueryCriteria base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        CouchbasePersistentProperty property = (CouchbasePersistentProperty)path.getLeafProperty();
        return this.from(part, property, base.and(N1QLExpression.x(path.toDotPath())), iterator);
    }

    protected QueryCriteria or(QueryCriteria base, QueryCriteria criteria) {
        return base.or(criteria);
    }

    protected Query complete(QueryCriteria criteria, Sort sort) {
        Query q = new StringQuery(this.queryMethod, this.queryString, this.valueExpressionDelegate, this.accessor).with(sort);
        return q;
    }

    private QueryCriteria from(Part part, CouchbasePersistentProperty property, QueryCriteria criteria, Iterator<Object> parameters) {
        Part.Type type = part.getType();
        switch (type) {
            case SIMPLE_PROPERTY: {
                return criteria;
            }
        }
        throw new IllegalArgumentException("Unsupported keyword!");
    }
}

