/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentEntity;
import org.springframework.data.couchbase.core.mapping.CouchbasePersistentProperty;
import org.springframework.data.couchbase.repository.config.RepositoryOperationsMapping;
import org.springframework.data.couchbase.repository.query.CouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.PartTreeCouchbaseQuery;
import org.springframework.data.couchbase.repository.query.StringBasedCouchbaseQuery;
import org.springframework.data.couchbase.repository.support.CrudMethodMetadataPostProcessor;
import org.springframework.data.couchbase.repository.support.MappingCouchbaseEntityInformation;
import org.springframework.data.couchbase.repository.support.QuerydslCouchbasePredicateExecutor;
import org.springframework.data.couchbase.repository.support.SimpleCouchbaseRepository;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryComposition;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.CachingValueExpressionDelegate;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class CouchbaseRepositoryFactory
extends RepositoryFactorySupport {
    private static final SpelExpressionParser SPEL_PARSER = new SpelExpressionParser();
    private final CouchbaseOperations operations;
    private final RepositoryOperationsMapping couchbaseOperationsMapping;
    private final MappingContext<? extends CouchbasePersistentEntity<?>, CouchbasePersistentProperty> mappingContext;
    private final CrudMethodMetadataPostProcessor crudMethodMetadataPostProcessor;

    public CouchbaseRepositoryFactory(RepositoryOperationsMapping couchbaseOperationsMapping) {
        Assert.notNull((Object)couchbaseOperationsMapping, (String)"RepositoryOperationsMapping must not be null!");
        this.couchbaseOperationsMapping = couchbaseOperationsMapping;
        this.crudMethodMetadataPostProcessor = new CrudMethodMetadataPostProcessor();
        this.mappingContext = this.couchbaseOperationsMapping.getMappingContext();
        this.operations = this.couchbaseOperationsMapping.getDefault();
        this.addRepositoryProxyPostProcessor(this.crudMethodMetadataPostProcessor);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        super.setBeanClassLoader(classLoader);
        this.crudMethodMetadataPostProcessor.setBeanClassLoader(classLoader);
    }

    public <T, ID> CouchbaseEntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        CouchbasePersistentEntity entity = (CouchbasePersistentEntity)this.mappingContext.getRequiredPersistentEntity(domainClass);
        return new MappingCouchbaseEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        CouchbaseOperations couchbaseOperations = this.couchbaseOperationsMapping.resolve(metadata.getRepositoryInterface(), metadata.getDomainType());
        EntityInformation entityInformation = this.getEntityInformation(metadata.getDomainType());
        SimpleCouchbaseRepository repository = (SimpleCouchbaseRepository)this.getTargetRepositoryViaReflection(metadata, new Object[]{entityInformation, couchbaseOperations, metadata.getRepositoryInterface()});
        repository.setRepositoryMethodMetadata(this.crudMethodMetadataPostProcessor.getCrudMethodMetadata());
        return repository;
    }

    protected final Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleCouchbaseRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new CouchbaseQueryLookupStrategy(valueExpressionDelegate));
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata) {
        return this.getRepositoryFragments(metadata, this.operations);
    }

    protected RepositoryComposition.RepositoryFragments getRepositoryFragments(RepositoryMetadata metadata, CouchbaseOperations operations) {
        boolean isQueryDslRepository;
        boolean bl = isQueryDslRepository = QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(metadata.getRepositoryInterface());
        if (isQueryDslRepository) {
            if (metadata.isReactiveRepository()) {
                throw new InvalidDataAccessApiUsageException("Cannot combine Querydsl and reactive repository support in a single interface");
            }
            return RepositoryComposition.RepositoryFragments.just((Object[])new Object[]{new QuerydslCouchbasePredicateExecutor(this.getEntityInformation(metadata.getDomainType()), operations)});
        }
        return RepositoryComposition.RepositoryFragments.empty();
    }

    private class CouchbaseQueryLookupStrategy
    implements QueryLookupStrategy {
        private final ValueExpressionDelegate valueExpressionDelegate;

        public CouchbaseQueryLookupStrategy(ValueExpressionDelegate valueExpressionDelegate) {
            this.valueExpressionDelegate = new CachingValueExpressionDelegate(valueExpressionDelegate);
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
            CouchbaseOperations couchbaseOperations = CouchbaseRepositoryFactory.this.couchbaseOperationsMapping.resolve(metadata.getRepositoryInterface(), metadata.getDomainType());
            CouchbaseQueryMethod queryMethod = new CouchbaseQueryMethod(method, metadata, factory, CouchbaseRepositoryFactory.this.mappingContext);
            if (queryMethod.hasN1qlAnnotation()) {
                return new StringBasedCouchbaseQuery(queryMethod, couchbaseOperations, this.valueExpressionDelegate, namedQueries);
            }
            return new PartTreeCouchbaseQuery(queryMethod, couchbaseOperations, this.valueExpressionDelegate);
        }
    }
}

