/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.support;

import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Pageable;

public final class PageableUtils {
    private PageableUtils() {
        throw new IllegalStateException("Cannot instantiate a utility class!");
    }

    public static int getOffsetAsInteger(Pageable pageable) {
        if (pageable.getOffset() > Integer.MAX_VALUE) {
            throw new InvalidDataAccessApiUsageException("Page offset exceeds Integer.MAX_VALUE (2147483647)");
        }
        return Math.toIntExact(pageable.getOffset());
    }
}

