/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.gridfs;

import com.mongodb.client.gridfs.model.GridFSFile;
import org.bson.Document;
import org.bson.types.ObjectId;
import org.jspecify.annotations.Nullable;
import org.reactivestreams.Publisher;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.data.mongodb.gridfs.GridFsObject;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;

public class ReactiveGridFsUpload<ID>
implements GridFsObject<ID, Publisher<DataBuffer>> {
    private final @Nullable ID id;
    private final Publisher<DataBuffer> dataStream;
    private final String filename;
    private final GridFsObject.Options options;

    private ReactiveGridFsUpload(@Nullable ID id, Publisher<DataBuffer> dataStream, String filename, GridFsObject.Options options) {
        Assert.notNull(dataStream, (String)"Data Stream must not be null");
        Assert.notNull((Object)filename, (String)"Filename must not be null");
        Assert.notNull((Object)options, (String)"Options must not be null");
        this.id = id;
        this.dataStream = dataStream;
        this.filename = filename;
        this.options = options;
    }

    @Override
    public @Nullable ID getFileId() {
        return this.id;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public Publisher<DataBuffer> getContent() {
        return this.dataStream;
    }

    @Override
    public GridFsObject.Options getOptions() {
        return this.options;
    }

    public static ReactiveGridFsUploadBuilder<ObjectId> fromPublisher(Publisher<DataBuffer> source) {
        return new ReactiveGridFsUploadBuilder().content(source);
    }

    public static class ReactiveGridFsUploadBuilder<T> {
        private @Nullable Object id;
        private @Nullable Publisher<DataBuffer> dataStream;
        private @Nullable String filename;
        private GridFsObject.Options options = GridFsObject.Options.none();

        private ReactiveGridFsUploadBuilder() {
        }

        @Contract(value="_ -> this")
        public ReactiveGridFsUploadBuilder<T> content(Publisher<DataBuffer> source) {
            this.dataStream = source;
            return this;
        }

        @Contract(value="_ -> this")
        public <T1> ReactiveGridFsUploadBuilder<T1> id(T1 id) {
            this.id = id;
            return this;
        }

        @Contract(value="_ -> this")
        public ReactiveGridFsUploadBuilder<T> filename(String filename) {
            this.filename = filename;
            return this;
        }

        @Contract(value="_ -> this")
        public ReactiveGridFsUploadBuilder<T> options(GridFsObject.Options options) {
            Assert.notNull((Object)options, (String)"Options must not be null");
            this.options = options;
            return this;
        }

        @Contract(value="_ -> this")
        public ReactiveGridFsUploadBuilder<T> metadata(Document metadata) {
            this.options = this.options.metadata(metadata);
            return this;
        }

        @Contract(value="_ -> this")
        public ReactiveGridFsUploadBuilder<T> chunkSize(int chunkSize) {
            this.options = this.options.chunkSize(chunkSize);
            return this;
        }

        @Contract(value="_ -> this")
        public ReactiveGridFsUploadBuilder<T> gridFsFile(GridFSFile gridFSFile) {
            Assert.notNull((Object)gridFSFile, (String)"GridFSFile must not be null");
            this.id = gridFSFile.getId();
            this.filename = gridFSFile.getFilename();
            this.options = this.options.metadata(gridFSFile.getMetadata());
            this.options = this.options.chunkSize(gridFSFile.getChunkSize());
            return this;
        }

        @Contract(value="_ -> this")
        public ReactiveGridFsUploadBuilder<T> contentType(String contentType) {
            this.options = this.options.contentType(contentType);
            return this;
        }

        @Contract(value="-> new")
        public ReactiveGridFsUpload<T> build() {
            Assert.notNull(this.dataStream, (String)"DataStream must be set first");
            Assert.notNull((Object)this.filename, (String)"Filename must be set first");
            Assert.notNull((Object)this.options, (String)"Options must be set first");
            return new ReactiveGridFsUpload<Object>(this.id, this.dataStream, this.filename, this.options);
        }
    }
}

