/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.data.mongodb.repository.aot.AotStringAggregation;
import org.springframework.data.mongodb.repository.aot.MongoInteraction;
import org.springframework.data.repository.aot.generate.QueryMetadata;

class AggregationInteraction
extends MongoInteraction
implements QueryMetadata {
    private final AotStringAggregation aggregation;

    AggregationInteraction(String[] raw) {
        this.aggregation = new AotStringAggregation(raw);
    }

    List<String> stages() {
        return Arrays.asList(this.aggregation.pipeline());
    }

    @Override
    MongoInteraction.InteractionType getExecutionType() {
        return MongoInteraction.InteractionType.AGGREGATION;
    }

    public Map<String, Object> serialize() {
        return Map.of(this.pipelineSerializationKey(), this.stages());
    }

    protected String pipelineSerializationKey() {
        return "pipeline";
    }
}

