/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.repository.aot;

abstract class MongoInteraction {
    MongoInteraction() {
    }

    abstract InteractionType getExecutionType();

    boolean isAggregation() {
        return InteractionType.AGGREGATION.equals((Object)this.getExecutionType());
    }

    boolean isCount() {
        return InteractionType.COUNT.equals((Object)this.getExecutionType());
    }

    boolean isDelete() {
        return InteractionType.DELETE.equals((Object)this.getExecutionType());
    }

    boolean isExists() {
        return InteractionType.EXISTS.equals((Object)this.getExecutionType());
    }

    boolean isUpdate() {
        return InteractionType.UPDATE.equals((Object)this.getExecutionType());
    }

    String name() {
        if (this.isDelete()) {
            return "deleteQuery";
        }
        if (this.isCount()) {
            return "countQuery";
        }
        return "filterQuery";
    }

    static enum InteractionType {
        QUERY,
        COUNT,
        DELETE,
        EXISTS,
        UPDATE,
        AGGREGATION;

    }
}

