/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.mapping;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.springframework.data.neo4j.core.mapping.DefaultNeo4jPersistentEntity;
import org.springframework.data.neo4j.core.mapping.NodeDescription;
import org.springframework.data.neo4j.core.mapping.NodeDescriptionAndLabels;
import org.springframework.lang.Nullable;

final class NodeDescriptionStore {
    private final Map<String, NodeDescription<?>> nodeDescriptionsByPrimaryLabel = new ConcurrentHashMap();
    private final Map<NodeDescription<?>, Map<List<String>, NodeDescriptionAndLabels>> nodeDescriptionAndLabelsCache = new ConcurrentHashMap();
    private final BiFunction<NodeDescription<?>, List<String>, NodeDescriptionAndLabels> nodeDescriptionAndLabels = (nodeDescription, labels) -> {
        NodeDescriptionAndLabels cachedNodeDescriptionAndLabels;
        Map<List<String>, NodeDescriptionAndLabels> listNodeDescriptionAndLabelsMap = this.nodeDescriptionAndLabelsCache.get(nodeDescription);
        if (listNodeDescriptionAndLabelsMap == null) {
            this.nodeDescriptionAndLabelsCache.put((NodeDescription<?>)nodeDescription, new ConcurrentHashMap());
            listNodeDescriptionAndLabelsMap = this.nodeDescriptionAndLabelsCache.get(nodeDescription);
        }
        if ((cachedNodeDescriptionAndLabels = listNodeDescriptionAndLabelsMap.get(labels)) == null) {
            cachedNodeDescriptionAndLabels = this.computeConcreteNodeDescription((NodeDescription<?>)nodeDescription, (List<String>)labels);
            listNodeDescriptionAndLabelsMap.put((List<String>)labels, cachedNodeDescriptionAndLabels);
        }
        return cachedNodeDescriptionAndLabels;
    };

    NodeDescriptionStore() {
    }

    public boolean containsKey(String primaryLabel) {
        return this.nodeDescriptionsByPrimaryLabel.containsKey(primaryLabel);
    }

    public <T> boolean containsValue(DefaultNeo4jPersistentEntity<T> newEntity) {
        return this.nodeDescriptionsByPrimaryLabel.containsValue(newEntity);
    }

    public <T> void put(String primaryLabel, DefaultNeo4jPersistentEntity<T> newEntity) {
        this.nodeDescriptionsByPrimaryLabel.put(primaryLabel, newEntity);
    }

    public Set<Map.Entry<String, NodeDescription<?>>> entrySet() {
        return this.nodeDescriptionsByPrimaryLabel.entrySet();
    }

    public Collection<NodeDescription<?>> values() {
        return this.nodeDescriptionsByPrimaryLabel.values();
    }

    @Nullable
    public NodeDescription<?> get(String primaryLabel) {
        return this.nodeDescriptionsByPrimaryLabel.get(primaryLabel);
    }

    @Nullable
    public NodeDescription<?> getNodeDescription(Class<?> targetType) {
        for (NodeDescription<?> nodeDescription : this.values()) {
            if (!nodeDescription.getUnderlyingClass().equals(targetType)) continue;
            return nodeDescription;
        }
        return null;
    }

    public NodeDescriptionAndLabels deriveConcreteNodeDescription(NodeDescription<?> entityDescription, List<String> labels) {
        return this.nodeDescriptionAndLabels.apply(entityDescription, labels);
    }

    private NodeDescriptionAndLabels computeConcreteNodeDescription(NodeDescription<?> entityDescription, @Nullable List<String> labels) {
        boolean isConcreteClassThatFulfillsEverything;
        boolean isAbstractClassOrInterface = Modifier.isAbstract(entityDescription.getUnderlyingClass().getModifiers());
        boolean bl = isConcreteClassThatFulfillsEverything = !isAbstractClassOrInterface && entityDescription.getStaticLabels().containsAll(labels);
        if (labels == null || labels.isEmpty() || isConcreteClassThatFulfillsEverything) {
            return new NodeDescriptionAndLabels(entityDescription, Collections.emptyList());
        }
        Collection<NodeDescription<?>> haystack = entityDescription.describesInterface() ? this.values() : entityDescription.getChildNodeDescriptionsInHierarchy();
        if (!haystack.isEmpty()) {
            NodeDescription<?> mostMatchingNodeDescription = !isAbstractClassOrInterface ? entityDescription : null;
            List<String> mostMatchingStaticLabels = !isAbstractClassOrInterface ? entityDescription.getStaticLabels() : null;
            HashMap unmatchedLabelsCache = new HashMap();
            if (!isAbstractClassOrInterface) {
                unmatchedLabelsCache.put(mostMatchingNodeDescription, labels.size() - mostMatchingStaticLabels.size());
            }
            for (NodeDescription<?> nd : haystack) {
                if (Modifier.isAbstract(nd.getUnderlyingClass().getModifiers())) continue;
                List<String> staticLabels = nd.getStaticLabels();
                if (staticLabels.containsAll(labels)) {
                    HashSet<String> surplusLabels = new HashSet<String>(labels);
                    staticLabels.forEach(surplusLabels::remove);
                    return new NodeDescriptionAndLabels(nd, surplusLabels);
                }
                int unmatchedLabelsCount = 0;
                ArrayList<String> matchingLabels = new ArrayList<String>();
                for (String label : labels) {
                    if (staticLabels.contains(label)) {
                        matchingLabels.add(label);
                        continue;
                    }
                    ++unmatchedLabelsCount;
                }
                unmatchedLabelsCache.put(nd, unmatchedLabelsCount);
                if (mostMatchingNodeDescription != null && unmatchedLabelsCount >= (Integer)unmatchedLabelsCache.get(mostMatchingNodeDescription)) continue;
                mostMatchingNodeDescription = nd;
                mostMatchingStaticLabels = matchingLabels;
            }
            HashSet<String> surplusLabels = new HashSet<String>(labels);
            mostMatchingStaticLabels.forEach(surplusLabels::remove);
            return new NodeDescriptionAndLabels(mostMatchingNodeDescription, surplusLabels);
        }
        HashSet<String> surplusLabels = new HashSet<String>(labels);
        surplusLabels.remove(entityDescription.getPrimaryLabel());
        entityDescription.getAdditionalLabels().forEach(surplusLabels::remove);
        return new NodeDescriptionAndLabels(entityDescription, surplusLabels);
    }
}

