/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.IOException;
import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.cache.support.NullValue;
import org.springframework.core.KotlinDetector;
import org.springframework.data.redis.serializer.JacksonObjectReader;
import org.springframework.data.redis.serializer.JacksonObjectWriter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.data.util.Lazy;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.TreeNode;
import tools.jackson.core.Version;
import tools.jackson.databind.DefaultTyping;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.deser.DeserializationContextExt;
import tools.jackson.databind.deser.jackson.BaseNodeDeserializer;
import tools.jackson.databind.deser.jackson.JsonNodeDeserializer;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import tools.jackson.databind.jsontype.PolymorphicTypeValidator;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.jsontype.impl.DefaultTypeResolverBuilder;
import tools.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import tools.jackson.databind.module.SimpleSerializers;
import tools.jackson.databind.node.NullNode;
import tools.jackson.databind.ser.Serializers;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.type.TypeFactory;

public class GenericJacksonJsonRedisSerializer
implements RedisSerializer<Object> {
    private final JacksonObjectReader reader;
    private final JacksonObjectWriter writer;
    private final Lazy<Boolean> defaultTypingEnabled;
    private final ObjectMapper mapper;
    private final TypeResolver typeResolver;

    public GenericJacksonJsonRedisSerializer(ObjectMapper mapper) {
        this(mapper, JacksonObjectReader.create(), JacksonObjectWriter.create());
    }

    protected GenericJacksonJsonRedisSerializer(ObjectMapper mapper, JacksonObjectReader reader, JacksonObjectWriter writer) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null");
        Assert.notNull((Object)reader, (String)"Reader must not be null");
        Assert.notNull((Object)writer, (String)"Writer must not be null");
        this.mapper = mapper;
        this.reader = reader;
        this.writer = writer;
        this.defaultTypingEnabled = Lazy.of(() -> mapper.serializationConfig().getDefaultTyper(null) != null);
        Lazy<String> lazyTypeHintPropertyName = GenericJacksonJsonRedisSerializer.newLazyTypeHintPropertyName(mapper, this.defaultTypingEnabled);
        this.typeResolver = GenericJacksonJsonRedisSerializer.newTypeResolver(mapper, lazyTypeHintPropertyName);
    }

    public static GenericJacksonJsonRedisSerializer create(Consumer<GenericJacksonJsonRedisSerializerBuilder<JsonMapper.Builder>> configurer) {
        Assert.notNull(configurer, (String)"Builder configurer must not be null");
        GenericJacksonJsonRedisSerializerBuilder<JsonMapper.Builder> builder = GenericJacksonJsonRedisSerializer.builder();
        configurer.accept(builder);
        return builder.build();
    }

    public static GenericJacksonJsonRedisSerializerBuilder<JsonMapper.Builder> builder() {
        return GenericJacksonJsonRedisSerializer.builder(JsonMapper::builder);
    }

    public static <B extends MapperBuilder<? extends ObjectMapper, ? extends MapperBuilder<?, ?>>> GenericJacksonJsonRedisSerializerBuilder<B> builder(Supplier<B> builderFactory) {
        Assert.notNull(builderFactory, (String)"MapperBuilder Factory must not be null");
        return new GenericJacksonJsonRedisSerializerBuilder<B>(builderFactory);
    }

    @Override
    @Contract(value="_ -> !null")
    public byte[] serialize(@Nullable Object value) throws SerializationException {
        if (value == null) {
            return SerializationUtils.EMPTY_ARRAY;
        }
        try {
            return this.writer.write(this.mapper, value);
        }
        catch (RuntimeException ex) {
            throw new SerializationException("Could not write JSON: %s".formatted(ex.getMessage()), ex);
        }
    }

    @Override
    @Contract(value="null -> null")
    public @Nullable Object deserialize(byte @Nullable [] source) throws SerializationException {
        return this.deserialize(source, Object.class);
    }

    @Contract(value="null, _ -> null")
    public <T> @Nullable T deserialize(byte @Nullable [] source, Class<T> type) throws SerializationException {
        Assert.notNull(type, (String)"Deserialization type must not be null; Please provide Object.class to make use of Jackson3 default typing.");
        if (SerializationUtils.isEmpty(source)) {
            return null;
        }
        try {
            return (T)this.reader.read(this.mapper, source, this.resolveType(source, type));
        }
        catch (Exception ex) {
            throw new SerializationException("Could not read JSON:%s ".formatted(ex.getMessage()), ex);
        }
    }

    protected JavaType resolveType(byte[] source, Class<?> type) throws IOException {
        if (!type.equals(Object.class) || !((Boolean)this.defaultTypingEnabled.get()).booleanValue()) {
            return this.typeResolver.constructType(type);
        }
        return this.typeResolver.resolveType(source, type);
    }

    private static TypeResolver newTypeResolver(ObjectMapper mapper, Lazy<String> typeHintPropertyName) {
        Lazy lazyTypeFactory = Lazy.of(() -> ((ObjectMapper)mapper).getTypeFactory());
        return new TypeResolver(mapper, (Supplier<TypeFactory>)lazyTypeFactory, (Supplier<String>)typeHintPropertyName);
    }

    private static Lazy<String> newLazyTypeHintPropertyName(ObjectMapper mapper, Lazy<Boolean> defaultTypingEnabled) {
        Lazy<String> configuredTypeDeserializationPropertyName = GenericJacksonJsonRedisSerializer.getConfiguredTypeDeserializationPropertyName(mapper);
        Lazy resolvedLazyTypeHintPropertyName = Lazy.of(() -> (Boolean)defaultTypingEnabled.get() != false ? (String)configuredTypeDeserializationPropertyName.get() : null);
        return resolvedLazyTypeHintPropertyName.or((Object)"@class");
    }

    private static Lazy<String> getConfiguredTypeDeserializationPropertyName(ObjectMapper mapper) {
        return Lazy.of(() -> {
            DeserializationConfig deserializationConfig = mapper.deserializationConfig();
            JavaType objectType = mapper.getTypeFactory().constructType(Object.class);
            TypeDeserializer typeDeserializer = deserializationConfig.getDefaultTyper(null).buildTypeDeserializer((DeserializationContext)mapper._deserializationContext(), objectType, Collections.emptyList());
            return typeDeserializer.getPropertyName();
        });
    }

    static class TypeResolver {
        private final ObjectMapper mapper;
        private final Supplier<TypeFactory> typeFactory;
        private final Supplier<String> hintName;

        TypeResolver(ObjectMapper mapper, Supplier<TypeFactory> typeFactory, Supplier<String> hintName) {
            this.mapper = mapper;
            this.typeFactory = typeFactory;
            this.hintName = hintName;
        }

        protected JavaType constructType(Class<?> type) {
            return this.typeFactory.get().constructType(type);
        }

        protected JavaType resolveType(byte[] source, Class<?> type) throws IOException {
            JsonNode root = this.readTree(source);
            JsonNode jsonNode = root.get(this.hintName.get());
            if (jsonNode != null && jsonNode.isString() && jsonNode.asString() != null) {
                return this.typeFactory.get().constructFromCanonical(jsonNode.asString());
            }
            return this.constructType(type);
        }

        private JsonNode readTree(byte[] source) throws IOException {
            BaseNodeDeserializer deserializer = JsonNodeDeserializer.getDeserializer(JsonNode.class);
            DeserializationConfig cfg = this.mapper.deserializationConfig();
            try (JsonParser parser = this.createParser(source);){
                JsonToken t = parser.currentToken();
                if (t == null && (t = parser.nextToken()) == null) {
                    JsonNode jsonNode = cfg.getNodeFactory().missingNode();
                    return jsonNode;
                }
                DeserializationContextExt ctxt = this.mapper._deserializationContext();
                if (t == JsonToken.VALUE_NULL) {
                    NullNode nullNode = cfg.getNodeFactory().nullNode();
                    return nullNode;
                }
                JsonNode jsonNode = (JsonNode)deserializer.deserialize(parser, (DeserializationContext)ctxt);
                return jsonNode;
            }
        }

        private JsonParser createParser(byte[] source) throws IOException {
            return this.mapper.createParser(source);
        }
    }

    public static class GenericJacksonJsonRedisSerializerBuilder<B extends MapperBuilder<? extends ObjectMapper, ? extends MapperBuilder<?, ?>>> {
        private final Supplier<B> builderFactory;
        private boolean cacheNullValueSupportEnabled = false;
        private boolean defaultTyping = false;
        private @Nullable String typePropertyName;
        private PolymorphicTypeValidator typeValidator = BasicPolymorphicTypeValidator.builder().allowIfBaseType(Object.class).allowIfSubType((ctx, clazz) -> true).build();
        private Consumer<B> mapperBuilderCustomizer = b -> {};
        private JacksonObjectWriter writer = JacksonObjectWriter.create();
        private JacksonObjectReader reader = JacksonObjectReader.create();

        private GenericJacksonJsonRedisSerializerBuilder(Supplier<B> builderFactory) {
            this.builderFactory = builderFactory;
        }

        @Contract(value="-> this")
        public GenericJacksonJsonRedisSerializerBuilder<B> enableSpringCacheNullValueSupport() {
            this.cacheNullValueSupportEnabled = true;
            return this;
        }

        @Contract(value="_ -> this")
        public GenericJacksonJsonRedisSerializerBuilder<B> enableSpringCacheNullValueSupport(String typePropertyName) {
            this.typePropertyName(typePropertyName);
            return this.enableSpringCacheNullValueSupport();
        }

        @Contract(value="-> this")
        public GenericJacksonJsonRedisSerializerBuilder<B> enableUnsafeDefaultTyping() {
            this.defaultTyping = true;
            return this;
        }

        @Contract(value="_ -> this")
        public GenericJacksonJsonRedisSerializerBuilder<B> enableDefaultTyping(PolymorphicTypeValidator typeValidator) {
            this.typeValidator(typeValidator);
            this.defaultTyping = true;
            return this;
        }

        @Contract(value="_ -> this")
        public GenericJacksonJsonRedisSerializerBuilder<B> typeValidator(PolymorphicTypeValidator typeValidator) {
            Assert.notNull((Object)typeValidator, (String)"Type validator must not be null");
            this.typeValidator = typeValidator;
            return this;
        }

        @Contract(value="_ -> this")
        public GenericJacksonJsonRedisSerializerBuilder<B> typePropertyName(String typePropertyName) {
            Assert.hasText((String)typePropertyName, (String)"Property name must not be null or empty");
            this.typePropertyName = typePropertyName;
            return this;
        }

        @Contract(value="_ -> this")
        public GenericJacksonJsonRedisSerializerBuilder<B> writer(JacksonObjectWriter writer) {
            Assert.notNull((Object)writer, (String)"Jackson3ObjectWriter must not be null");
            this.writer = writer;
            return this;
        }

        @Contract(value="_ -> this")
        public GenericJacksonJsonRedisSerializerBuilder<B> reader(JacksonObjectReader reader) {
            Assert.notNull((Object)reader, (String)"Jackson3ObjectReader must not be null");
            this.reader = reader;
            return this;
        }

        @Contract(value="_ -> this")
        public GenericJacksonJsonRedisSerializerBuilder<B> customize(Consumer<B> mapperBuilderCustomizer) {
            Assert.notNull(mapperBuilderCustomizer, (String)"JSON mapper configurer must not be null");
            this.mapperBuilderCustomizer = mapperBuilderCustomizer;
            return this;
        }

        @Contract(value="-> new")
        public GenericJacksonJsonRedisSerializer build() {
            MapperBuilder mapperBuilder = (MapperBuilder)this.builderFactory.get();
            if (this.cacheNullValueSupportEnabled) {
                String typePropertyName = StringUtils.hasText((String)this.typePropertyName) ? this.typePropertyName : "@class";
                mapperBuilder.addModules(new JacksonModule[]{new GenericJacksonRedisSerializerModule(() -> {
                    tools.jackson.databind.jsontype.TypeResolverBuilder defaultTyper = mapperBuilder.baseSettings().getDefaultTyper();
                    if (defaultTyper instanceof StdTypeResolverBuilder) {
                        StdTypeResolverBuilder stdTypeResolverBuilder = (StdTypeResolverBuilder)defaultTyper;
                        return stdTypeResolverBuilder.getTypeProperty();
                    }
                    return typePropertyName;
                })});
            }
            if (this.defaultTyping) {
                TypeResolverBuilder resolver = new TypeResolverBuilder(this.typeValidator, DefaultTyping.NON_FINAL, JsonTypeInfo.As.PROPERTY, JsonTypeInfo.Id.CLASS, this.typePropertyName);
                mapperBuilder.configure(DeserializationFeature.FAIL_ON_MISSING_EXTERNAL_TYPE_ID_PROPERTY, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setDefaultTyping((tools.jackson.databind.jsontype.TypeResolverBuilder)resolver);
            }
            this.mapperBuilderCustomizer.accept(mapperBuilder);
            return new GenericJacksonJsonRedisSerializer(mapperBuilder.build(), this.reader, this.writer);
        }
    }

    private static class TypeResolverBuilder
    extends DefaultTypeResolverBuilder {
        public TypeResolverBuilder(PolymorphicTypeValidator subtypeValidator, DefaultTyping t, JsonTypeInfo.As includeAs) {
            super(subtypeValidator, t, includeAs);
        }

        public TypeResolverBuilder(PolymorphicTypeValidator subtypeValidator, DefaultTyping t, String propertyName) {
            super(subtypeValidator, t, propertyName);
        }

        public TypeResolverBuilder(PolymorphicTypeValidator subtypeValidator, DefaultTyping t, JsonTypeInfo.As includeAs, JsonTypeInfo.Id idType, @Nullable String propertyName) {
            super(subtypeValidator, t, includeAs, idType, propertyName);
        }

        public DefaultTypeResolverBuilder withDefaultImpl(Class<?> defaultImpl) {
            return this;
        }

        public boolean useForType(JavaType javaType) {
            if (javaType.isJavaLangObject()) {
                return true;
            }
            if ((javaType = this.resolveArrayOrWrapper(javaType)).isEnumType() || ClassUtils.isPrimitiveOrWrapper((Class)javaType.getRawClass())) {
                return false;
            }
            if (javaType.isFinal() && !KotlinDetector.isKotlinType((Class)javaType.getRawClass()) && javaType.getRawClass().getPackageName().startsWith("java")) {
                return false;
            }
            return !TreeNode.class.isAssignableFrom(javaType.getRawClass());
        }

        private JavaType resolveArrayOrWrapper(JavaType type) {
            while (type.isArrayType()) {
                if (!(type = type.getContentType()).isReferenceType()) continue;
                type = this.resolveArrayOrWrapper(type);
            }
            while (type.isReferenceType()) {
                if (!(type = type.getReferencedType()).isArrayType()) continue;
                type = this.resolveArrayOrWrapper(type);
            }
            return type;
        }
    }

    private static class GenericJacksonRedisSerializerModule
    extends JacksonModule {
        private final Supplier<String> classIdentifier;

        GenericJacksonRedisSerializerModule(Supplier<String> classIdentifier) {
            this.classIdentifier = classIdentifier;
        }

        public String getModuleName() {
            return "spring-data-redis-generic-serializer-module";
        }

        public Version version() {
            return new Version(4, 0, 0, null, "org.springframework.data", "spring-data-redis");
        }

        public void setupModule(JacksonModule.SetupContext context) {
            context.addSerializers((Serializers)new SimpleSerializers().addSerializer((ValueSerializer)new NullValueSerializer(this.classIdentifier)));
        }
    }

    private static class NullValueSerializer
    extends StdSerializer<NullValue> {
        private final Lazy<String> classIdentifier = Lazy.of(() -> {
            String identifier = (String)classIdentifier.get();
            return StringUtils.hasText((String)identifier) ? identifier : "@class";
        });

        NullValueSerializer(Supplier<String> classIdentifier) {
            super(NullValue.class);
        }

        public void serialize(NullValue value, JsonGenerator gen, SerializationContext provider) throws JacksonException {
            if (gen.canWriteTypeId()) {
                gen.writeTypeId(this.classIdentifier.get());
                gen.writeString(NullValue.class.getName());
            } else if (StringUtils.hasText((String)((String)this.classIdentifier.get()))) {
                gen.writeStartObject();
                gen.writeName((String)this.classIdentifier.get());
                gen.writeString(NullValue.class.getName());
                gen.writeEndObject();
            } else {
                gen.writeNull();
            }
        }

        public void serializeWithType(NullValue value, JsonGenerator gen, SerializationContext ctxt, TypeSerializer typeSer) throws JacksonException {
            this.serialize(value, gen, ctxt);
        }
    }
}

