/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql.render;

import org.springframework.data.relational.core.sql.From;
import org.springframework.data.relational.core.sql.Join;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectList;
import org.springframework.data.relational.core.sql.Visitable;
import org.springframework.data.relational.core.sql.Where;
import org.springframework.data.relational.core.sql.render.DelegatingVisitor;
import org.springframework.data.relational.core.sql.render.FromClauseVisitor;
import org.springframework.data.relational.core.sql.render.JoinVisitor;
import org.springframework.data.relational.core.sql.render.OrderByClauseVisitor;
import org.springframework.data.relational.core.sql.render.PartRenderer;
import org.springframework.data.relational.core.sql.render.RenderContext;
import org.springframework.data.relational.core.sql.render.SelectListVisitor;
import org.springframework.data.relational.core.sql.render.SelectRenderContext;
import org.springframework.data.relational.core.sql.render.WhereClauseVisitor;

class SelectStatementVisitor
extends DelegatingVisitor
implements PartRenderer {
    private final RenderContext context;
    private final SelectRenderContext selectRenderContext;
    private final StringBuilder builder = new StringBuilder();
    private final StringBuilder selectList = new StringBuilder();
    private final StringBuilder from = new StringBuilder();
    private final StringBuilder join = new StringBuilder();
    private final StringBuilder where = new StringBuilder();
    private final SelectListVisitor selectListVisitor;
    private final OrderByClauseVisitor orderByClauseVisitor;
    private final FromClauseVisitor fromClauseVisitor;
    private final WhereClauseVisitor whereClauseVisitor;

    SelectStatementVisitor(RenderContext context) {
        this.context = context;
        this.selectRenderContext = context.getSelectRenderContext();
        this.selectListVisitor = new SelectListVisitor(context, this.selectList::append);
        this.orderByClauseVisitor = new OrderByClauseVisitor(context);
        this.fromClauseVisitor = new FromClauseVisitor(context, it -> {
            if (!this.from.isEmpty()) {
                this.from.append(", ");
            }
            this.from.append(it);
        });
        this.whereClauseVisitor = new WhereClauseVisitor(context, this.where::append);
    }

    @Override
    public DelegatingVisitor.Delegation doEnter(Visitable segment) {
        if (segment instanceof SelectList) {
            return DelegatingVisitor.Delegation.delegateTo(this.selectListVisitor);
        }
        if (segment instanceof OrderByField) {
            return DelegatingVisitor.Delegation.delegateTo(this.orderByClauseVisitor);
        }
        if (segment instanceof From) {
            return DelegatingVisitor.Delegation.delegateTo(this.fromClauseVisitor);
        }
        if (segment instanceof Join) {
            return DelegatingVisitor.Delegation.delegateTo(new JoinVisitor(this.context, it -> {
                if (!this.join.isEmpty()) {
                    this.join.append(' ');
                }
                this.join.append(it);
            }));
        }
        if (segment instanceof Where) {
            return DelegatingVisitor.Delegation.delegateTo(this.whereClauseVisitor);
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public DelegatingVisitor.Delegation doLeave(Visitable segment) {
        if (segment instanceof Select) {
            CharSequence orderBy;
            Select select = (Select)segment;
            this.builder.append("SELECT ");
            if (select.isDistinct()) {
                this.builder.append("DISTINCT ");
            }
            this.builder.append((CharSequence)this.selectList);
            this.builder.append(this.selectRenderContext.afterSelectList().apply(select));
            if (!this.from.isEmpty()) {
                this.builder.append(" FROM ").append((CharSequence)this.from);
            }
            this.builder.append(this.selectRenderContext.afterFromTable().apply(select));
            if (!this.join.isEmpty()) {
                this.builder.append(' ').append((CharSequence)this.join);
            }
            if (!this.where.isEmpty()) {
                this.builder.append(" WHERE ").append((CharSequence)this.where);
            }
            if (!(orderBy = this.orderByClauseVisitor.getRenderedPart()).isEmpty()) {
                this.builder.append(" ORDER BY ").append(orderBy);
            }
            this.builder.append(this.selectRenderContext.afterOrderBy(!orderBy.isEmpty()).apply(select));
            return DelegatingVisitor.Delegation.leave();
        }
        return DelegatingVisitor.Delegation.retain();
    }

    @Override
    public CharSequence getRenderedPart() {
        return this.builder;
    }
}

