/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.config.xml;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedMap;
import org.springframework.beans.factory.xml.AbstractSimpleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.kafka.support.KafkaProducerContext;
import org.springframework.integration.kafka.support.ProducerConfiguration;
import org.springframework.integration.kafka.support.ProducerFactoryBean;
import org.springframework.integration.kafka.support.ProducerMetadata;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class KafkaProducerContextParser
extends AbstractSimpleBeanDefinitionParser {
    protected Class<?> getBeanClass(Element element) {
        return KafkaProducerContext.class;
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"phase");
        IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)builder, (Element)element, (String)"auto-startup");
        Element topics = DomUtils.getChildElementByTagName((Element)element, (String)"producer-configurations");
        this.parseProducerConfigurations(topics, parserContext, builder, element);
    }

    protected boolean isEligibleAttribute(String attributeName) {
        return !"producer-properties".equals(attributeName) && super.isEligibleAttribute(attributeName);
    }

    private void parseProducerConfigurations(Element topics, ParserContext parserContext, BeanDefinitionBuilder builder, Element parentElem) {
        ManagedMap producerConfigurationsMap = new ManagedMap();
        for (Element producerConfiguration : DomUtils.getChildElementsByTagName((Element)topics, (String)"producer-configuration")) {
            BeanDefinitionBuilder producerMetadataBuilder = BeanDefinitionBuilder.genericBeanDefinition(ProducerMetadata.class);
            producerMetadataBuilder.addConstructorArgValue((Object)producerConfiguration.getAttribute("topic"));
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)producerMetadataBuilder, (Element)producerConfiguration, (String)"value-encoder");
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)producerMetadataBuilder, (Element)producerConfiguration, (String)"key-encoder");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)producerMetadataBuilder, (Element)producerConfiguration, (String)"key-class-type");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)producerMetadataBuilder, (Element)producerConfiguration, (String)"value-class-type");
            IntegrationNamespaceUtils.setReferenceIfAttributeDefined((BeanDefinitionBuilder)producerMetadataBuilder, (Element)producerConfiguration, (String)"partitioner");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)producerMetadataBuilder, (Element)producerConfiguration, (String)"compression-codec");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)producerMetadataBuilder, (Element)producerConfiguration, (String)"async");
            IntegrationNamespaceUtils.setValueIfAttributeDefined((BeanDefinitionBuilder)producerMetadataBuilder, (Element)producerConfiguration, (String)"batch-num-messages");
            AbstractBeanDefinition producerMetadataBeanDefinition = producerMetadataBuilder.getBeanDefinition();
            String producerPropertiesBean = parentElem.getAttribute("producer-properties");
            BeanDefinitionBuilder producerFactoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(ProducerFactoryBean.class);
            producerFactoryBuilder.addConstructorArgValue((Object)producerMetadataBeanDefinition);
            String brokerList = producerConfiguration.getAttribute("broker-list");
            if (StringUtils.hasText((String)brokerList)) {
                producerFactoryBuilder.addConstructorArgValue((Object)producerConfiguration.getAttribute("broker-list"));
            }
            if (StringUtils.hasText((String)producerPropertiesBean)) {
                producerFactoryBuilder.addConstructorArgReference(producerPropertiesBean);
            }
            AbstractBeanDefinition producerFactoryBeanDefinition = producerFactoryBuilder.getBeanDefinition();
            AbstractBeanDefinition producerConfigurationBeanDefinition = BeanDefinitionBuilder.genericBeanDefinition(ProducerConfiguration.class).addConstructorArgValue((Object)producerMetadataBeanDefinition).addConstructorArgValue((Object)producerFactoryBeanDefinition).getBeanDefinition();
            producerConfigurationsMap.put(producerConfiguration.getAttribute("topic"), producerConfigurationBeanDefinition);
        }
        builder.addPropertyValue("producerConfigurations", (Object)producerConfigurationsMap);
    }
}

