/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.kafka.outbound;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.expression.IntegrationEvaluationContextAware;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.kafka.support.KafkaProducerContext;
import org.springframework.messaging.Message;
import org.springframework.util.Assert;

public class KafkaProducerMessageHandler<K, V>
extends AbstractMessageHandler
implements IntegrationEvaluationContextAware {
    private final KafkaProducerContext<K, V> kafkaProducerContext;
    private EvaluationContext evaluationContext;
    private volatile Expression topicExpression;
    private volatile Expression messageKeyExpression;

    public KafkaProducerMessageHandler(KafkaProducerContext<K, V> kafkaProducerContext) {
        this.kafkaProducerContext = kafkaProducerContext;
    }

    public void setIntegrationEvaluationContext(EvaluationContext evaluationContext) {
        this.evaluationContext = evaluationContext;
    }

    public void setTopicExpression(Expression topicExpression) {
        this.topicExpression = topicExpression;
    }

    public void setMessageKeyExpression(Expression messageKeyExpression) {
        this.messageKeyExpression = messageKeyExpression;
    }

    public KafkaProducerContext<K, V> getKafkaProducerContext() {
        return this.kafkaProducerContext;
    }

    protected void onInit() throws Exception {
        Assert.notNull((Object)this.evaluationContext);
    }

    protected void handleMessageInternal(Message<?> message) throws Exception {
        String topic = this.topicExpression != null ? (String)this.topicExpression.getValue(this.evaluationContext, message, String.class) : (String)message.getHeaders().get((Object)"kafka_topic", String.class);
        Object messageKey = this.messageKeyExpression != null ? this.messageKeyExpression.getValue(this.evaluationContext, message) : message.getHeaders().get((Object)"kafka_messageKey");
        this.kafkaProducerContext.send(topic, messageKey, message);
    }

    public String getComponentType() {
        return "kafka:outbound-channel-adapter";
    }
}

