/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.aptk.tools.wrapper;

import java.lang.annotation.Annotation;
import java.lang.annotation.Repeatable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import org.springframework.modulith.aptk.tools.AnnotationUtils;
import org.springframework.modulith.aptk.tools.ElementUtils;
import org.springframework.modulith.aptk.tools.TypeMirrorWrapper;
import org.springframework.modulith.aptk.tools.fluentfilter.FluentElementFilter;
import org.springframework.modulith.aptk.tools.fluentvalidator.FluentElementValidator;
import org.springframework.modulith.aptk.tools.wrapper.AnnotationMirrorWrapper;
import org.springframework.modulith.aptk.tools.wrapper.CompileMessageWriter;
import org.springframework.modulith.aptk.tools.wrapper.ElementWrapperValidator;
import org.springframework.modulith.aptk.tools.wrapper.ElementWrapperValidatorInterface;
import org.springframework.modulith.aptk.tools.wrapper.ExecutableElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.ModuleElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.PackageElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.TypeElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.TypeParameterElementWrapper;
import org.springframework.modulith.aptk.tools.wrapper.VariableElementWrapper;

public class ElementWrapper<E extends Element> {
    protected final E element;

    protected ElementWrapper(E element) {
        if (element == null) {
            throw new IllegalArgumentException("Passed Element to wrap must not be null.");
        }
        this.element = element;
    }

    public E unwrap() {
        return this.element;
    }

    public PackageElementWrapper getPackage() {
        return this.isPackage() ? ElementWrapper.toPackageElement(this) : PackageElementWrapper.wrap((PackageElement)ElementUtils.AccessEnclosingElements.getFirstEnclosingElementOfKind(this.element, new ElementKind[]{ElementKind.PACKAGE}));
    }

    public String getPackageName() {
        return this.getPackage().getQualifiedName();
    }

    public String getSimplePackageName() {
        return this.getPackage().getSimpleName();
    }

    public boolean hasPackageName(String name) {
        return name != null && this.getPackageName().equals(name);
    }

    public boolean hasSimplePackageName(String name) {
        return name != null && this.getSimplePackageName().equals(name);
    }

    public Optional<ModuleElementWrapper> getModule() {
        try {
            Object element = ElementUtils.AccessEnclosingElements.getFirstEnclosingElementOfKind(this.element, new ElementKind[]{ElementKind.valueOf("MODULE")});
            return element != null ? Optional.of(ModuleElementWrapper.wrap(element)) : Optional.empty();
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public String getSimpleName() {
        return this.element.getSimpleName().toString();
    }

    public boolean hasSimpleName(String name) {
        return name != null && this.getSimpleName().equals(name);
    }

    public boolean hasModifiers(Modifier ... modifiersToCheck) {
        if (modifiersToCheck == null) {
            return false;
        }
        for (Modifier modifier : modifiersToCheck) {
            if (this.element.getModifiers().contains((Object)modifier)) continue;
            return false;
        }
        return true;
    }

    public FluentElementValidator<E> validateWithFluentElementValidator() {
        return FluentElementValidator.createFluentElementValidator(this.unwrap());
    }

    public ElementWrapperValidatorInterface.FirstValidation<ElementWrapper<E>> validate() {
        return ElementWrapperValidator.startValidation(this);
    }

    public FluentElementFilter<Element> filterEnclosedElements() {
        return FluentElementFilter.createFluentElementFilter(this.getEnclosedElements().stream().map(ElementWrapper::unwrap).collect(Collectors.toList()));
    }

    public FluentElementFilter<Element> filterFlattenedEnclosedElementTree() {
        return this.filterFlattenedEnclosedElementTree(false);
    }

    public FluentElementFilter<Element> filterFlattenedEnclosedElementTree(boolean includeSelf) {
        return this.filterFlattenedEnclosedElementTree(includeSelf, Integer.MAX_VALUE);
    }

    public FluentElementFilter<Element> filterFlattenedEnclosedElementTree(boolean includeSelf, int maxDepth) {
        return FluentElementFilter.createFluentElementFilter(this.getFlattenedEnclosedElementTree(includeSelf, maxDepth).stream().map(ElementWrapper::unwrap).collect(Collectors.toList()));
    }

    public List<AnnotationMirrorWrapper> getAnnotations() {
        return this.element.getAnnotationMirrors().stream().map(AnnotationMirrorWrapper::wrap).collect(Collectors.toList());
    }

    public Optional<AnnotationMirrorWrapper> getAnnotation(String annotationFqn) {
        return AnnotationMirrorWrapper.get(this.element, annotationFqn);
    }

    public TypeMirrorWrapper asType() {
        return TypeMirrorWrapper.wrap(this.element.asType());
    }

    public ElementKind getKind() {
        return this.element.getKind();
    }

    public Set<Modifier> getModifiers() {
        return this.element.getModifiers();
    }

    public Optional<ElementWrapper<Element>> getEnclosingElement() {
        Element enclosingElement = this.element.getEnclosingElement();
        return enclosingElement != null ? Optional.of(ElementWrapper.wrap(enclosingElement)) : Optional.empty();
    }

    public List<ElementWrapper<Element>> getAllEnclosingElements() {
        return this.getAllEnclosingElements(false);
    }

    public List<ElementWrapper<Element>> getAllEnclosingElements(boolean includeWrappedElement) {
        return ElementUtils.AccessEnclosingElements.getFlattenedEnclosingElementsTree(this.element, includeWrappedElement).stream().map(ElementWrapper::wrap).collect(Collectors.toList());
    }

    public <EW extends ElementWrapper<?>> Optional<EW> getFirstEnclosingElementWithKind(ElementKind kind) {
        Object element = ElementUtils.AccessEnclosingElements.getFirstEnclosingElementOfKind(this.element, new ElementKind[]{kind});
        if (element == null) {
            return Optional.empty();
        }
        ElementWrapper elementWrapper = ElementWrapper.wrap(element);
        if (elementWrapper.isTypeElement()) {
            return Optional.of(ElementWrapper.toTypeElement(elementWrapper));
        }
        if (elementWrapper.isExecutableElement()) {
            return Optional.of(ElementWrapper.toExecutableElementWrapper(elementWrapper));
        }
        if (elementWrapper.isPackageElement()) {
            return Optional.of(ElementWrapper.toPackageElement(elementWrapper));
        }
        if (elementWrapper.isVariableElement()) {
            return Optional.of(ElementWrapper.toVariableElementWrapper(elementWrapper));
        }
        if (elementWrapper.isTypeParameterElement()) {
            return Optional.of(ElementWrapper.toTypeParameterElementWrapper(elementWrapper));
        }
        return Optional.of(elementWrapper);
    }

    public List<ElementWrapper<? extends Element>> getEnclosedElements() {
        return this.element.getEnclosedElements().stream().map(ElementWrapper::wrap).collect(Collectors.toList());
    }

    public List<ElementWrapper<Element>> getFlattenedEnclosedElementTree() {
        return this.getFlattenedEnclosedElementTree(false);
    }

    public List<ElementWrapper<Element>> getFlattenedEnclosedElementTree(boolean includeSelf) {
        return this.getFlattenedEnclosedElementTree(includeSelf, Integer.MAX_VALUE);
    }

    public List<ElementWrapper<Element>> getFlattenedEnclosedElementTree(boolean includeSelf, int maxDepth) {
        return ElementUtils.AccessEnclosedElements.flattenEnclosedElementTree(this.unwrap(), includeSelf, maxDepth).stream().map(ElementWrapper::wrap).collect(Collectors.toList());
    }

    public List<AnnotationMirrorWrapper> getAnnotationMirrors() {
        return this.element.getAnnotationMirrors().stream().map(AnnotationMirrorWrapper::wrap).collect(Collectors.toList());
    }

    public Optional<AnnotationMirrorWrapper> getAnnotationMirror(Class<? extends Annotation> annotationType) {
        AnnotationMirror annotationMirror = AnnotationUtils.getAnnotationMirror(this.element, annotationType);
        return annotationMirror != null ? Optional.of(AnnotationMirrorWrapper.wrap(annotationMirror)) : Optional.empty();
    }

    public Optional<AnnotationMirrorWrapper> getAnnotationMirror(String annotationTypeFqn) {
        AnnotationMirror annotationMirror = AnnotationUtils.getAnnotationMirror(this.element, annotationTypeFqn);
        return annotationMirror != null ? Optional.of(AnnotationMirrorWrapper.wrap(annotationMirror)) : Optional.empty();
    }

    public boolean hasAnnotation(Class<? extends Annotation> annotation) {
        return this.getAnnotationMirror(annotation).isPresent();
    }

    public boolean hasAnnotation(String annotationFqn) {
        return this.getAnnotationMirror(annotationFqn).isPresent();
    }

    public boolean hasMetaAnnotation(Class<? extends Annotation> annotation) {
        return this.hasAnnotation(annotation) || this.getAnnotationMirrors().stream().anyMatch(it -> it.hasMetaAnnotation(annotation));
    }

    public boolean hasMetaAnnotation(String fqn) {
        return this.hasAnnotation(fqn) || this.getAnnotationMirrors().stream().anyMatch(it -> it.hasMetaAnnotation(fqn));
    }

    public <A extends Annotation> Optional<A> getAnnotation(Class<A> annotationType) {
        return Optional.ofNullable(this.element.getAnnotation(annotationType));
    }

    public Optional<List<AnnotationMirrorWrapper>> getRepeatableAnnotation(Class<? extends Annotation> annotationType) {
        ArrayList result = new ArrayList();
        return Optional.of(result);
    }

    public <R, P> R accept(ElementVisitor<R, P> v, P p) {
        return this.element.accept(v, p);
    }

    public CompileMessageWriter.CompileMessageWriterStart compilerMessage() {
        return CompileMessageWriter.at(this.element);
    }

    public CompileMessageWriter.CompileMessageWriterStart compilerMessage(AnnotationMirror annotationMirror) {
        return CompileMessageWriter.at(this.element, annotationMirror);
    }

    public CompileMessageWriter.CompileMessageWriterStart compilerMessage(AnnotationMirror annotationMirror, AnnotationValue annotationValue) {
        return CompileMessageWriter.at(this.element, annotationMirror, annotationValue);
    }

    public <A extends Annotation> A[] getAnnotationsByType(Class<A> annotationType) {
        return this.element.getAnnotationsByType(annotationType);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean equals(Object obj) {
        return this.element.equals(obj);
    }

    public static <T extends Element> ElementWrapper<T> wrap(T element) {
        return new ElementWrapper<T>(element);
    }

    public static <T extends Element> List<ElementWrapper<T>> wrap(List<T> elements) {
        return elements != null ? elements.stream().map(ElementWrapper::wrap).collect(Collectors.toList()) : new ArrayList<ElementWrapper<T>>();
    }

    public boolean isModule() {
        return ElementUtils.CheckKindOfElement.isModule(this.element);
    }

    public boolean isPackage() {
        return ElementUtils.CheckKindOfElement.isPackage(this.element);
    }

    public boolean isClass() {
        return ElementUtils.CheckKindOfElement.isClass(this.element);
    }

    public boolean isInterface() {
        return ElementUtils.CheckKindOfElement.isInterface(this.element);
    }

    public boolean isEnum() {
        return ElementUtils.CheckKindOfElement.isEnum(this.element);
    }

    public boolean isRecord() {
        return ElementUtils.CheckKindOfElement.isRecord(this.element);
    }

    public boolean isRecordComponent() {
        return ElementUtils.CheckKindOfElement.isRecordComponent(this.element);
    }

    public boolean isAnnotation() {
        return ElementUtils.CheckKindOfElement.isAnnotation(this.element);
    }

    public boolean isRepeatableAnnotation() {
        return this.isAnnotation() && this.hasAnnotation(Repeatable.class);
    }

    public Optional<TypeMirrorWrapper> getRepeatableWrapperType() {
        if (this.isRepeatableAnnotation()) {
            return Optional.of(this.getAnnotationMirror(Repeatable.class).get().getAttribute().get().getClassValue());
        }
        return Optional.empty();
    }

    public boolean isConstructor() {
        return ElementUtils.CheckKindOfElement.isConstructor(this.element);
    }

    public boolean isMethod() {
        return ElementUtils.CheckKindOfElement.isMethod(this.element);
    }

    public boolean isField() {
        return ElementUtils.CheckKindOfElement.isField(this.element);
    }

    public boolean isAnnotationAttribute() {
        return ElementUtils.CheckKindOfElement.isAnnotationAttribute(this.element);
    }

    public boolean isConstructorParameter() {
        return ElementUtils.CheckKindOfElement.isConstructorParameter(this.element);
    }

    public boolean isMethodParameter() {
        return ElementUtils.CheckKindOfElement.isMethodParameter(this.element);
    }

    public boolean isPackageElement() {
        return ElementUtils.CastElement.isPackageElement(this.element);
    }

    public boolean isTypeElement() {
        return ElementUtils.CastElement.isTypeElement(this.element);
    }

    public boolean isRecordComponentElement() {
        return ElementUtils.CastElement.isRecordComponentElement(this.element);
    }

    public boolean isExecutableElement() {
        return ElementUtils.CastElement.isExecutableElement(this.element);
    }

    public boolean isVariableElement() {
        return ElementUtils.CastElement.isVariableElement(this.element);
    }

    public boolean isTypeParameterElement() {
        return ElementUtils.CastElement.isTypeParameterElement(this.element);
    }

    public boolean isModuleElement() {
        return ElementUtils.CastElement.isModuleElement(this.element);
    }

    public static PackageElementWrapper toPackageElement(ElementWrapper<? extends Element> wrapper) {
        return PackageElementWrapper.wrap(ElementUtils.CastElement.castToPackageElement(wrapper.unwrap()));
    }

    public static TypeElementWrapper toTypeElement(ElementWrapper<? extends Element> wrapper) {
        return TypeElementWrapper.wrap(ElementUtils.CastElement.castToTypeElement(wrapper.unwrap()));
    }

    public static TypeParameterElementWrapper toTypeParameterElementWrapper(ElementWrapper<? extends Element> wrapper) {
        return TypeParameterElementWrapper.wrap(ElementUtils.CastElement.castToTypeParameterElement(wrapper.unwrap()));
    }

    public static VariableElementWrapper toVariableElementWrapper(ElementWrapper<? extends Element> wrapper) {
        return VariableElementWrapper.wrap(ElementUtils.CastElement.castToVariableElement(wrapper.unwrap()));
    }

    public static ExecutableElementWrapper toExecutableElementWrapper(ElementWrapper<? extends Element> wrapper) {
        return ExecutableElementWrapper.wrap(ElementUtils.CastElement.castToExecutableElement(wrapper.unwrap()));
    }

    protected <TARGET_TYPE> TARGET_TYPE invokeParameterlessMethodOfElement(String interfaceName, String methodName) {
        return ElementWrapper.invokeParameterlessMethodOfElement(this.element, interfaceName, methodName);
    }

    protected static <TARGET_TYPE> TARGET_TYPE invokeParameterlessMethodOfElement(Object instance, String interfaceName, String methodName) {
        try {
            Class<?> interfaceClass = Class.forName(interfaceName);
            return (TARGET_TYPE)interfaceClass.getMethod(methodName, new Class[0]).invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't invoke " + interfaceName + "." + methodName + "()", e);
        }
    }

    protected boolean hasMethod(String interfaceName, String methodName) {
        try {
            Class<?> interfaceClass = Class.forName(interfaceName);
            Method method = interfaceClass.getMethod(methodName, new Class[0]);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

