/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.autoconfigure;

import org.springframework.boot.diagnostics.AbstractFailureAnalyzer;
import org.springframework.boot.diagnostics.FailureAnalysis;
import org.springframework.modulith.core.Violations;

class FailedModuleVerificationFailureAnalyzer
extends AbstractFailureAnalyzer<Violations> {
    FailedModuleVerificationFailureAnalyzer() {
    }

    protected FailureAnalysis analyze(Throwable rootFailure, Violations cause) {
        String description = "Spring Modulith application module verification was enabled and failed! The following violations were detected:\n\n%s\n".formatted(cause.getMessage());
        String action = "Please fix the architectural violations or disable the runtime verification by setting spring.modulith.runtime.verification-enabled to false or removing it entirely.\n";
        return new FailureAnalysis(description, action, (Throwable)cause);
    }
}

