/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.modulith.runtime.autoconfigure;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.flywaydb.core.Flyway;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryInitializer;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.flyway.autoconfigure.FlywayMigrationStrategy;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Role;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.modulith.ApplicationModuleInitializer;
import org.springframework.modulith.core.ApplicationModule;
import org.springframework.modulith.core.ApplicationModuleIdentifier;
import org.springframework.modulith.core.ApplicationModuleIdentifiers;
import org.springframework.modulith.core.ApplicationModules;
import org.springframework.modulith.core.ApplicationModulesFactory;
import org.springframework.modulith.core.VerificationOptions;
import org.springframework.modulith.runtime.ApplicationModulesRuntime;
import org.springframework.modulith.runtime.ApplicationRuntime;
import org.springframework.modulith.runtime.autoconfigure.ApplicationModuleInitializerInvoker;
import org.springframework.modulith.runtime.autoconfigure.ApplicationModuleMetadata;
import org.springframework.modulith.runtime.autoconfigure.DefaultApplicationModuleInitializerInvoker;
import org.springframework.modulith.runtime.autoconfigure.MissingRuntimeDependency;
import org.springframework.modulith.runtime.autoconfigure.PrecomputedApplicationModuleInitializerInvoker;
import org.springframework.modulith.runtime.autoconfigure.SpringModulithRuntimeProperties;
import org.springframework.modulith.runtime.flyway.SpringModulithFlywayMigrationStrategy;
import org.springframework.modulith.test.ModuleTestExecution;
import org.springframework.util.ClassUtils;

@AutoConfiguration
@EnableConfigurationProperties(value={SpringModulithRuntimeProperties.class})
class SpringModulithRuntimeAutoConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(SpringModulithRuntimeAutoConfiguration.class);

    SpringModulithRuntimeAutoConfiguration() {
    }

    @Bean
    @Lazy
    @Role(value=2)
    @ConditionalOnMissingBean(value={ApplicationRuntime.class})
    static ApplicationRuntime modulithsApplicationRuntime(ApplicationContext context) {
        return ApplicationRuntime.of(context);
    }

    @Bean
    @Lazy
    @Role(value=2)
    @ConditionalOnMissingBean
    static ApplicationModulesRuntime modulesRuntime(ApplicationModulesBootstrap bootstrap, ApplicationRuntime runtime) {
        return new ApplicationModulesRuntime(() -> bootstrap.getApplicationModules().join(), runtime);
    }

    @Bean
    @Lazy
    @Role(value=2)
    @ConditionalOnMissingBean
    static ApplicationModulesBootstrap applicationModulesInitializer(ApplicationRuntime runtime, ConfigurableBeanFactory factory) {
        return new ApplicationModulesBootstrap(runtime.getMainApplicationClass(), factory.getBootstrapExecutor());
    }

    @Bean
    @Role(value=2)
    @ConditionalOnBean(value={ApplicationModuleInitializer.class})
    static ApplicationListener<ApplicationStartedEvent> applicationModuleInitializingListener(ApplicationModuleInitializerInvoker invoker, ObjectProvider<ApplicationModuleInitializer> initializers) {
        return __ -> invoker.invokeInitializers(initializers.stream());
    }

    @Bean
    @Role(value=2)
    @ConditionalOnBooleanProperty(value={"spring.modulith.runtime.verification-enabled"}, matchIfMissing=false)
    static RuntimeApplicationModuleVerifier applicationModuleVerifier(ApplicationModulesBootstrap bootstrap, ObjectProvider<VerificationOptions> verification) {
        return new RuntimeApplicationModuleVerifier(bootstrap.getApplicationModules(), verification);
    }

    @Bean
    @Role(value=2)
    static ApplicationModuleMetadata applicationModuleMetadata(@Value(value="classpath:META-INF/spring-modulith/application-modules.json") Resource metadata) {
        return ApplicationModuleMetadata.of(metadata);
    }

    @Bean
    @Role(value=2)
    @ConditionalOnBean(value={ApplicationModuleInitializer.class})
    static ApplicationModuleInitializerInvoker applicationModuleInitializerInvoker(ApplicationModuleMetadata metadata, ObjectProvider<ApplicationModulesRuntime> runtime) {
        return metadata.isPresent() ? new PrecomputedApplicationModuleInitializerInvoker(metadata) : new DefaultApplicationModuleInitializerInvoker(((ApplicationModulesRuntime)runtime.getObject()).get());
    }

    @Bean
    @Role(value=2)
    ApplicationModuleIdentifiers applicationModuleIdentifiers(ApplicationModuleMetadata metadata, ObjectProvider<ApplicationModulesRuntime> runtime) {
        return metadata.isPresent() ? ApplicationModuleIdentifiers.of(metadata.getIdentifiers()) : ApplicationModuleIdentifiers.of((ApplicationModules)((ApplicationModulesRuntime)runtime.getObject()).get());
    }

    static class ApplicationModulesBootstrap {
        private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationModulesBootstrap.class);
        private static final ApplicationModulesFactory BOOTSTRAP;
        private final CompletableFuture<ApplicationModules> modules;

        ApplicationModulesBootstrap(Class<?> applicationMainClass, @Nullable Executor executor) {
            Supplier<ApplicationModules> supplier = () -> ApplicationModulesBootstrap.initializeApplicationModules(applicationMainClass);
            this.modules = executor == null ? CompletableFuture.supplyAsync(supplier) : CompletableFuture.supplyAsync(supplier, executor);
        }

        CompletableFuture<ApplicationModules> getApplicationModules() {
            return this.modules;
        }

        static ApplicationModules initializeApplicationModules(Class<?> applicationMainClass) {
            LOGGER.debug("Obtaining Spring Modulith application modules\u2026");
            ApplicationModules result = BOOTSTRAP.of(applicationMainClass);
            long numberOfModules = result.stream().count();
            if (numberOfModules == 0L) {
                LOGGER.warn("No application modules detected!");
            } else {
                LOGGER.debug("Detected {} application modules: {}", (Object)numberOfModules, result.stream().map(ApplicationModule::getIdentifier).toList());
            }
            return result;
        }

        static {
            List factories = SpringFactoriesLoader.loadFactories(ApplicationModulesFactory.class, (ClassLoader)ApplicationModulesBootstrap.class.getClassLoader());
            BOOTSTRAP = !factories.isEmpty() ? (ApplicationModulesFactory)factories.get(0) : ApplicationModulesFactory.defaultFactory();
        }
    }

    static class RuntimeApplicationModuleVerifier
    implements BeanFactoryInitializer<ListableBeanFactory>,
    SmartInitializingSingleton {
        private final CompletableFuture<Void> modules;

        RuntimeApplicationModuleVerifier(CompletableFuture<ApplicationModules> modules, ObjectProvider<VerificationOptions> verification) {
            this.modules = modules.thenAccept(it -> {
                it.verify((VerificationOptions)verification.getIfAvailable(VerificationOptions::defaults));
                LOG.info("Spring Modulith application module verification completed successfully.");
            });
        }

        public void afterSingletonsInstantiated() {
            this.modules.join();
        }

        public void initialize(ListableBeanFactory beanFactory) {
        }
    }

    @AutoConfiguration
    @ConditionalOnMissingClass(value={"com.tngtech.archunit.core.importer.ClassFileImporter"})
    static class ArchUnitRuntimeDependencyMissingConfiguration {
        private static final String DESCRIPTION = "The Spring Modulith runtime support requires ArchUnit to be on the runtime classpath. This might be caused by it declared as test scope dependency, as it usually is used in tests only.";
        private static final String SUGGESTED_ACTION = "Add ArchUnit to your project and ensure it configured to live in the runtime classpath at least.";

        ArchUnitRuntimeDependencyMissingConfiguration() {
            throw new MissingRuntimeDependency(DESCRIPTION, SUGGESTED_ACTION);
        }
    }

    @AutoConfiguration
    @ConditionalOnClass(value={Flyway.class, FlywayMigrationStrategy.class})
    static class SpringModulithFlywayAutoConfiguration {
        SpringModulithFlywayAutoConfiguration() {
        }

        @Bean
        @ConditionalOnProperty(name={"spring.modulith.runtime.flyway-enabled"}, havingValue="true")
        SpringModulithFlywayMigrationStrategy springModulithFlywayMigrationStrategy(ApplicationModuleIdentifiers identifiers, BeanFactory factory) {
            ModuleFilter filter = new ModuleFilter(factory);
            ApplicationModuleIdentifiers filtered = ApplicationModuleIdentifiers.of(identifiers.stream().filter(filter).toList());
            return new SpringModulithFlywayMigrationStrategy(filtered);
        }
    }

    private static class ModuleFilter
    implements Predicate<ApplicationModuleIdentifier> {
        private static final boolean IN_TEST = ClassUtils.isPresent((String)"org.springframework.modulith.test.ModuleTestExecution", (ClassLoader)SpringModulithFlywayMigrationStrategy.class.getClassLoader());
        private final BeanFactory factory;

        ModuleFilter(BeanFactory factory) {
            this.factory = factory;
        }

        @Override
        public boolean test(ApplicationModuleIdentifier identifier) {
            if (!IN_TEST) {
                return true;
            }
            ModuleTestExecution execution = (ModuleTestExecution)this.factory.getBeanProvider(ModuleTestExecution.class).getIfAvailable();
            return execution != null ? execution.isIncludedInExecution(identifier) : true;
        }
    }
}

