/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mock.web.server;

import org.jspecify.annotations.Nullable;
import org.springframework.http.codec.ServerCodecConfigurer;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.mock.http.server.reactive.MockServerHttpRequest;
import org.springframework.mock.http.server.reactive.MockServerHttpResponse;
import org.springframework.web.server.WebSession;
import org.springframework.web.server.adapter.DefaultServerWebExchange;
import org.springframework.web.server.i18n.AcceptHeaderLocaleContextResolver;
import org.springframework.web.server.i18n.LocaleContextResolver;
import org.springframework.web.server.session.DefaultWebSessionManager;
import org.springframework.web.server.session.WebSessionManager;
import reactor.core.publisher.Mono;

public final class MockServerWebExchange
extends DefaultServerWebExchange {
    private MockServerWebExchange(MockServerHttpRequest request, WebSessionManager sessionManager) {
        super((ServerHttpRequest)request, (ServerHttpResponse)new MockServerHttpResponse(), sessionManager, ServerCodecConfigurer.create(), (LocaleContextResolver)new AcceptHeaderLocaleContextResolver());
    }

    public MockServerHttpResponse getResponse() {
        return (MockServerHttpResponse)super.getResponse();
    }

    public static MockServerWebExchange from(MockServerHttpRequest request) {
        return MockServerWebExchange.builder(request).build();
    }

    public static MockServerWebExchange from(MockServerHttpRequest.BaseBuilder<?> requestBuilder) {
        return MockServerWebExchange.builder(requestBuilder).build();
    }

    public static Builder builder(MockServerHttpRequest request) {
        return new Builder(request);
    }

    public static Builder builder(MockServerHttpRequest.BaseBuilder<?> requestBuilder) {
        return new Builder(requestBuilder.build());
    }

    public static class Builder {
        private final MockServerHttpRequest request;
        private @Nullable WebSessionManager sessionManager;

        public Builder(MockServerHttpRequest request) {
            this.request = request;
        }

        public Builder session(WebSession session) {
            this.sessionManager = exchange -> Mono.just((Object)session);
            return this;
        }

        public Builder sessionManager(WebSessionManager sessionManager) {
            this.sessionManager = sessionManager;
            return this;
        }

        public MockServerWebExchange build() {
            return new MockServerWebExchange(this.request, (WebSessionManager)(this.sessionManager != null ? this.sessionManager : new DefaultWebSessionManager()));
        }
    }
}

