/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.autoconfigure;

import com.github.heneke.thymeleaf.togglz.TogglzDialect;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.Servlet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.togglz.console.TogglzConsoleServlet;
import org.togglz.core.activation.ActivationStrategyProvider;
import org.togglz.core.activation.DefaultActivationStrategyProvider;
import org.togglz.core.logging.Log;
import org.togglz.core.logging.LogFactory;
import org.togglz.core.manager.EmptyFeatureProvider;
import org.togglz.core.manager.EnumBasedFeatureProvider;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.manager.FeatureManagerBuilder;
import org.togglz.core.repository.StateRepository;
import org.togglz.core.repository.cache.CachingStateRepository;
import org.togglz.core.repository.composite.CompositeStateRepository;
import org.togglz.core.repository.file.FileBasedStateRepository;
import org.togglz.core.repository.mem.InMemoryStateRepository;
import org.togglz.core.repository.property.PropertyBasedStateRepository;
import org.togglz.core.repository.property.PropertySource;
import org.togglz.core.spi.ActivationStrategy;
import org.togglz.core.spi.FeatureProvider;
import org.togglz.core.user.NoOpUserProvider;
import org.togglz.core.user.UserProvider;
import org.togglz.spring.boot.autoconfigure.PropertiesPropertySource;
import org.togglz.spring.boot.autoconfigure.TogglzApplicationContextBinderApplicationListener;
import org.togglz.spring.boot.autoconfigure.TogglzEndpoint;
import org.togglz.spring.boot.autoconfigure.TogglzProperties;
import org.togglz.spring.security.SpringSecurityUserProvider;

@Configuration
@ConditionalOnProperty(prefix="togglz", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={TogglzProperties.class})
public class TogglzAutoConfiguration {
    private static final Log log = LogFactory.getLog(TogglzAutoConfiguration.class);

    @Bean
    public TogglzApplicationContextBinderApplicationListener togglzApplicationContextBinderApplicationListener() {
        return new TogglzApplicationContextBinderApplicationListener();
    }

    @Configuration
    @ConditionalOnClass(value={TogglzDialect.class})
    protected static class ThymeleafTogglzDialectConfiguration {
        protected ThymeleafTogglzDialectConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        public TogglzDialect togglzDialect() {
            return new TogglzDialect();
        }
    }

    @Configuration
    @ConditionalOnClass(value={Endpoint.class})
    @ConditionalOnMissingBean(value={TogglzEndpoint.class})
    @ConditionalOnProperty(prefix="togglz.endpoint", name={"enabled"}, matchIfMissing=true)
    protected static class TogglzEndpointConfiguration {
        @Autowired
        private TogglzProperties properties;

        protected TogglzEndpointConfiguration() {
        }

        @Bean
        public TogglzEndpoint togglzEndpoint(FeatureManager featureManager) {
            return new TogglzEndpoint(featureManager);
        }
    }

    @Configuration
    @ConditionalOnWebApplication
    @ConditionalOnClass(value={TogglzConsoleServlet.class})
    @ConditionalOnProperty(prefix="togglz.console", name={"enabled"}, matchIfMissing=true)
    protected static class TogglzConsoleConfiguration {
        @Autowired
        private TogglzProperties properties;

        protected TogglzConsoleConfiguration() {
        }

        @Bean
        public ServletRegistrationBean togglzConsole() {
            String path = this.properties.getConsole().getPath();
            String urlMapping = path.endsWith("/") ? path + "*" : path + "/*";
            TogglzConsoleServlet servlet = new TogglzConsoleServlet();
            servlet.setSecured(this.properties.getConsole().isSecured());
            return new ServletRegistrationBean((Servlet)servlet, new String[]{urlMapping});
        }
    }

    @Configuration
    @ConditionalOnClass(value={EnableWebSecurity.class, AuthenticationEntryPoint.class, SpringSecurityUserProvider.class})
    @ConditionalOnMissingBean(value={UserProvider.class})
    protected static class SpringSecurityUserProviderConfiguration {
        @Autowired
        private TogglzProperties properties;

        protected SpringSecurityUserProviderConfiguration() {
        }

        @Bean
        public UserProvider userProvider() {
            return new SpringSecurityUserProvider(this.properties.getConsole().getFeatureAdminAuthority());
        }
    }

    @Configuration
    @ConditionalOnMissingClass(value={"org.springframework.security.config.annotation.web.configuration.EnableWebSecurity"})
    @ConditionalOnMissingBean(value={UserProvider.class})
    protected static class UserProviderConfiguration {
        @Autowired
        private TogglzProperties properties;

        protected UserProviderConfiguration() {
        }

        @Bean
        public UserProvider userProvider() {
            return new NoOpUserProvider();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={StateRepository.class})
    protected static class StateRepositoryConfiguration {
        @Autowired
        private ResourceLoader resourceLoader = new DefaultResourceLoader();
        @Autowired
        private TogglzProperties properties;

        protected StateRepositoryConfiguration() {
        }

        @Bean
        public StateRepository stateRepository() throws IOException {
            InMemoryStateRepository stateRepository;
            Map<String, String> features = this.properties.getFeatures();
            String featuresFile = this.properties.getFeaturesFile();
            if (featuresFile != null) {
                Resource resource = this.resourceLoader.getResource(featuresFile);
                Integer minCheckInterval = this.properties.getFeaturesFileMinCheckInterval();
                stateRepository = minCheckInterval != null ? new FileBasedStateRepository(resource.getFile(), minCheckInterval.intValue()) : new FileBasedStateRepository(resource.getFile());
            } else if (features != null && features.size() > 0) {
                Properties props = new Properties();
                props.putAll(features);
                PropertiesPropertySource propertySource = new PropertiesPropertySource(props);
                stateRepository = new PropertyBasedStateRepository((PropertySource)propertySource);
            } else {
                stateRepository = new InMemoryStateRepository();
            }
            if (this.properties.getCache().isEnabled()) {
                stateRepository = new CachingStateRepository((StateRepository)stateRepository, this.properties.getCache().getTimeToLive(), this.properties.getCache().getTimeUnit());
            }
            return stateRepository;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={ActivationStrategyProvider.class})
    protected static class ActivationStrategyProviderConfiguration {
        @Autowired(required=false)
        private List<ActivationStrategy> activationStrategies;

        protected ActivationStrategyProviderConfiguration() {
        }

        @Bean
        public ActivationStrategyProvider activationStrategyProvider() {
            DefaultActivationStrategyProvider provider = new DefaultActivationStrategyProvider();
            if (this.activationStrategies != null && this.activationStrategies.size() > 0) {
                provider.addActivationStrategies(this.activationStrategies);
            }
            return provider;
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={FeatureManager.class})
    protected static class FeatureManagerConfiguration {
        @Autowired
        private TogglzProperties properties;

        protected FeatureManagerConfiguration() {
        }

        @Bean
        public FeatureManager featureManager(FeatureProvider featureProvider, List<StateRepository> stateRepositories, UserProvider userProvider, ActivationStrategyProvider activationStrategyProvider) {
            StateRepository stateRepository = null;
            if (stateRepositories.size() == 1) {
                stateRepository = stateRepositories.get(0);
            } else if (stateRepositories.size() > 1) {
                stateRepository = new CompositeStateRepository(stateRepositories.toArray(new StateRepository[stateRepositories.size()]));
            }
            if (this.properties.getCache().isEnabled() && !(stateRepository instanceof CachingStateRepository)) {
                stateRepository = new CachingStateRepository(stateRepository, this.properties.getCache().getTimeToLive(), this.properties.getCache().getTimeUnit());
            }
            FeatureManagerBuilder featureManagerBuilder = new FeatureManagerBuilder();
            String name = this.properties.getFeatureManagerName();
            if (name != null && name.length() > 0) {
                featureManagerBuilder.name(name);
            }
            featureManagerBuilder.featureProvider(featureProvider).stateRepository(stateRepository).userProvider(userProvider).activationStrategyProvider(activationStrategyProvider).build();
            return featureManagerBuilder.build();
        }
    }

    @Configuration
    @ConditionalOnMissingBean(value={FeatureProvider.class})
    protected static class FeatureProviderConfiguration {
        @Autowired
        private TogglzProperties properties;

        protected FeatureProviderConfiguration() {
        }

        @Bean
        public FeatureProvider featureProvider() {
            Class[] featureEnums = this.properties.getFeatureEnums();
            if (featureEnums != null && featureEnums.length > 0) {
                return new EnumBasedFeatureProvider(featureEnums);
            }
            log.warn("Creating a dummy feature provider as neither a FeatureProvider bean was provided nor the 'togglz.feature-enums' property was set!");
            return new EmptyFeatureProvider();
        }
    }
}

