/*
 * Decompiled with CFR 0.152.
 */
package org.togglz.spring.boot.autoconfigure;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.endpoint.AbstractEndpoint;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.Assert;
import org.togglz.core.Feature;
import org.togglz.core.manager.FeatureManager;
import org.togglz.core.repository.FeatureState;

@ConfigurationProperties(prefix="togglz.endpoint", ignoreUnknownFields=true)
public class TogglzEndpoint
extends AbstractEndpoint<List<TogglzFeature>> {
    private final FeatureManager featureManager;

    public TogglzEndpoint(FeatureManager featureManager) {
        super("togglz");
        Assert.notNull((Object)featureManager, (String)"FeatureManager must not be null");
        this.featureManager = featureManager;
    }

    public List<TogglzFeature> invoke() {
        ArrayList<TogglzFeature> features = new ArrayList<TogglzFeature>();
        for (Feature feature : this.featureManager.getFeatures()) {
            FeatureState featureState = this.featureManager.getFeatureState(feature);
            features.add(new TogglzFeature(feature, featureState));
        }
        return features;
    }

    public static class TogglzFeature {
        private String name;
        private boolean enabled;
        private String strategy;
        private Map<String, String> params;

        public TogglzFeature(Feature feature, FeatureState featureState) {
            this.name = feature.name();
            this.enabled = featureState.isEnabled();
            this.strategy = featureState.getStrategyId();
            this.params = featureState.getParameterMap();
        }

        public String getName() {
            return this.name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getStrategy() {
            return this.strategy;
        }

        public Map<String, String> getParams() {
            return this.params;
        }
    }
}

