/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.maven.utils.proxy;

import org.apache.maven.execution.MavenSession;
import org.whitesource.maven.utils.proxy.ProxySettingsProvider;
import org.whitesource.maven.utils.proxy.impl.EclipseAetherProxySettingsProvider;
import org.whitesource.maven.utils.proxy.impl.SonatypeAetherProxySettingsProvider;

public class ProxySettingsProviderFactory {
    private static final boolean isEclipseAetherLoaded = ProxySettingsProviderFactory.isExistsInClasspath("org.eclipse.aether.repository.Proxy");

    private static boolean isExistsInClasspath(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static ProxySettingsProvider getProxySettingsProviderForUrl(String url, MavenSession session) {
        if (isEclipseAetherLoaded) {
            return new EclipseAetherProxySettingsProvider(url, session);
        }
        return new SonatypeAetherProxySettingsProvider(url, session);
    }

    private ProxySettingsProviderFactory() {
    }
}

