/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.maven.utils.proxy.impl;

import org.apache.maven.execution.MavenSession;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.whitesource.maven.utils.proxy.ProxySettings;
import org.whitesource.maven.utils.proxy.ProxySettingsProvider;
import org.whitesource.maven.utils.proxy.impl.ProxySettingsImpl;

public class SonatypeAetherProxySettingsProvider
implements ProxySettingsProvider {
    private Proxy proxy;

    public SonatypeAetherProxySettingsProvider(String url, MavenSession session) {
        this.validateArgs(url, session);
        RemoteRepository dummyRepo = new RemoteRepository().setUrl(url);
        this.proxy = session.getRepositorySession().getProxySelector().getProxy(dummyRepo);
    }

    @Override
    public boolean isProxyConfigured() {
        return this.proxy != null;
    }

    @Override
    public ProxySettings getProxySettings() {
        if (!this.isProxyConfigured()) {
            return null;
        }
        String username = null;
        String password = null;
        Authentication auth = this.proxy.getAuthentication();
        if (auth != null) {
            username = auth.getUsername();
            password = auth.getPassword();
        }
        String host = this.proxy.getHost();
        int port = this.proxy.getPort();
        return new ProxySettingsImpl(host, port, username, password);
    }

    private void validateArgs(String url, MavenSession session) {
        if (url == null) {
            throw new IllegalArgumentException("URL can't be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("MavenSession can't be null");
        }
    }
}

