/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.maven.utils.proxy.impl;

import org.apache.maven.execution.MavenSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.Authentication;
import org.eclipse.aether.repository.AuthenticationContext;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.whitesource.maven.utils.Invoker;
import org.whitesource.maven.utils.proxy.ProxySettings;
import org.whitesource.maven.utils.proxy.ProxySettingsProvider;
import org.whitesource.maven.utils.proxy.impl.ProxySettingsImpl;

public class EclipseAetherProxySettingsProvider
implements ProxySettingsProvider {
    private Proxy proxy;
    RemoteRepository.Builder remoteRepositoryBuilder;
    RepositorySystemSession repositorySystemSession;

    public EclipseAetherProxySettingsProvider(String url, MavenSession session) {
        this.validateArgs(url, session);
        this.remoteRepositoryBuilder = new RemoteRepository.Builder(null, null, url);
        RemoteRepository dummyRepo = this.remoteRepositoryBuilder.build();
        this.repositorySystemSession = (RepositorySystemSession)Invoker.invoke(session, "getRepositorySession");
        this.proxy = this.repositorySystemSession.getProxySelector().getProxy(dummyRepo);
    }

    @Override
    public boolean isProxyConfigured() {
        return this.proxy != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxySettings getProxySettings() {
        if (!this.isProxyConfigured()) {
            return null;
        }
        String username = null;
        String password = null;
        Authentication auth = this.proxy.getAuthentication();
        if (auth != null) {
            RemoteRepository dummyRepo = this.remoteRepositoryBuilder.setAuthentication(auth).build();
            AuthenticationContext authenticationContext = AuthenticationContext.forRepository((RepositorySystemSession)this.repositorySystemSession, (RemoteRepository)dummyRepo);
            try {
                auth.fill(authenticationContext, null, null);
                username = (String)authenticationContext.get("username", String.class);
                password = (String)authenticationContext.get("password", String.class);
            }
            finally {
                AuthenticationContext.close((AuthenticationContext)authenticationContext);
            }
        }
        String host = this.proxy.getHost();
        int port = this.proxy.getPort();
        return new ProxySettingsImpl(host, port, username, password);
    }

    private void validateArgs(String url, MavenSession session) {
        if (url == null) {
            throw new IllegalArgumentException("URL can't be null");
        }
        if (session == null) {
            throw new IllegalArgumentException("MavenSession can't be null");
        }
    }
}

