/*
 * Decompiled with CFR 0.152.
 */
package org.whitesource.agent.client;

import com.btr.proxy.search.ProxySearch;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.whitesource.agent.api.dispatch.CheckPoliciesRequest;
import org.whitesource.agent.api.dispatch.CheckPoliciesResult;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceRequest;
import org.whitesource.agent.api.dispatch.CheckPolicyComplianceResult;
import org.whitesource.agent.api.dispatch.CheckVulnerabilitiesRequest;
import org.whitesource.agent.api.dispatch.CheckVulnerabilitiesResult;
import org.whitesource.agent.api.dispatch.ConfigurationRequest;
import org.whitesource.agent.api.dispatch.ConfigurationResult;
import org.whitesource.agent.api.dispatch.GetDependencyDataRequest;
import org.whitesource.agent.api.dispatch.GetDependencyDataResult;
import org.whitesource.agent.api.dispatch.RequestType;
import org.whitesource.agent.api.dispatch.ResultEnvelope;
import org.whitesource.agent.api.dispatch.ServiceRequest;
import org.whitesource.agent.api.dispatch.SummaryScanRequest;
import org.whitesource.agent.api.dispatch.SummaryScanResult;
import org.whitesource.agent.api.dispatch.UpdateInventoryRequest;
import org.whitesource.agent.api.dispatch.UpdateInventoryResult;
import org.whitesource.agent.client.WssSSLSocketFactory;
import org.whitesource.agent.client.WssServiceClient;
import org.whitesource.agent.client.WssServiceException;
import org.whitesource.agent.utils.ZipUtils;

public class WssServiceClientImpl
implements WssServiceClient {
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final int TO_MILLISECONDS = 60000;
    private static final String UTF_8 = "UTF-8";
    private static final Log logger = LogFactory.getLog(WssServiceClientImpl.class);
    private static final String TLS = "TLS";
    public static final String SOME_PASSWORD = "some password";
    protected String serviceUrl;
    protected CloseableHttpClient httpClient;
    protected Gson gson = new Gson();
    protected int connectionTimeout;

    public WssServiceClientImpl() {
        this("https://saas.whitesourcesoftware.com/agent");
    }

    public WssServiceClientImpl(String serviceUrl) {
        this(serviceUrl, true);
    }

    public WssServiceClientImpl(String serviceUrl, boolean setProxy) {
        this(serviceUrl, setProxy, 60);
    }

    public WssServiceClientImpl(String serviceUrl, boolean setProxy, int connectionTimeoutMinutes) {
        this(serviceUrl, setProxy, connectionTimeoutMinutes, false);
    }

    public WssServiceClientImpl(String serviceUrl, boolean setProxy, int connectionTimeoutMinutes, boolean ignoreCertificateCheck) {
        this.serviceUrl = serviceUrl == null || serviceUrl.length() == 0 ? "https://saas.whitesourcesoftware.com/agent" : serviceUrl;
        this.connectionTimeout = connectionTimeoutMinutes <= 0 ? 3600000 : connectionTimeoutMinutes * 60000;
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)this.connectionTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)this.connectionTimeout);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)true);
        this.httpClient = new DefaultHttpClient();
        if (ignoreCertificateCheck) {
            try {
                logger.warn((Object)"Security Warning - Trusting all certificates");
                KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                char[] password = SOME_PASSWORD.toCharArray();
                keystore.load(null, password);
                WssSSLSocketFactory sf = new WssSSLSocketFactory(keystore);
                sf.setHostnameVerifier(SSLSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
                HttpProtocolParams.setVersion((HttpParams)params, (ProtocolVersion)HttpVersion.HTTP_1_1);
                HttpProtocolParams.setContentCharset((HttpParams)params, (String)UTF_8);
                SchemeRegistry registry = new SchemeRegistry();
                registry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
                registry.register(new Scheme("https", (SocketFactory)sf, 443));
                ThreadSafeClientConnManager ccm = new ThreadSafeClientConnManager((HttpParams)params, registry);
                this.httpClient = new DefaultHttpClient((ClientConnectionManager)ccm, (HttpParams)params);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
        if (setProxy) {
            this.findDefaultProxy();
        }
    }

    @Override
    public UpdateInventoryResult updateInventory(UpdateInventoryRequest request) throws WssServiceException {
        return (UpdateInventoryResult)this.service((ServiceRequest)request);
    }

    @Override
    public CheckPoliciesResult checkPolicies(CheckPoliciesRequest request) throws WssServiceException {
        return (CheckPoliciesResult)this.service((ServiceRequest)request);
    }

    @Override
    public CheckPolicyComplianceResult checkPolicyCompliance(CheckPolicyComplianceRequest request) throws WssServiceException {
        return (CheckPolicyComplianceResult)this.service((ServiceRequest)request);
    }

    @Override
    public GetDependencyDataResult getDependencyData(GetDependencyDataRequest request) throws WssServiceException {
        return (GetDependencyDataResult)this.service((ServiceRequest)request);
    }

    @Override
    public SummaryScanResult summaryScan(SummaryScanRequest request) throws WssServiceException {
        return (SummaryScanResult)this.service((ServiceRequest)request);
    }

    @Override
    public CheckVulnerabilitiesResult checkVulnerabilities(CheckVulnerabilitiesRequest request) throws WssServiceException {
        return (CheckVulnerabilitiesResult)this.service((ServiceRequest)request);
    }

    @Override
    public ConfigurationResult getConfiguration(ConfigurationRequest request) throws WssServiceException {
        return (ConfigurationResult)this.service((ServiceRequest)request);
    }

    @Override
    public void shutdown() {
        this.httpClient.getConnectionManager().shutdown();
    }

    @Override
    public void setProxy(String host, int port, String username, String password) {
        if (host == null || host.trim().length() == 0) {
            return;
        }
        if (port < 0 || port > 65535) {
            return;
        }
        HttpHost proxy = new HttpHost(host, port);
        DefaultProxyRoutePlanner routePlanner = new DefaultProxyRoutePlanner(proxy);
        this.httpClient = HttpClients.custom().setRoutePlanner((HttpRoutePlanner)routePlanner).build();
        logger.info((Object)("Using proxy: " + proxy.toHostString()));
        if (username != null && username.trim().length() > 0) {
            UsernamePasswordCredentials credentials;
            logger.info((Object)("Proxy username: " + username));
            if (username.indexOf(47) >= 0) {
                credentials = new NTCredentials(username + ":" + password);
            } else if (username.indexOf(92) >= 0) {
                username = username.replace('\\', '/');
                credentials = new NTCredentials(username + ":" + password);
            } else {
                credentials = new UsernamePasswordCredentials(username, password);
            }
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(AuthScope.ANY, (Credentials)credentials);
            this.httpClient = HttpClientBuilder.create().setProxy(proxy).setDefaultCredentialsProvider((CredentialsProvider)credsProvider).build();
        }
    }

    @Override
    public void setConnectionTimeout(int timeout) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)this.httpClient.getParams(), (int)timeout);
        HttpConnectionParams.setSoTimeout((HttpParams)this.httpClient.getParams(), (int)timeout);
    }

    protected <R> R service(ServiceRequest<R> request) throws WssServiceException {
        Object result;
        String response = "";
        try {
            HttpRequestBase httpRequest = this.createHttpRequest(request);
            RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard").build();
            httpRequest.setConfig(requestConfig);
            logger.trace((Object)("Calling White Source service: " + request));
            response = (String)this.httpClient.execute((HttpUriRequest)httpRequest, (ResponseHandler)new BasicResponseHandler());
            String data = this.extractResultData(response);
            logger.trace((Object)("Result data is: " + data));
            switch (request.type()) {
                case UPDATE: {
                    result = this.gson.fromJson(data, UpdateInventoryResult.class);
                    break;
                }
                case CHECK_POLICIES: {
                    result = this.gson.fromJson(data, CheckPoliciesResult.class);
                    break;
                }
                case CHECK_POLICY_COMPLIANCE: {
                    result = this.gson.fromJson(data, CheckPolicyComplianceResult.class);
                    break;
                }
                case CHECK_VULNERABILITIES: {
                    result = this.gson.fromJson(data, CheckVulnerabilitiesResult.class);
                    break;
                }
                case GET_DEPENDENCY_DATA: {
                    result = this.gson.fromJson(data, GetDependencyDataResult.class);
                    break;
                }
                case SUMMARY_SCAN: {
                    result = this.gson.fromJson(data, SummaryScanResult.class);
                    break;
                }
                case GET_CONFIGURATION: {
                    result = this.gson.fromJson(data, ConfigurationResult.class);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported request type.");
                }
            }
        }
        catch (JsonSyntaxException e) {
            throw new WssServiceException("JsonSyntax exception. Response data is:  " + response + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new WssServiceException("Unexpected error. Response data is: " + response + e.getMessage(), e);
        }
        return (R)result;
    }

    protected <R> HttpRequestBase createHttpRequest(ServiceRequest<R> request) throws IOException, WssServiceException {
        HttpPost httpRequest = new HttpPost(this.serviceUrl);
        httpRequest.setHeader("Accept", "application/json");
        RequestType requestType = request.type();
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        nvps.add(new BasicNameValuePair("type", requestType.toString()));
        nvps.add(new BasicNameValuePair("agent", request.agent()));
        nvps.add(new BasicNameValuePair("agentVersion", request.agentVersion()));
        nvps.add(new BasicNameValuePair("token", request.orgToken()));
        nvps.add(new BasicNameValuePair("userKey", request.userKey()));
        nvps.add(new BasicNameValuePair("requesterEmail", request.requesterEmail()));
        nvps.add(new BasicNameValuePair("product", request.product()));
        nvps.add(new BasicNameValuePair("productVersion", request.productVersion()));
        nvps.add(new BasicNameValuePair("timeStamp", String.valueOf(request.timeStamp())));
        nvps.add(new BasicNameValuePair("pluginVersion", String.valueOf(request.pluginVersion())));
        nvps.add(new BasicNameValuePair("aggregateModules", String.valueOf(request.aggregateModules())));
        nvps.add(new BasicNameValuePair("preserveModuleStructure", String.valueOf(request.preserveModuleStructure())));
        nvps.add(new BasicNameValuePair("aggregateProjectName", request.aggregateProjectName()));
        nvps.add(new BasicNameValuePair("aggregateProjectToken", request.aggregateProjectToken()));
        nvps.add(new BasicNameValuePair("logData", request.logData()));
        nvps.add(new BasicNameValuePair("scanComment", request.scanComment()));
        nvps.add(new BasicNameValuePair("productToken", request.productToken()));
        String jsonDiff = null;
        switch (requestType) {
            case UPDATE: {
                UpdateInventoryRequest updateInventoryRequest = (UpdateInventoryRequest)request;
                nvps.add(new BasicNameValuePair("updateType", updateInventoryRequest.getUpdateType().toString()));
                jsonDiff = this.gson.toJson((Object)updateInventoryRequest.getProjects());
                break;
            }
            case CHECK_POLICIES: {
                jsonDiff = this.gson.toJson((Object)((CheckPoliciesRequest)request).getProjects());
                break;
            }
            case CHECK_POLICY_COMPLIANCE: {
                CheckPolicyComplianceRequest checkPolicyComplianceRequest = (CheckPolicyComplianceRequest)request;
                nvps.add(new BasicNameValuePair("forceCheckAllDependencies", String.valueOf(checkPolicyComplianceRequest.isForceCheckAllDependencies())));
                jsonDiff = this.gson.toJson((Object)checkPolicyComplianceRequest.getProjects());
                break;
            }
            case CHECK_VULNERABILITIES: {
                jsonDiff = this.gson.toJson((Object)((CheckVulnerabilitiesRequest)request).getProjects());
                break;
            }
            case GET_DEPENDENCY_DATA: {
                jsonDiff = this.gson.toJson((Object)((GetDependencyDataRequest)request).getProjects());
                break;
            }
            case SUMMARY_SCAN: {
                SummaryScanRequest summaryScanRequest = (SummaryScanRequest)request;
                jsonDiff = this.gson.toJson((Object)summaryScanRequest.getProjects());
                break;
            }
            case GET_CONFIGURATION: {
                jsonDiff = this.gson.toJson((Object)((ConfigurationRequest)request).getProjects());
                break;
            }
        }
        String compressedString = ZipUtils.compressString(jsonDiff);
        nvps.add(new BasicNameValuePair("diff", compressedString));
        httpRequest.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, UTF_8));
        String httpRequestJson = this.gson.toJson((Object)httpRequest);
        return httpRequest;
    }

    protected String extractResultData(String response) throws IOException, WssServiceException {
        ResultEnvelope envelope = (ResultEnvelope)this.gson.fromJson(response, ResultEnvelope.class);
        if (envelope == null) {
            throw new WssServiceException("Empty response, response data is: " + response);
        }
        String message = envelope.getMessage();
        String data = envelope.getData();
        String requestToken = envelope.getRequestToken();
        if (1 != envelope.getStatus()) {
            throw new WssServiceException(message + ": " + data, requestToken);
        }
        return data;
    }

    private void findDefaultProxy() {
        ProxySearch proxySearch = new ProxySearch();
        proxySearch.addStrategy(ProxySearch.Strategy.JAVA);
        proxySearch.addStrategy(ProxySearch.Strategy.ENV_VAR);
        proxySearch.addStrategy(ProxySearch.Strategy.OS_DEFAULT);
        proxySearch.addStrategy(ProxySearch.Strategy.BROWSER);
        ProxySelector proxySelector = proxySearch.getProxySelector();
        if (proxySelector != null) {
            ProxySelector.setDefault(proxySelector);
            try {
                List<Proxy> proxyList = proxySelector.select(new URI(this.serviceUrl));
                if (proxyList != null && !proxyList.isEmpty()) {
                    for (Proxy proxy : proxyList) {
                        InetSocketAddress address = (InetSocketAddress)proxy.address();
                        if (address == null) continue;
                        String host = address.getHostName();
                        int port = address.getPort();
                        String username = System.getProperty(HTTP_PROXY_USER);
                        String password = System.getProperty(HTTP_PROXY_PASSWORD);
                        this.setProxy(host, port, username, password);
                    }
                }
            }
            catch (URISyntaxException e) {
                logger.error((Object)("Bad service url: " + this.serviceUrl), (Throwable)e);
            }
        }
    }

    public String getServiceUrl() {
        return this.serviceUrl;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }
}

