/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.behavior.styleswitcher;

import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.IClusterable;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.IHeaderResponse;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class StyleSwitcher
extends Behavior {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference SS_JS = new JavaScriptResourceReference(StyleSwitcher.class, "styleswitcher.js");
    private final List<TitledResourceReferenceTuple> stylesheets = new ArrayList<TitledResourceReferenceTuple>();

    public void addStylesheet(String title, ResourceReference reference) {
        this.stylesheets.add(new TitledResourceReferenceTuple(title, reference));
    }

    public void renderHead(Component c, IHeaderResponse response) {
        response.renderJavaScriptReference(SS_JS);
        for (TitledResourceReferenceTuple stylesheet : this.stylesheets) {
            response.renderString((CharSequence)("<link rel=\"alternate stylesheet\" type=\"text/css\" href=\"" + RequestCycle.get().urlFor(stylesheet.reference, null) + "\" title=\"" + stylesheet.title + "\"/>"));
        }
    }

    private static class TitledResourceReferenceTuple
    implements IClusterable {
        private static final long serialVersionUID = 1L;
        private final String title;
        private final ResourceReference reference;

        public TitledResourceReferenceTuple(String title, ResourceReference reference) {
            this.title = title;
            this.reference = reference;
        }
    }

    public static class Javascript {
        public static String forActivatingStylesheet(String title) {
            return "StyleSwitcher.setActiveStyleSheet('" + title + "');";
        }

        private Javascript() {
        }
    }
}

