/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.minis.behavior.validator;

import org.apache.wicket.Component;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.validation.validator.StringValidator;

public class StringValidatorWithMaxLength {
    public static final String MAX_LENGTH = "maxlength";

    public static void addMaxLengthToTag(Component component, ComponentTag tag, int maxLength) {
        tag.put(MAX_LENGTH, maxLength);
    }

    public static StringValidator exactLength(int length) {
        return new StringValidator.ExactLengthValidator(length){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                super.onComponentTag(component, tag);
                StringValidatorWithMaxLength.addMaxLengthToTag(component, tag, this.getLength());
            }
        };
    }

    public static StringValidator lengthBetween(int minimum, int maximum) {
        return new StringValidator.LengthBetweenValidator(minimum, maximum){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                super.onComponentTag(component, tag);
                StringValidatorWithMaxLength.addMaxLengthToTag(component, tag, this.getMaximum());
            }
        };
    }

    public static StringValidator maximumLength(int maximum) {
        return new StringValidator.MaximumLengthValidator(maximum){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                super.onComponentTag(component, tag);
                StringValidatorWithMaxLength.addMaxLengthToTag(component, tag, this.getMaximum());
            }
        };
    }
}

